/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.mixin.block;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.itemrestrictions.level.block.ItemRestrictionsFurnaceBlockEntity;
import com.daqem.itemrestrictions.level.menu.ItemRestrictionsAbstractFurnaceMenu;
import com.daqem.itemrestrictions.level.player.ItemRestrictionsServerPlayer;
import com.daqem.itemrestrictions.networking.clientbound.ClientboundRestrictionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class MixinAbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
ItemRestrictionsFurnaceBlockEntity {
    @Unique
    @Nullable
    private UUID itemrestrictions$playerUUID;
    @Unique
    @Nullable
    private ServerPlayer itemrestrictions$player;
    @Unique
    private boolean itemrestrictions$isRestricted = false;
    @Shadow
    protected NonNullList<ItemStack> items;
    @Shadow
    int litTimeRemaining;
    @Unique
    private RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> itemrestrictions$quickCheck;

    protected MixinAbstractFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/crafting/RecipeType;)V"})
    private void init(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, RecipeType<? extends AbstractCookingRecipe> recipeType, CallbackInfo ci) {
        this.itemrestrictions$quickCheck = RecipeManager.createCheck(recipeType);
    }

    @Inject(at={@At(value="TAIL")}, method={"saveAdditional(Lnet/minecraft/world/level/storage/ValueOutput;)V"})
    private void saveAdditional(ValueOutput valueOutput, CallbackInfo ci) {
        ServerPlayer serverPlayer = this.itemrestrictions$getPlayer();
        if (serverPlayer != null) {
            valueOutput.putString("ItemRestrictionsServerPlayer", serverPlayer.getUUID().toString());
        } else {
            UUID uuid = this.itemrestrictions$getPlayerUUID();
            if (uuid != null) {
                valueOutput.putString("ItemRestrictionsServerPlayer", uuid.toString());
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional(Lnet/minecraft/world/level/storage/ValueInput;)V"})
    private void load(ValueInput valueInput, CallbackInfo ci) {
        valueInput.getString("ItemRestrictionsServerPlayer").ifPresent(uuid -> this.itemrestrictions$setPlayerUUID(UUID.fromString(uuid)));
    }

    @Inject(at={@At(value="HEAD")}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)V"}, cancellable=true)
    private static void serverTickRecipe(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, AbstractFurnaceBlockEntity abstractFurnaceBlockEntity, CallbackInfo ci) {
        if (abstractFurnaceBlockEntity instanceof ItemRestrictionsFurnaceBlockEntity) {
            ItemRestrictionsFurnaceBlockEntity block = (ItemRestrictionsFurnaceBlockEntity)abstractFurnaceBlockEntity;
            if (block.itemrestrictions$getPlayer() == null && block.itemrestrictions$getPlayerUUID() != null) {
                ServerPlayer player = serverLevel.getServer().getPlayerList().getPlayer(block.itemrestrictions$getPlayerUUID());
                block.itemrestrictions$setPlayer(player);
            }
            if (block.itemrestrictions$getPlayer() != null && !abstractFurnaceBlockEntity.getItem(0).isEmpty()) {
                if (!abstractFurnaceBlockEntity.getItem(1).isEmpty()) {
                    RecipeHolder<?> recipeHolder = block.itemrestrictions$getRecipe();
                    if (recipeHolder != null) {
                        ItemRestrictionsServerPlayer player;
                        Recipe recipe = recipeHolder.value();
                        RestrictionResult result = new RestrictionResult();
                        ServerPlayer serverPlayer = block.itemrestrictions$getPlayer();
                        if (serverPlayer instanceof ItemRestrictionsServerPlayer && (player = (ItemRestrictionsServerPlayer)serverPlayer) instanceof ArcPlayer) {
                            ArcPlayer arcPlayer = (ArcPlayer)player;
                            result = player.itemrestrictions$isRestricted(new ActionDataBuilder(arcPlayer, null).withData(ActionDataType.ITEM_STACK, (Object)recipe.assemble(null, (HolderLookup.Provider)((ServerPlayer)player).level().getServer().registryAccess())).build());
                        }
                        if (result.isRestricted(RestrictionType.SMELT)) {
                            if (block.itemrestrictions$isLit()) {
                                block.itemrestrictions$setLitTime(block.itemrestrictions$getLitTime() - 1);
                            }
                            blockState = (BlockState)blockState.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false));
                            serverLevel.setBlock(blockPos, blockState, 3);
                            MixinAbstractFurnaceBlockEntity.setChanged((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
                            ci.cancel();
                            MixinAbstractFurnaceBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.SMELT, block);
                            block.itemrestrictions$setRestricted(true);
                        }
                    }
                } else if (block.itemrestrictions$isRestricted()) {
                    MixinAbstractFurnaceBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.NONE, block);
                    block.itemrestrictions$setRestricted(false);
                }
            } else if (block.itemrestrictions$getPlayer() != null && block.itemrestrictions$isRestricted()) {
                MixinAbstractFurnaceBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.NONE, block);
                block.itemrestrictions$setRestricted(false);
            }
        }
    }

    @Unique
    private static void itemrestrictions$sendPacketCantCraft(RestrictionType type, ItemRestrictionsFurnaceBlockEntity block) {
        ItemRestrictionsAbstractFurnaceMenu menu;
        AbstractContainerMenu abstractContainerMenu = block.itemrestrictions$getPlayer().containerMenu;
        if (abstractContainerMenu instanceof ItemRestrictionsAbstractFurnaceMenu && (menu = (ItemRestrictionsAbstractFurnaceMenu)abstractContainerMenu).itemrestrictions$getContainer().equals((Object)block.itemrestrictions$getAbstractFurnaceBlockEntity())) {
            NetworkManager.sendToPlayer((ServerPlayer)block.itemrestrictions$getPlayer(), (CustomPacketPayload)new ClientboundRestrictionPacket(type));
        }
    }

    @Override
    @Nullable
    public ServerPlayer itemrestrictions$getPlayer() {
        return this.itemrestrictions$player;
    }

    @Override
    public void itemrestrictions$setPlayer(@Nullable ServerPlayer player) {
        this.itemrestrictions$player = player;
    }

    @Override
    @Nullable
    public UUID itemrestrictions$getPlayerUUID() {
        return this.itemrestrictions$playerUUID;
    }

    @Override
    public void itemrestrictions$setPlayerUUID(@Nullable UUID playerUUID) {
        this.itemrestrictions$playerUUID = playerUUID;
    }

    @Override
    public int itemrestrictions$getLitTime() {
        return this.litTimeRemaining;
    }

    @Override
    public void itemrestrictions$setLitTime(int litTime) {
        this.litTimeRemaining = litTime;
    }

    @Override
    public boolean itemrestrictions$isLit() {
        return this.itemrestrictions$getLitTime() > 0;
    }

    @Override
    @Nullable
    public RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> itemrestrictions$getQuickCheck() {
        return this.itemrestrictions$quickCheck;
    }

    @Override
    public AbstractFurnaceBlockEntity itemrestrictions$getAbstractFurnaceBlockEntity() {
        return (AbstractFurnaceBlockEntity)this;
    }

    @Override
    @Nullable
    public RecipeHolder<?> itemrestrictions$getRecipe() {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return null;
        }
        if (this.getItem(0).isEmpty()) {
            return null;
        }
        if (this.getItem(1).isEmpty()) {
            return null;
        }
        if (this.itemrestrictions$getQuickCheck() == null) {
            return null;
        }
        return Objects.requireNonNull(this.itemrestrictions$getQuickCheck()).getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)this.items.getFirst()), (ServerLevel)this.getLevel()).orElse(null);
    }

    @Override
    public void itemrestrictions$setRestricted(boolean restricted) {
        this.itemrestrictions$isRestricted = restricted;
    }

    @Override
    public boolean itemrestrictions$isRestricted() {
        return this.itemrestrictions$isRestricted;
    }
}

