/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.mixin.block;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.itemrestrictions.level.block.ItemRestrictionsBrewingStandBlockEntity;
import com.daqem.itemrestrictions.level.menu.ItemRestrictionsBrewingStandMenu;
import com.daqem.itemrestrictions.level.player.ItemRestrictionsServerPlayer;
import com.daqem.itemrestrictions.networking.clientbound.ClientboundRestrictionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrewingStandBlockEntity.class})
public abstract class MixinBrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
ItemRestrictionsBrewingStandBlockEntity {
    @Shadow
    int brewTime;
    @Shadow
    private NonNullList<ItemStack> items;
    @Shadow
    private boolean[] lastPotionCount;
    @Unique
    @Nullable
    private UUID itemrestrictions$playerUUID;
    @Unique
    @Nullable
    private ServerPlayer itemrestrictions$player;

    protected MixinBrewingStandBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(at={@At(value="TAIL")}, method={"saveAdditional(Lnet/minecraft/world/level/storage/ValueOutput;)V"})
    private void saveAdditional(ValueOutput valueOutput, CallbackInfo ci) {
        ServerPlayer serverPlayer = this.itemrestrictions$getPlayer();
        if (serverPlayer != null) {
            valueOutput.putString("ItemRestrictionsServerPlayer", serverPlayer.getUUID().toString());
        } else {
            UUID uuid = this.itemrestrictions$getPlayerUUID();
            if (uuid != null) {
                valueOutput.putString("ItemRestrictionsServerPlayer", uuid.toString());
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional(Lnet/minecraft/world/level/storage/ValueInput;)V"})
    private void load(ValueInput valueInput, CallbackInfo ci) {
        valueInput.getString("ItemRestrictionsServerPlayer").ifPresent(uuid -> this.itemrestrictions$setPlayerUUID(UUID.fromString(uuid)));
    }

    @Inject(at={@At(value="HEAD")}, method={"serverTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;)V"}, cancellable=true)
    private static void doBrew(Level level, BlockPos blockPos, BlockState blockState, BrewingStandBlockEntity brewingStandBlockEntity, CallbackInfo ci) {
        if (brewingStandBlockEntity instanceof ItemRestrictionsBrewingStandBlockEntity) {
            ItemRestrictionsBrewingStandBlockEntity block = (ItemRestrictionsBrewingStandBlockEntity)brewingStandBlockEntity;
            if (block.itemrestrictions$getPlayer() == null && block.itemrestrictions$getPlayerUUID() != null && level.getServer() != null) {
                ServerPlayer player = level.getServer().getPlayerList().getPlayer(block.itemrestrictions$getPlayerUUID());
                block.itemrestrictions$setPlayer(player);
            }
            if (block.itemrestrictions$getPlayer() != null && !brewingStandBlockEntity.getItem(3).isEmpty()) {
                if (!(brewingStandBlockEntity.getItem(0).isEmpty() && brewingStandBlockEntity.getItem(1).isEmpty() && brewingStandBlockEntity.getItem(2).isEmpty())) {
                    ItemStack ingredient = brewingStandBlockEntity.getItem(3);
                    for (int i = 0; i < 3; ++i) {
                        ItemRestrictionsServerPlayer player;
                        ItemStack potion = brewingStandBlockEntity.getItem(i);
                        ItemStack mixedPotion = level.potionBrewing().mix(ingredient, potion);
                        RestrictionResult result = new RestrictionResult();
                        ServerPlayer serverPlayer = block.itemrestrictions$getPlayer();
                        if (serverPlayer instanceof ItemRestrictionsServerPlayer && (player = (ItemRestrictionsServerPlayer)serverPlayer) instanceof ArcPlayer) {
                            ArcPlayer arcPlayer = (ArcPlayer)player;
                            result = player.itemrestrictions$isRestricted(new ActionDataBuilder(arcPlayer, null).withData(ActionDataType.ITEM_STACK, (Object)mixedPotion).build());
                        }
                        if (!result.isRestricted(RestrictionType.BREW)) continue;
                        block.itemrestrictions$setBrewTime(0);
                        MixinBrewingStandBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)brewingStandBlockEntity.getBlockState());
                        ci.cancel();
                        boolean[] bls = block.itemrestrictions$getPotionBits();
                        if (!Arrays.equals(bls, block.itemrestrictions$getLastPotionCount())) {
                            block.itemrestrictions$setLastPotionCount(bls);
                            BlockState blockState2 = blockState;
                            if (!(blockState.getBlock() instanceof BrewingStandBlock)) {
                                return;
                            }
                            for (int j = 0; j < BrewingStandBlock.HAS_BOTTLE.length; ++j) {
                                blockState2 = (BlockState)blockState2.setValue((Property)BrewingStandBlock.HAS_BOTTLE[j], (Comparable)Boolean.valueOf(bls[j]));
                            }
                            level.setBlock(blockPos, blockState2, 2);
                        }
                        MixinBrewingStandBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.BREW, block);
                        return;
                    }
                } else if (brewingStandBlockEntity.getItem(0).isEmpty() && brewingStandBlockEntity.getItem(1).isEmpty() && brewingStandBlockEntity.getItem(2).isEmpty()) {
                    MixinBrewingStandBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.NONE, block);
                }
            } else if (block.itemrestrictions$getPlayer() != null && brewingStandBlockEntity.getItem(3).isEmpty()) {
                MixinBrewingStandBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.NONE, block);
            }
        }
    }

    @Unique
    private static void itemrestrictions$sendPacketCantCraft(RestrictionType type, ItemRestrictionsBrewingStandBlockEntity block) {
        ItemRestrictionsBrewingStandMenu menu;
        AbstractContainerMenu abstractContainerMenu = block.itemrestrictions$getPlayer().containerMenu;
        if (abstractContainerMenu instanceof ItemRestrictionsBrewingStandMenu && (menu = (ItemRestrictionsBrewingStandMenu)abstractContainerMenu).itemrestrictions$getBrewingStand().equals((Object)block.itemrestrictions$getBrewingStandBlockEntity())) {
            NetworkManager.sendToPlayer((ServerPlayer)block.itemrestrictions$getPlayer(), (CustomPacketPayload)new ClientboundRestrictionPacket(type));
        }
    }

    @Override
    @Nullable
    public ServerPlayer itemrestrictions$getPlayer() {
        return this.itemrestrictions$player;
    }

    @Override
    public void itemrestrictions$setPlayer(@Nullable ServerPlayer player) {
        this.itemrestrictions$player = player;
    }

    @Override
    @Nullable
    public UUID itemrestrictions$getPlayerUUID() {
        return this.itemrestrictions$playerUUID;
    }

    @Override
    public void itemrestrictions$setPlayerUUID(@Nullable UUID playerUUID) {
        this.itemrestrictions$playerUUID = playerUUID;
    }

    @Override
    public void itemrestrictions$setBrewTime(int i) {
        this.brewTime = i;
    }

    @Override
    public boolean[] itemrestrictions$getPotionBits() {
        boolean[] bls = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            bls[i] = true;
        }
        return bls;
    }

    @Override
    public boolean[] itemrestrictions$getLastPotionCount() {
        return this.lastPotionCount;
    }

    @Override
    public void itemrestrictions$setLastPotionCount(boolean[] lastPotionCount) {
        this.lastPotionCount = lastPotionCount;
    }

    @Override
    public BrewingStandBlockEntity itemrestrictions$getBrewingStandBlockEntity() {
        return (BrewingStandBlockEntity)this;
    }
}

