/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.data;

import com.daqem.itemrestrictions.ItemRestrictions;
import com.daqem.itemrestrictions.ItemRestrictionsExpectPlatform;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;

public class ItemRestrictionManager
extends class_4080<List<ItemRestriction>> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeHierarchyAdapter(ItemRestriction.class, (Object)new ItemRestriction.Serializer()).create();
    private ImmutableMap<class_2960, ItemRestriction> itemRestrictions = ImmutableMap.of();
    private static ItemRestrictionManager instance;

    public ItemRestrictionManager() {
        instance = this;
    }

    @NotNull
    protected List<ItemRestriction> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, class_3298> resourceMap = resourceManager.method_14488("itemrestrictions/restrictions", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)((class_2960)entry.getKey()).method_12832().substring(0, ((class_2960)entry.getKey()).method_12832().length() - ".json".length()).substring("itemrestrictions/restrictions/".length())), Map.Entry::getValue));
        HashMap<class_2960, JsonObject> map = new HashMap<class_2960, JsonObject>();
        for (Map.Entry<class_2960, class_3298> entry2 : resourceMap.entrySet()) {
            class_2960 location = entry2.getKey();
            try {
                JsonObject jsonElement = class_3518.method_15255((Reader)entry2.getValue().method_43039());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                ItemRestrictions.LOGGER.error("Parsing error loading item restriction {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<ItemRestriction> itemRestrictions = new ArrayList<ItemRestriction>();
        if (!ItemRestrictions.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((class_2960)entry.getKey()).method_12836().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            class_2960 location = (class_2960)entry3.getKey();
            JsonObject jsonObject = (JsonObject)entry3.getValue();
            jsonObject.addProperty("location", location.toString());
            try {
                ItemRestriction itemRestriction = (ItemRestriction)GSON.fromJson((JsonElement)entry3.getValue(), ItemRestriction.class);
                itemRestrictions.add(itemRestriction);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                ItemRestrictions.LOGGER.error("Parsing error loading item restriction {}", (Object)location, (Object)runtimeException);
            }
        }
        return itemRestrictions;
    }

    protected void apply(List<ItemRestriction> object, class_3300 resourceManager, class_3695 profilerFiller) {
        ItemRestrictions.LOGGER.info("Loaded {} item restrictions", (Object)object.size());
        this.itemRestrictions = (ImmutableMap)object.stream().collect(ImmutableMap.toImmutableMap(ItemRestriction::getLocation, itemRestriction -> itemRestriction));
    }

    public static ItemRestrictionManager getInstance() {
        return instance != null ? instance : ItemRestrictionsExpectPlatform.getItemRestrictionManager();
    }

    public List<ItemRestriction> getItemRestrictions() {
        return this.itemRestrictions.values().asList();
    }

    public ItemRestriction getItemRestriction(class_2960 location) {
        return (ItemRestriction)this.itemRestrictions.get((Object)location);
    }

    public void setItemRestrictions(List<ItemRestriction> itemRestrictions) {
        this.itemRestrictions = (ImmutableMap)itemRestrictions.stream().collect(ImmutableMap.toImmutableMap(ItemRestriction::getLocation, itemRestriction -> itemRestriction));
    }
}

