/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.mixin.block;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.itemrestrictions.level.block.ItemRestrictionsBrewingStandBlockEntity;
import com.daqem.itemrestrictions.level.menu.ItemRestrictionsBrewingStandMenu;
import com.daqem.itemrestrictions.level.player.ItemRestrictionsServerPlayer;
import com.daqem.itemrestrictions.networking.clientbound.ClientboundRestrictionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1278;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2260;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2589;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2589.class})
public abstract class MixinBrewingStandBlockEntity
extends class_2624
implements class_1278,
ItemRestrictionsBrewingStandBlockEntity {
    @Shadow
    int field_11878;
    @Shadow
    private class_2371<class_1799> field_11882;
    @Shadow
    private boolean[] field_11883;
    @Unique
    @Nullable
    private UUID itemrestrictions$playerUUID;
    @Unique
    @Nullable
    private class_3222 itemrestrictions$player;

    protected MixinBrewingStandBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(at={@At(value="TAIL")}, method={"saveAdditional"})
    private void saveAdditional(class_11372 valueOutput, CallbackInfo ci) {
        class_3222 serverPlayer = this.itemrestrictions$getPlayer();
        if (serverPlayer != null) {
            valueOutput.method_71469("ItemRestrictionsServerPlayer", serverPlayer.method_5667().toString());
        } else {
            UUID uuid = this.itemrestrictions$getPlayerUUID();
            if (uuid != null) {
                valueOutput.method_71469("ItemRestrictionsServerPlayer", uuid.toString());
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional"})
    private void load(class_11368 valueInput, CallbackInfo ci) {
        valueInput.method_71441("ItemRestrictionsServerPlayer").ifPresent(uuid -> this.itemrestrictions$setPlayerUUID(UUID.fromString(uuid)));
    }

    @Inject(at={@At(value="HEAD")}, method={"serverTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;)V"}, cancellable=true)
    private static void doBrew(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2589 brewingStandBlockEntity, CallbackInfo ci) {
        if (brewingStandBlockEntity instanceof ItemRestrictionsBrewingStandBlockEntity) {
            ItemRestrictionsBrewingStandBlockEntity block = (ItemRestrictionsBrewingStandBlockEntity)brewingStandBlockEntity;
            if (block.itemrestrictions$getPlayer() == null && block.itemrestrictions$getPlayerUUID() != null && level.method_8503() != null) {
                class_3222 player = level.method_8503().method_3760().method_14602(block.itemrestrictions$getPlayerUUID());
                block.itemrestrictions$setPlayer(player);
            }
            if (block.itemrestrictions$getPlayer() != null && !brewingStandBlockEntity.method_5438(3).method_7960()) {
                if (!(brewingStandBlockEntity.method_5438(0).method_7960() && brewingStandBlockEntity.method_5438(1).method_7960() && brewingStandBlockEntity.method_5438(2).method_7960())) {
                    class_1799 ingredient = brewingStandBlockEntity.method_5438(3);
                    for (int i = 0; i < 3; ++i) {
                        ItemRestrictionsServerPlayer player;
                        class_1799 potion = brewingStandBlockEntity.method_5438(i);
                        class_1799 mixedPotion = level.method_59547().method_8078(ingredient, potion);
                        RestrictionResult result = new RestrictionResult();
                        class_3222 class_32222 = block.itemrestrictions$getPlayer();
                        if (class_32222 instanceof ItemRestrictionsServerPlayer && (player = (ItemRestrictionsServerPlayer)class_32222) instanceof ArcPlayer) {
                            ArcPlayer arcPlayer = (ArcPlayer)player;
                            result = player.itemrestrictions$isRestricted(new ActionDataBuilder(arcPlayer, null).withData(ActionDataType.ITEM_STACK, (Object)mixedPotion).build());
                        }
                        if (!result.isRestricted(RestrictionType.BREW)) continue;
                        block.itemrestrictions$setBrewTime(0);
                        MixinBrewingStandBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)brewingStandBlockEntity.method_11010());
                        ci.cancel();
                        boolean[] bls = block.itemrestrictions$getPotionBits();
                        if (!Arrays.equals(bls, block.itemrestrictions$getLastPotionCount())) {
                            block.itemrestrictions$setLastPotionCount(bls);
                            class_2680 blockState2 = blockState;
                            if (!(blockState.method_26204() instanceof class_2260)) {
                                return;
                            }
                            for (int j = 0; j < class_2260.field_10700.length; ++j) {
                                blockState2 = (class_2680)blockState2.method_11657((class_2769)class_2260.field_10700[j], (Comparable)Boolean.valueOf(bls[j]));
                            }
                            level.method_8652(blockPos, blockState2, 2);
                        }
                        MixinBrewingStandBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.BREW, block);
                        return;
                    }
                } else if (brewingStandBlockEntity.method_5438(0).method_7960() && brewingStandBlockEntity.method_5438(1).method_7960() && brewingStandBlockEntity.method_5438(2).method_7960()) {
                    MixinBrewingStandBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.NONE, block);
                }
            } else if (block.itemrestrictions$getPlayer() != null && brewingStandBlockEntity.method_5438(3).method_7960()) {
                MixinBrewingStandBlockEntity.itemrestrictions$sendPacketCantCraft(RestrictionType.NONE, block);
            }
        }
    }

    @Unique
    private static void itemrestrictions$sendPacketCantCraft(RestrictionType type, ItemRestrictionsBrewingStandBlockEntity block) {
        ItemRestrictionsBrewingStandMenu menu;
        class_1703 class_17032 = block.itemrestrictions$getPlayer().field_7512;
        if (class_17032 instanceof ItemRestrictionsBrewingStandMenu && (menu = (ItemRestrictionsBrewingStandMenu)class_17032).itemrestrictions$getBrewingStand().equals((Object)block.itemrestrictions$getBrewingStandBlockEntity())) {
            NetworkManager.sendToPlayer((class_3222)block.itemrestrictions$getPlayer(), (class_8710)new ClientboundRestrictionPacket(type));
        }
    }

    @Override
    @Nullable
    public class_3222 itemrestrictions$getPlayer() {
        return this.itemrestrictions$player;
    }

    @Override
    public void itemrestrictions$setPlayer(@Nullable class_3222 player) {
        this.itemrestrictions$player = player;
    }

    @Override
    @Nullable
    public UUID itemrestrictions$getPlayerUUID() {
        return this.itemrestrictions$playerUUID;
    }

    @Override
    public void itemrestrictions$setPlayerUUID(@Nullable UUID playerUUID) {
        this.itemrestrictions$playerUUID = playerUUID;
    }

    @Override
    public void itemrestrictions$setBrewTime(int i) {
        this.field_11878 = i;
    }

    @Override
    public boolean[] itemrestrictions$getPotionBits() {
        boolean[] bls = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((class_1799)this.field_11882.get(i)).method_7960()) continue;
            bls[i] = true;
        }
        return bls;
    }

    @Override
    public boolean[] itemrestrictions$getLastPotionCount() {
        return this.field_11883;
    }

    @Override
    public void itemrestrictions$setLastPotionCount(boolean[] lastPotionCount) {
        this.field_11883 = lastPotionCount;
    }

    @Override
    public class_2589 itemrestrictions$getBrewingStandBlockEntity() {
        return (class_2589)this;
    }
}

