/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.data;

import com.daqem.itemrestrictions.ItemRestrictions;
import com.daqem.itemrestrictions.ItemRestrictionsExpectPlatform;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ItemRestrictionManager
extends SimplePreparableReloadListener<List<ItemRestriction>> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeHierarchyAdapter(ItemRestriction.class, (Object)new ItemRestriction.Serializer()).create();
    private ImmutableMap<ResourceLocation, ItemRestriction> itemRestrictions = ImmutableMap.of();
    private static ItemRestrictionManager instance;

    public ItemRestrictionManager() {
        instance = this;
    }

    @NotNull
    protected List<ItemRestriction> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Map<ResourceLocation, Resource> resourceMap = resourceManager.listResources("itemrestrictions/restrictions", resourceLocation -> resourceLocation.getPath().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring(0, ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length()).substring("itemrestrictions/restrictions/".length())), Map.Entry::getValue));
        HashMap<ResourceLocation, JsonObject> map = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, Resource> entry2 : resourceMap.entrySet()) {
            ResourceLocation location = entry2.getKey();
            try {
                JsonObject jsonElement = GsonHelper.parse((Reader)entry2.getValue().openAsReader());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                ItemRestrictions.LOGGER.error("Parsing error loading item restriction {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<ItemRestriction> itemRestrictions = new ArrayList<ItemRestriction>();
        if (!ItemRestrictions.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry3.getKey();
            JsonObject jsonObject = (JsonObject)entry3.getValue();
            jsonObject.addProperty("location", location.toString());
            try {
                ItemRestriction itemRestriction = (ItemRestriction)GSON.fromJson((JsonElement)entry3.getValue(), ItemRestriction.class);
                itemRestrictions.add(itemRestriction);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                ItemRestrictions.LOGGER.error("Parsing error loading item restriction {}", (Object)location, (Object)runtimeException);
            }
        }
        return itemRestrictions;
    }

    protected void apply(List<ItemRestriction> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ItemRestrictions.LOGGER.info("Loaded {} item restrictions", (Object)object.size());
        this.itemRestrictions = (ImmutableMap)object.stream().collect(ImmutableMap.toImmutableMap(ItemRestriction::getLocation, itemRestriction -> itemRestriction));
    }

    public static ItemRestrictionManager getInstance() {
        return instance != null ? instance : ItemRestrictionsExpectPlatform.getItemRestrictionManager();
    }

    public List<ItemRestriction> getItemRestrictions() {
        return this.itemRestrictions.values().asList();
    }

    public ItemRestriction getItemRestriction(ResourceLocation location) {
        return (ItemRestriction)this.itemRestrictions.get((Object)location);
    }

    public void setItemRestrictions(List<ItemRestriction> itemRestrictions) {
        this.itemRestrictions = (ImmutableMap)itemRestrictions.stream().collect(ImmutableMap.toImmutableMap(ItemRestriction::getLocation, itemRestriction -> itemRestriction));
    }
}

