/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.mixin.menu;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.itemrestrictions.level.player.ItemRestrictionsServerPlayer;
import com.daqem.itemrestrictions.networking.clientbound.ClientboundRestrictionPacket;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingMenu.class})
public abstract class MixinCraftingMenu
extends RecipeBookMenu {
    public MixinCraftingMenu(MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Inject(at={@At(value="TAIL")}, method={"slotChangedCraftingGrid(Lnet/minecraft/world/inventory/AbstractContainerMenu;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/inventory/CraftingContainer;Lnet/minecraft/world/inventory/ResultContainer;Lnet/minecraft/world/item/crafting/RecipeHolder;)V"})
    private static void slotChangedCraftingGrid(AbstractContainerMenu abstractContainerMenu, ServerLevel serverLevel, Player player, CraftingContainer craftingContainer, ResultContainer resultContainer, RecipeHolder<CraftingRecipe> recipeHolder, CallbackInfo ci) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player) instanceof ItemRestrictionsServerPlayer) {
            ItemRestrictionsServerPlayer itemRestrictionsPlayer = (ItemRestrictionsServerPlayer)serverPlayer;
            if (serverPlayer instanceof ArcPlayer) {
                ArcPlayer arcPlayer = (ArcPlayer)serverPlayer;
                ItemStack itemStack = resultContainer.getItem(0);
                RestrictionResult restrictionResult = itemRestrictionsPlayer.itemrestrictions$isRestricted(new ActionDataBuilder(arcPlayer, null).withData(ActionDataType.ITEM_STACK, (Object)itemStack).build());
                if (restrictionResult.isRestricted(RestrictionType.CRAFT)) {
                    resultContainer.setItem(0, ItemStack.EMPTY);
                    NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundRestrictionPacket(RestrictionType.CRAFT));
                } else {
                    NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundRestrictionPacket(RestrictionType.NONE));
                }
            }
        }
    }
}

