/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.mixin.menu;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.itemrestrictions.level.player.ItemRestrictionsServerPlayer;
import com.daqem.itemrestrictions.networking.clientbound.ClientboundRestrictionPacket;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class})
public abstract class MixinEnchantmentMenu
extends AbstractContainerMenu {
    @Unique
    private ServerPlayer itemrestrictions$player;

    protected MixinEnchantmentMenu(@Nullable MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Inject(at={@At(value="HEAD")}, method={"clickMenuButton(Lnet/minecraft/world/entity/player/Player;I)Z"}, cancellable=true)
    private void clickMenuButton(Player player, int level, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player) instanceof ItemRestrictionsServerPlayer) {
            ItemRestrictionsServerPlayer itemRestrictionsPlayer = (ItemRestrictionsServerPlayer)serverPlayer;
            if (serverPlayer instanceof ArcPlayer) {
                ArcPlayer arcPlayer = (ArcPlayer)serverPlayer;
                this.itemrestrictions$player = serverPlayer;
                RestrictionResult craftingResult = itemRestrictionsPlayer.itemrestrictions$isRestricted(new ActionDataBuilder(arcPlayer, null).withData(ActionDataType.ITEM_STACK, (Object)this.getSlot(0).getItem()).build());
                if (craftingResult.isRestricted(RestrictionType.ENCHANT)) {
                    NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundRestrictionPacket(RestrictionType.ENCHANT));
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"slotsChanged(Lnet/minecraft/world/Container;)V"})
    private void slotsChanged(Container container, CallbackInfo ci) {
        if (this.itemrestrictions$player != null) {
            NetworkManager.sendToPlayer((ServerPlayer)this.itemrestrictions$player, (CustomPacketPayload)new ClientboundRestrictionPacket(RestrictionType.NONE));
        }
    }
}

