/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.itemrestrictions.data;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.daqem.itemrestrictions.ItemRestrictions;
import com.daqem.itemrestrictions.data.RestrictionResult;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class ItemRestriction {
    private final class_2960 location;
    private final class_1799 icon;
    private final List<RestrictionType> restrictionTypes;
    private final List<ICondition> conditions;

    public ItemRestriction(class_2960 location, class_1799 icon, List<RestrictionType> restrictionTypes, List<ICondition> conditions) {
        this.location = location;
        this.icon = icon;
        this.restrictionTypes = restrictionTypes;
        this.conditions = conditions;
    }

    public RestrictionResult isRestricted(ActionData actionData) {
        class_1799 itemStack = (class_1799)actionData.getData(ActionDataType.ITEM_STACK);
        if (itemStack == null) {
            return new RestrictionResult();
        }
        boolean allConditionsMet = this.conditions.stream().allMatch(condition -> condition.isMet(actionData) && !condition.isInverted() || !condition.isMet(actionData) && condition.isInverted());
        if (allConditionsMet) {
            return new RestrictionResult(this.restrictionTypes);
        }
        return new RestrictionResult();
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public class_1799 getIcon() {
        return this.icon;
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public List<RestrictionType> getRestrictionTypes() {
        return this.restrictionTypes;
    }

    public static class Serializer
    implements JsonDeserializer<ItemRestriction>,
    ArcSerializer {
        public ItemRestriction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            class_2960 location = this.getResourceLocation(jsonObject, "location");
            JsonArray restrictionTypesArray = class_3518.method_15261((JsonObject)jsonObject, (String)"types");
            JsonArray conditionsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"conditions");
            ArrayList<RestrictionType> restrictionTypes = new ArrayList<RestrictionType>();
            ArrayList<ICondition> conditions = new ArrayList<ICondition>();
            class_1799 iconStack = class_1799.field_8037;
            if (jsonObject.has("icon")) {
                iconStack = this.getItemStack((JsonElement)jsonObject.getAsJsonObject("icon"));
            }
            restrictionTypesArray.forEach(jsonElement -> {
                String restrictionTypeString = jsonElement.getAsString();
                try {
                    RestrictionType restrictionType = RestrictionType.valueOf(restrictionTypeString.toUpperCase());
                    restrictionTypes.add(restrictionType);
                }
                catch (IllegalArgumentException e) {
                    ItemRestrictions.LOGGER.error("Could not deserialize restriction type {} because: {}", (Object)restrictionTypeString, (Object)e.getMessage());
                }
            });
            conditionsArray.forEach(jsonElement -> {
                class_2960 conditionTypeLocation = class_2960.method_60654((String)class_3518.method_15265((JsonObject)jsonElement.getAsJsonObject(), (String)"type"));
                ArcRegistry.CONDITION.method_17966(conditionTypeLocation).ifPresent(conditionType -> conditions.add(conditionType.getSerializer().fromJson(class_2960.method_60654((String)""), jsonElement.getAsJsonObject())));
            });
            return new ItemRestriction(location, iconStack, restrictionTypes, conditions);
        }

        public static void toNetwork(class_9129 buf, ItemRestriction itemRestriction) {
            buf.method_10812(itemRestriction.location);
            class_1799.field_48349.encode((Object)buf, (Object)itemRestriction.icon);
            buf.method_34062(itemRestriction.restrictionTypes, (byteBuf, restrictionType) -> byteBuf.method_10814(restrictionType.name()));
            buf.method_34062(itemRestriction.conditions, (byteBuf, condition) -> IConditionSerializer.toNetwork((ICondition)condition, (class_9129)((class_9129)byteBuf), (class_2960)itemRestriction.getLocation()));
        }

        public static ItemRestriction fromNetwork(class_9129 buf) {
            class_2960 location = buf.method_10810();
            class_1799 icon = (class_1799)class_1799.field_48349.decode((Object)buf);
            List restrictionTypeStrings = buf.method_34066(class_2540::method_19772);
            ArrayList<RestrictionType> restrictionTypes = new ArrayList<RestrictionType>();
            restrictionTypeStrings.forEach(restrictionTypeString -> {
                try {
                    RestrictionType restrictionType = RestrictionType.valueOf(restrictionTypeString.toUpperCase());
                    restrictionTypes.add(restrictionType);
                }
                catch (IllegalArgumentException e) {
                    ItemRestrictions.LOGGER.error("Could not deserialize restriction type {} because: {}", restrictionTypeString, (Object)e.getMessage());
                }
            });
            List conditions = buf.method_34066(object -> IConditionSerializer.fromNetwork((class_9129)((class_9129)object)));
            return new ItemRestriction(location, icon, restrictionTypes, conditions);
        }
    }
}

