/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import ru.pi.subcapts.capture.CaptureHandler;
import ru.pi.subcapts.capture.CaptureManager;
import ru.pi.subcapts.client.CaptureRenderer;
import ru.pi.subcapts.commands.SubcaptsCommands;
import ru.pi.subcapts.config.CaptureConfig;
import ru.pi.subcapts.network.NetworkHandler;

@Mod(value="subcapts")
public class SubCapts {
    public static final String MODID = "subcapts";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SubCapts() {
        NetworkHandler.register();
        CaptureConfig.loadPoints();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CaptureHandler());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("====================================");
        LOGGER.info("\ud83d\ude80 [SubCapts] Server is starting...");
        LOGGER.info("====================================");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        SubcaptsCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                CaptureManager.tick(level);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="subcapts", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("SubCapts | CLIENT SETUP");
            MinecraftForge.EVENT_BUS.register((Object)new CaptureRenderer());
        }
    }
}

