/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.capture;

import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import ru.pi.subcapts.capture.CapturePoint;
import ru.pi.subcapts.capture.CapturePointManager;
import ru.pi.subcapts.network.NetworkHandler;
import ru.pi.subcapts.network.packet.CapturePointStatusPacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CaptureHandler {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer() == null) {
            return;
        }
        for (CapturePoint point : CapturePointManager.getPoints()) {
            long elapsed;
            if (point.isOnCooldown()) {
                if (!point.isCooldownExpired()) continue;
                point.resetCooldown();
                CaptureHandler.broadcastStatus(point, event.getServer());
                for (ServerLevel world : event.getServer().m_129785_()) {
                    for (ServerPlayer p2 : world.m_6907_()) {
                        p2.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u041a\u0443\u043b\u0434\u0430\u0443\u043d \u0442\u043e\u0447\u043a\u0438 \u00a7e" + point.getName() + " \u00a7a\u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0441\u044f!")));
                    }
                }
                continue;
            }
            ServerPlayer capturingPlayer = null;
            for (ServerLevel world : event.getServer().m_129785_()) {
                List<ServerPlayer> playersInRadius = world.m_6907_().stream().filter(p -> p.m_20183_().m_123314_((Vec3i)point.getPosition(), (double)point.getCaptureRadius())).toList();
                if (playersInRadius.isEmpty() || playersInRadius.size() != 1) continue;
                capturingPlayer = playersInRadius.get(0);
                break;
            }
            if (capturingPlayer == null) {
                if (point.getCaptureStartTime() == -1L) continue;
                point.setCaptureStartTime(-1L);
                point.setCapturingTeam(null);
                CaptureHandler.broadcastStatus(point, event.getServer());
                continue;
            }
            if (point.getCaptureStartTime() == -1L || !capturingPlayer.m_7755_().getString().equals(point.getCapturingTeam())) {
                point.setCaptureStartTime(System.currentTimeMillis());
                point.setCapturingTeam(capturingPlayer.m_7755_().getString());
                capturingPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a7e\u0412\u044b \u043d\u0430\u0447\u0430\u043b\u0438 \u0437\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0442\u043e\u0447\u043a\u0443 \u00a76" + point.getName())));
                CaptureHandler.broadcastStatus(point, event.getServer());
            }
            if ((elapsed = System.currentTimeMillis() - point.getCaptureStartTime()) < (long)point.getCaptureTime() * 1000L) continue;
            for (ServerLevel world : event.getServer().m_129785_()) {
                for (ServerPlayer p3 : world.m_6907_()) {
                    p3.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u0422\u043e\u0447\u043a\u0430 " + point.getName() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430!")));
                    for (ItemStack reward : point.getRewardItems()) {
                        ItemStack copy = reward.m_41777_();
                        boolean added = p3.m_150109_().m_36054_(copy);
                        if (added) continue;
                        p3.m_36176_(copy, false);
                    }
                    p3.m_213846_((Component)Component.m_237113_((String)"\u00a76\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043d\u0430\u0433\u0440\u0430\u0434\u0443 \u0437\u0430 \u0437\u0430\u0445\u0432\u0430\u0442!"));
                }
            }
            point.setCaptureStartTime(-1L);
            point.setCapturingTeam(null);
            point.startCooldown();
            CaptureHandler.broadcastStatus(point, event.getServer());
        }
    }

    private static void broadcastStatus(CapturePoint point, MinecraftServer server) {
        if (server == null) {
            return;
        }
        CapturePointStatusPacket pkt = new CapturePointStatusPacket(point);
        for (ServerLevel world : server.m_129785_()) {
            for (ServerPlayer p : world.m_6907_()) {
                NetworkHandler.CHANNEL.sendTo((Object)pkt, p.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

