/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.capture;

import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import ru.pi.subcapts.capture.CapturePoint;
import ru.pi.subcapts.capture.CapturePointManager;

public class CaptureManager {
    public static void tick(ServerLevel level) {
        long now = System.currentTimeMillis();
        for (CapturePoint point : CapturePointManager.getPoints()) {
            long elapsed;
            if (point.isOnCooldown()) {
                if (!point.isCooldownExpired()) continue;
                point.resetCooldown();
                level.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("\u00a7a\u041a\u0443\u043b\u0434\u0430\u0443\u043d \u0442\u043e\u0447\u043a\u0438 \u00a7e" + point.getName() + " \u00a7a\u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d!")), false);
                continue;
            }
            ServerPlayer capturer = null;
            for (ServerPlayer player : level.m_6907_()) {
                double dist = player.m_20183_().m_123331_((Vec3i)point.getPosition());
                if (!(dist <= (double)(point.getCaptureRadius() * point.getCaptureRadius()))) continue;
                capturer = player;
                break;
            }
            if (capturer == null) {
                point.setCapturingPlayer(null);
                point.setCaptureStartTime(-1L);
                continue;
            }
            if (point.getCapturingPlayer() == null) {
                point.setCapturingPlayer(capturer.m_20148_());
                point.setCaptureStartTime(now);
            }
            if ((elapsed = now - point.getCaptureStartTime()) < (long)point.getCaptureTime() * 1000L) continue;
            level.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("\u00a7e" + capturer.m_7755_().getString() + " \u00a7a\u0437\u0430\u0445\u0432\u0430\u0442\u0438\u043b \u0442\u043e\u0447\u043a\u0443 \u00a7b" + point.getName() + "!")), false);
            point.setCapturingPlayer(null);
            point.setCaptureStartTime(-1L);
            point.startCooldown();
        }
    }
}

