/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.capture;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public class CapturePoint {
    private UUID capturingPlayer = null;
    private String capturingTeam = null;
    private final String name;
    private final BlockPos position;
    private final int notifyRadius;
    private final int captureRadius;
    private final int captureTime;
    private final int cooldownTime;
    private final String color;
    private final int maxonline;
    private boolean onCooldown = false;
    private long captureStartTime = -1L;
    private long cooldownStartTime = -1L;
    private final List<ItemStack> rewardItems = new ArrayList<ItemStack>();

    public CapturePoint(String name, BlockPos position, int notifyRadius, int captureRadius, int captureTime, int cooldownTime, String color, int maxonline) {
        this.name = name;
        this.position = position;
        this.notifyRadius = notifyRadius;
        this.captureRadius = captureRadius;
        this.captureTime = captureTime;
        this.cooldownTime = cooldownTime;
        this.color = color;
        this.maxonline = maxonline;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public int getNotifyRadius() {
        return this.notifyRadius;
    }

    public int getCaptureRadius() {
        return this.captureRadius;
    }

    public int getCaptureTime() {
        return this.captureTime;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public String getColor() {
        return this.color;
    }

    public int getMaxOnline() {
        return this.maxonline;
    }

    public UUID getCapturingPlayer() {
        return this.capturingPlayer;
    }

    public void setCapturingPlayer(UUID player) {
        this.capturingPlayer = player;
    }

    public String getCapturingTeam() {
        return this.capturingTeam;
    }

    public void setCapturingTeam(String team) {
        this.capturingTeam = team;
    }

    public long getCaptureStartTime() {
        return this.captureStartTime;
    }

    public void setCaptureStartTime(long time) {
        this.captureStartTime = time;
    }

    public boolean isCapturing() {
        return this.capturingPlayer != null && this.captureStartTime > 0L;
    }

    public long getRemainingCaptureTime() {
        if (!this.isCapturing()) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - this.captureStartTime;
        long remaining = (long)this.captureTime * 1000L - elapsed;
        return Math.max(remaining, 0L);
    }

    public boolean isOnCooldown() {
        return this.onCooldown;
    }

    public void startCooldown() {
        this.onCooldown = true;
        this.cooldownStartTime = System.currentTimeMillis();
    }

    public void resetCooldown() {
        this.onCooldown = false;
        this.cooldownStartTime = -1L;
    }

    public long getCooldownStartTime() {
        return this.cooldownStartTime;
    }

    public long getRemainingCooldownTime() {
        if (!this.onCooldown) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - this.cooldownStartTime;
        long remaining = (long)this.cooldownTime * 1000L - elapsed;
        return Math.max(remaining, 0L);
    }

    public boolean isCooldownExpired() {
        return !this.onCooldown || System.currentTimeMillis() - this.cooldownStartTime >= (long)this.cooldownTime * 1000L;
    }

    public void addRewardItem(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            this.rewardItems.add(stack.m_41777_());
        }
    }

    public void removeRewardItem(int index) {
        if (index >= 0 && index < this.rewardItems.size()) {
            this.rewardItems.remove(index);
        }
    }

    public void clearRewards() {
        this.rewardItems.clear();
    }

    public List<ItemStack> getRewardItems() {
        return Collections.unmodifiableList(this.rewardItems);
    }

    public void setRewardItems(List<ItemStack> items) {
        this.rewardItems.clear();
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack == null || stack.m_41619_()) continue;
                this.rewardItems.add(stack.m_41777_());
            }
        }
    }
}

