/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.capture;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import ru.pi.subcapts.capture.CapturePoint;

public class CapturePointManager {
    private static final List<CapturePoint> POINTS = new ArrayList<CapturePoint>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CapturePointManager.tick();
        }
    }

    public static void addPoint(CapturePoint point) {
        if (!POINTS.contains(point)) {
            POINTS.add(point);
        }
    }

    public static List<CapturePoint> getPoints() {
        return POINTS;
    }

    public static CapturePoint getPointByName(String name) {
        return POINTS.stream().filter(p -> p.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static void tick() {
        Iterator<CapturePoint> iterator = POINTS.iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            long elapsed;
            CapturePoint point = iterator.next();
            if (!point.isOnCooldown() || point.getCooldownStartTime() == -1L || (elapsed = currentTime - point.getCooldownStartTime()) < (long)point.getCooldownTime() * 1000L) continue;
            point.resetCooldown();
            CapturePointManager.broadcastCooldownEnd(point);
        }
    }

    private static void broadcastCooldownEnd(CapturePoint point) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        MutableComponent message = Component.m_237113_((String)("\u00a7a[\u0417\u0430\u0445\u0432\u0430\u0442] \u00a7f\u0422\u043e\u0447\u043a\u0430 \u00a7e" + point.getName() + " \u00a7f\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u0445\u0432\u0430\u0442\u0430!"));
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            player.m_213846_((Component)message);
        }
    }
}

