/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.pi.subcapts.client.ClientCapturePoint;
import ru.pi.subcapts.client.ClientCapturePointManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CaptureHudRenderer {
    private static final Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public static void onRenderHUD(RenderGuiOverlayEvent.Post event) {
        GuiGraphics gui = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        long currentTime = System.currentTimeMillis();
        for (ClientCapturePoint point : ClientCapturePointManager.getPoints()) {
            int endX;
            Vec3 pointPos;
            Vec3 playerPos = CaptureHudRenderer.mc.f_91074_.m_20182_();
            double distance = playerPos.m_82557_(pointPos = Vec3.m_82512_((Vec3i)point.getPos()));
            if (distance > (double)(point.getNotifyRadius() * point.getNotifyRadius())) continue;
            int barWidth = 200;
            int barHeight = 16;
            int x = (screenWidth - barWidth) / 2;
            int y = 30;
            gui.m_280509_(x - 2, y - 2, x + barWidth + 2, y + barHeight + 2, 0x44000000);
            gui.m_280509_(x, y, x + barWidth, y + barHeight, -1441722095);
            if (!point.isOnCooldown() && point.getCaptureProgress() > 0.0f) {
                endX = x + (int)((float)barWidth * point.getCaptureProgress());
                gui.m_280509_(x, y, endX, y + barHeight, -13710223);
            }
            if (point.isOnCooldown()) {
                endX = x + (int)((float)barWidth * point.getCooldownProgress());
                gui.m_280509_(x, y, endX, y + barHeight, -1618884);
            }
            gui.m_280509_(x - 1, y - 1, x + barWidth + 1, y, -1996488705);
            gui.m_280509_(x - 1, y + barHeight, x + barWidth + 1, y + barHeight + 1, -1996488705);
            gui.m_280509_(x - 1, y, x, y + barHeight, -1996488705);
            gui.m_280509_(x + barWidth, y, x + barWidth + 1, y + barHeight, -1996488705);
            StringBuilder sb = new StringBuilder();
            sb.append(point.getName());
            if (point.isOnCooldown()) {
                long remaining = (long)point.getCooldownTime() * 1000L - (currentTime - point.getCooldownStartTime());
                if (remaining < 0L) {
                    remaining = 0L;
                }
                sb.append(String.format(" | \u041a\u0443\u043b\u0434\u0430\u0443\u043d: %.1fs", Float.valueOf((float)remaining / 1000.0f)));
            } else {
                if (point.getCapturingTeam() != null) {
                    sb.append(" | ").append(point.getCapturingTeam());
                }
                if (point.getCaptureStartTime() != -1L) {
                    long remaining = (long)point.getCaptureTime() * 1000L - (currentTime - point.getCaptureStartTime());
                    sb.append(String.format(" | %.1fs", Float.valueOf((float)remaining / 1000.0f)));
                }
            }
            String text = sb.toString();
            int textWidth = CaptureHudRenderer.mc.f_91062_.m_92895_(text);
            int textX = x + (barWidth - textWidth) / 2;
            int textY = y + (barHeight - 8) / 2;
            gui.m_280614_(CaptureHudRenderer.mc.f_91062_, (Component)Component.m_237113_((String)text), textX + 1, textY + 1, -16777216, false);
            gui.m_280614_(CaptureHudRenderer.mc.f_91062_, (Component)Component.m_237113_((String)text), textX, textY, -1, false);
        }
    }
}

