/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import ru.pi.subcapts.client.CaptureClientManager;
import ru.pi.subcapts.client.CapturePointClient;

@Mod.EventBusSubscriber(modid="subcapts", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CaptureRenderer {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final int SEGMENTS = 64;
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final float[] COS_CACHE = new float[65];
    private static final float[] SIN_CACHE = new float[65];

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (CaptureRenderer.mc.f_91073_ == null) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        Vec3 cam = CaptureRenderer.mc.f_91063_.m_109153_().m_90583_();
        PoseStack pose = event.getPoseStack();
        pose.m_85836_();
        pose.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
        Matrix4f mat = pose.m_85850_().m_252922_();
        List<CapturePointClient> points = CaptureClientManager.getPoints();
        for (CapturePointClient p : points) {
            int chunkX = p.x >> 4;
            int chunkZ = p.z >> 4;
            if (!CaptureRenderer.mc.f_91073_.m_7726_().m_5563_(chunkX, chunkZ)) continue;
            CaptureRenderer.drawCaptureCircle(mat, (float)p.x + 0.5f, (float)p.y + 0.5f, (float)p.z + 0.5f, p.captureRadius, 0.25f, 2.0f, p.color);
        }
        pose.m_85849_();
    }

    private static void drawCaptureCircle(Matrix4f mat, float cx, float cy, float cz, float radius, float baseAlpha, float lineWidth, String packedColor) {
        int color = Integer.parseUnsignedInt(packedColor.replace("0x", ""), 16);
        float rBase = (float)(color >> 16 & 0xFF) / 255.0f;
        float gBase = (float)(color >> 8 & 0xFF) / 255.0f;
        float bBase = (float)(color & 0xFF) / 255.0f;
        long time = System.currentTimeMillis();
        float t = (float)(time % 2000L) / 2000.0f;
        float pulse = 1.0f + 0.02f * (float)Math.sin((double)t * Math.PI * 2.0);
        float animatedRadius = radius * pulse;
        float alpha = baseAlpha * (0.85f + 0.15f * (float)Math.sin((double)t * Math.PI * 2.0));
        float brightness = 0.85f + 0.15f * (float)Math.sin((double)t * Math.PI * 2.0);
        float r = rBase * brightness;
        float g = gBase * brightness;
        float b = bBase * brightness;
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        float height = 0.5f;
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < 64; ++i) {
            float x1 = cx + COS_CACHE[i] * animatedRadius;
            float z1 = cz + SIN_CACHE[i] * animatedRadius;
            float x2 = cx + COS_CACHE[i + 1] * animatedRadius;
            float z2 = cz + SIN_CACHE[i + 1] * animatedRadius;
            buf.m_252986_(mat, x1, cy, z1).m_85950_(r, g, b, alpha).m_5752_();
            buf.m_252986_(mat, x2, cy, z2).m_85950_(r, g, b, alpha).m_5752_();
            buf.m_252986_(mat, x2, cy + height, z2).m_85950_(r, g, b, 0.0f).m_5752_();
            buf.m_252986_(mat, x1, cy + height, z1).m_85950_(r, g, b, 0.0f).m_5752_();
        }
        tess.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    static {
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / 64.0f;
            CaptureRenderer.COS_CACHE[i] = (float)Math.cos(angle);
            CaptureRenderer.SIN_CACHE[i] = (float)Math.sin(angle);
        }
    }
}

