/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.client;

import net.minecraft.core.BlockPos;

public class ClientCapturePoint {
    private final String name;
    private final BlockPos pos;
    private final int notifyRadius;
    private final int captureTime;
    private final int cooldownTime;
    private long captureStartTime = -1L;
    private long cooldownStartTime = -1L;
    private boolean onCooldown = false;
    private String capturingTeam = null;

    public ClientCapturePoint(String name, BlockPos pos, int notifyRadius, int captureTime, int cooldownTime) {
        this.name = name;
        this.pos = pos;
        this.notifyRadius = notifyRadius;
        this.captureTime = captureTime;
        this.cooldownTime = cooldownTime;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getNotifyRadius() {
        return this.notifyRadius;
    }

    public int getCaptureTime() {
        return this.captureTime;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public long getCaptureStartTime() {
        return this.captureStartTime;
    }

    public void setCaptureStartTime(long time) {
        this.captureStartTime = time;
    }

    public long getCooldownStartTime() {
        return this.cooldownStartTime;
    }

    public void setCooldownStartTime(long time) {
        this.cooldownStartTime = time;
    }

    public boolean isOnCooldown() {
        return this.onCooldown;
    }

    public void setOnCooldown(boolean cooldown) {
        this.onCooldown = cooldown;
    }

    public String getCapturingTeam() {
        return this.capturingTeam;
    }

    public void setCapturingTeam(String team) {
        this.capturingTeam = team;
    }

    public float getCaptureProgress() {
        if (this.captureStartTime == -1L) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - this.captureStartTime;
        return Math.min(1.0f, (float)elapsed / ((float)this.captureTime * 1000.0f));
    }

    public float getCooldownProgress() {
        if (!this.onCooldown) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - this.cooldownStartTime;
        return Math.min(1.0f, (float)elapsed / ((float)this.cooldownTime * 1000.0f));
    }
}

