/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import ru.pi.subcapts.client.ClientCapturePoint;

public class ClientCapturePointManager {
    private static final Map<String, ClientCapturePoint> POINTS = new HashMap<String, ClientCapturePoint>();

    public static void updatePoint(String name, BlockPos pos, int notifyRadius, int captureTime, int cooldownTime, long captureStartTime, long cooldownStartTime, boolean onCooldown, String capturingTeam) {
        ClientCapturePoint point = POINTS.get(name);
        if (point == null) {
            point = new ClientCapturePoint(name, pos, notifyRadius, captureTime, cooldownTime);
            POINTS.put(name, point);
        }
        point.setCaptureStartTime(captureStartTime);
        point.setCooldownStartTime(cooldownStartTime);
        point.setOnCooldown(onCooldown);
        point.setCapturingTeam(capturingTeam);
    }

    public static Iterable<ClientCapturePoint> getPoints() {
        return POINTS.values();
    }

    public static ClientCapturePoint getPointByName(String name) {
        return POINTS.get(name);
    }
}

