/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import ru.pi.subcapts.capture.CapturePoint;
import ru.pi.subcapts.capture.CapturePointManager;

public class CaptureConfig {
    private static final File CONFIG_FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "subcapts-points.toml");

    public static void savePoints() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)CONFIG_FILE).sync().autosave().preserveInsertionOrder().build();
        config.load();
        ArrayList<Config> serializedPoints = new ArrayList<Config>();
        for (CapturePoint p : CapturePointManager.getPoints()) {
            Config entry = Config.inMemory();
            entry.set("name", (Object)p.getName());
            entry.set("x", (Object)p.getPosition().m_123341_());
            entry.set("y", (Object)p.getPosition().m_123342_());
            entry.set("z", (Object)p.getPosition().m_123343_());
            entry.set("notifyRadius", (Object)p.getNotifyRadius());
            entry.set("captureRadius", (Object)p.getCaptureRadius());
            entry.set("captureTime", (Object)p.getCaptureTime());
            entry.set("cooldownTime", (Object)p.getCooldownTime());
            entry.set("color", (Object)p.getColor());
            entry.set("maxonline", (Object)p.getMaxOnline());
            ArrayList<String> rewards = new ArrayList<String>();
            for (ItemStack stack : p.getRewardItems()) {
                CompoundTag tag = new CompoundTag();
                stack.m_41739_(tag);
                rewards.add(tag.toString());
            }
            entry.set("rewards", rewards);
            serializedPoints.add(entry);
        }
        config.set("points", serializedPoints);
        config.save();
        config.close();
    }

    public static void loadPoints() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)CONFIG_FILE).sync().autosave().preserveInsertionOrder().build();
        config.load();
        CapturePointManager.getPoints().clear();
        List points = (List)config.get("points");
        if (points != null) {
            for (Config c : points) {
                try {
                    String name = (String)c.get("name");
                    int x = (Integer)c.get("x");
                    int y = (Integer)c.get("y");
                    int z = (Integer)c.get("z");
                    int notifyRadius = (Integer)c.get("notifyRadius");
                    int captureRadius = (Integer)c.get("captureRadius");
                    int captureTime = (Integer)c.get("captureTime");
                    int cooldownTime = (Integer)c.get("cooldownTime");
                    String color = (String)c.get("color");
                    int maxonline = (Integer)c.get("maxonline");
                    CapturePoint point = new CapturePoint(name, new BlockPos(x, y, z), notifyRadius, captureRadius, captureTime, cooldownTime, color, maxonline);
                    List rewards = (List)c.get("rewards");
                    if (rewards != null) {
                        for (String s : rewards) {
                            try {
                                CompoundTag tag = TagParser.m_129359_((String)s);
                                point.addRewardItem(ItemStack.m_41712_((CompoundTag)tag));
                            }
                            catch (Exception ignored) {
                                System.err.println("[SubCapts] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0438\u0437 \u0442\u043e\u0447\u043a\u0438 " + name);
                            }
                        }
                    }
                    CapturePointManager.addPoint(point);
                }
                catch (Exception e) {
                    System.err.println("[SubCapts] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0442\u043e\u0447\u043a\u0438: " + e.getMessage());
                }
            }
        }
        config.close();
    }

    public static void addRewardItem(String pointName, ItemStack stack) {
        for (CapturePoint point : CapturePointManager.getPoints()) {
            if (!point.getName().equalsIgnoreCase(pointName)) continue;
            point.addRewardItem(stack);
            CaptureConfig.savePoints();
            return;
        }
    }
}

