/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.network.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.pi.subcapts.capture.CapturePoint;
import ru.pi.subcapts.client.ClientCapturePointManager;

public class CapturePointStatusPacket {
    private final String name;
    private final BlockPos pos;
    private final int notifyRadius;
    private final int captureTime;
    private final int cooldownTime;
    private final long captureStartTime;
    private final long cooldownStartTime;
    private final boolean onCooldown;
    private final String capturingTeam;

    public CapturePointStatusPacket(CapturePoint point) {
        this.name = point.getName();
        this.pos = point.getPosition();
        this.notifyRadius = point.getNotifyRadius();
        this.captureTime = point.getCaptureTime();
        this.cooldownTime = point.getCooldownTime();
        this.captureStartTime = point.getCaptureStartTime();
        this.cooldownStartTime = point.getCooldownStartTime();
        this.onCooldown = point.isOnCooldown();
        this.capturingTeam = point.getCapturingTeam();
    }

    public CapturePointStatusPacket(String name, BlockPos pos, int notifyRadius, int captureTime, int cooldownTime, long captureStartTime, long cooldownStartTime, boolean onCooldown, String capturingTeam) {
        this.name = name;
        this.pos = pos;
        this.notifyRadius = notifyRadius;
        this.captureTime = captureTime;
        this.cooldownTime = cooldownTime;
        this.captureStartTime = captureStartTime;
        this.cooldownStartTime = cooldownStartTime;
        this.onCooldown = onCooldown;
        this.capturingTeam = capturingTeam;
    }

    public static void encode(CapturePointStatusPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.name);
        buf.m_130064_(pkt.pos);
        buf.writeInt(pkt.notifyRadius);
        buf.writeInt(pkt.captureTime);
        buf.writeInt(pkt.cooldownTime);
        buf.writeLong(pkt.captureStartTime);
        buf.writeLong(pkt.cooldownStartTime);
        buf.writeBoolean(pkt.onCooldown);
        buf.m_130070_(pkt.capturingTeam == null ? "" : pkt.capturingTeam);
    }

    public static CapturePointStatusPacket decode(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        BlockPos pos = buf.m_130135_();
        int notifyRadius = buf.readInt();
        int captureTime = buf.readInt();
        int cooldownTime = buf.readInt();
        long captureStartTime = buf.readLong();
        long cooldownStartTime = buf.readLong();
        boolean onCooldown = buf.readBoolean();
        String capturingTeam = buf.m_130277_();
        if (capturingTeam.isEmpty()) {
            capturingTeam = null;
        }
        return new CapturePointStatusPacket(name, pos, notifyRadius, captureTime, cooldownTime, captureStartTime, cooldownStartTime, onCooldown, capturingTeam);
    }

    public static void handle(CapturePointStatusPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientCapturePointManager.updatePoint(pkt.name, pkt.pos, pkt.notifyRadius, pkt.captureTime, pkt.cooldownTime, pkt.captureStartTime, pkt.cooldownStartTime, pkt.onCooldown, pkt.capturingTeam));
        ctx.get().setPacketHandled(true);
    }
}

