/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.subcapts.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.pi.subcapts.client.CaptureClientManager;
import ru.pi.subcapts.client.CapturePointClient;

public class SpawnPointPacket {
    public final String name;
    public final int x;
    public final int y;
    public final int z;
    public final int notifyRadius;
    public final int captureRadius;
    public final int captureTime;
    public final int cooldownTime;
    public final String color;
    public final int maxonline;

    public SpawnPointPacket(String name, int x, int y, int z, int notifyRadius, int captureRadius, int captureTime, int cooldownTime, String color, int maxonline) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.notifyRadius = notifyRadius;
        this.captureRadius = captureRadius;
        this.captureTime = captureTime;
        this.cooldownTime = cooldownTime;
        this.color = color;
        this.maxonline = maxonline;
    }

    public static void encode(SpawnPointPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.name);
        buf.writeInt(pkt.x);
        buf.writeInt(pkt.y);
        buf.writeInt(pkt.z);
        buf.writeInt(pkt.notifyRadius);
        buf.writeInt(pkt.captureRadius);
        buf.writeInt(pkt.captureTime);
        buf.writeInt(pkt.cooldownTime);
        buf.m_130070_(pkt.color);
        buf.writeInt(pkt.maxonline);
    }

    public static SpawnPointPacket decode(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        int notify = buf.readInt();
        int capRadius = buf.readInt();
        int capTime = buf.readInt();
        int cooldown = buf.readInt();
        String color = buf.m_130277_();
        int maxonline = buf.readInt();
        return new SpawnPointPacket(name, x, y, z, notify, capRadius, capTime, cooldown, color, maxonline);
    }

    public static void handle(SpawnPointPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CaptureClientManager.addPoint(new CapturePointClient(pkt.name, pkt.x, pkt.y, pkt.z, pkt.notifyRadius, pkt.captureRadius, pkt.captureTime, pkt.cooldownTime, pkt.color, pkt.maxonline)));
        ctx.get().setPacketHandled(true);
    }
}

