/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.blocks.PanelBlock;
import com.wenxin2.marioverse.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class QuestionPanelBlock
extends PanelBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<QuestionPanelBlock> CODEC = QuestionPanelBlock.simpleCodec(QuestionPanelBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    @Override
    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public QuestionPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACE, FACING, POWERED, WATERLOGGED});
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        int power = this.getSignalForState(state);
        if (power == 0) {
            this.checkPressed(entity, world, pos, state, power);
        }
    }

    protected void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        int power = this.getSignalForState(state);
        if (power > 0) {
            this.checkPressed(null, (Level)serverWorld, pos, state, power);
        }
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState neighborState, boolean isMoving) {
        if (!isMoving && !state.is(neighborState.getBlock())) {
            if (this.getSignalForState(state) > 0) {
                this.updateNeighbours(world, pos);
            }
            super.onRemove(state, world, pos, neighborState, isMoving);
        }
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    protected int getSignal(BlockState state, BlockGetter blockGetter, BlockPos pos, Direction direction) {
        return this.getSignalForState(state);
    }

    protected int getDirectSignal(BlockState state, BlockGetter blockGetter, BlockPos pos, Direction direction) {
        return direction == Direction.UP ? this.getSignalForState(state) : 0;
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getPressedTime() {
        return 40;
    }

    protected int getSignalForState(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState state, int signalStrength) {
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signalStrength > 0));
    }

    protected int getSignalStrength(Level world, BlockPos pos) {
        return QuestionPanelBlock.getEntityCount(world, QuestionPanelBlock.getTouchAABB(world.getBlockState(pos)).move(pos), LivingEntity.class) > 0 ? 15 : 0;
    }

    protected static int getEntityCount(Level world, AABB aabb, Class<? extends Entity> entityClass) {
        return world.getEntitiesOfClass(entityClass, aabb, EntitySelector.NO_SPECTATORS.and(entity -> !entity.isIgnoringBlockTriggers())).size();
    }

    protected void updateNeighbours(Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, (Block)this);
        world.updateNeighborsAt(pos.below(), (Block)this);
    }

    private void checkPressed(@Nullable Entity entity, Level world, BlockPos pos, BlockState state, int power) {
        boolean isSignaled;
        int signalStrength = this.getSignalStrength(world, pos);
        boolean isPowered = power > 0;
        boolean bl = isSignaled = signalStrength > 0;
        if (power != signalStrength) {
            BlockState stateSignal = this.setSignalForState(state, signalStrength);
            world.setBlock(pos, stateSignal, 2);
            this.updateNeighbours(world, pos);
            world.setBlocksDirty(pos, state, stateSignal);
        }
        if (!isSignaled && isPowered) {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.QUESTION_PANEL_DEACTIVATED.get(), SoundSource.BLOCKS);
            world.gameEvent(entity, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
        } else if (isSignaled && !isPowered) {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.QUESTION_PANEL_ACTIVATED.get(), SoundSource.BLOCKS);
            world.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
        }
        if (isSignaled) {
            world.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.getPressedTime());
        }
    }

    private static AABB getTouchAABB(BlockState state) {
        AttachFace face = (AttachFace)state.getValue((Property)FACE);
        Direction facing = (Direction)state.getValue((Property)FACING);
        switch (face) {
            case FLOOR: {
                return FLOOR.bounds();
            }
            case CEILING: {
                return CEILING.bounds();
            }
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        return NORTH.bounds();
                    }
                    case SOUTH: {
                        return SOUTH.bounds();
                    }
                    case WEST: {
                        return WEST.bounds();
                    }
                    case EAST: {
                        return EAST.bounds();
                    }
                }
            }
        }
        return FLOOR.bounds();
    }
}

