/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.models.blocks;

import com.wenxin2.marioverse.blocks.GoalPoleBlock;
import com.wenxin2.marioverse.blocks.entities.GoalPoleBlockEntity;
import com.wenxin2.marioverse.blocks.states.ColumnBlockStates;
import com.wenxin2.marioverse.registries.BlockRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class GoalPoleBlockModel
extends GeoModel<GoalPoleBlockEntity> {
    private final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"geo/block/goal_pole.geo.json");
    private final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"animations/block/goal_pole.animation.json");
    private final ResourceLocation AMERICAN_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/american_flag.png");
    private final ResourceLocation BOWSER_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/bowser_flag.png");
    private final ResourceLocation CLASSIC_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/classic_flag.png");
    private final ResourceLocation WONDER_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/wonder_flag.png");
    private final ResourceLocation AMERICAN_FLAG_SMALL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/american_flag_small.png");
    private final ResourceLocation BOWSER_FLAG_SMALL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/bowser_flag_small.png");
    private final ResourceLocation CLASSIC_FLAG_SMALL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/classic_flag_small.png");
    private final ResourceLocation WONDER_FLAG_SMALL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/goal_pole/wonder_flag_small.png");

    public ResourceLocation getModelResource(GoalPoleBlockEntity block) {
        return this.MODEL;
    }

    public ResourceLocation getTextureResource(GoalPoleBlockEntity blockEntity) {
        String colorName;
        BlockState state = blockEntity.getBlockState();
        Block block = blockEntity.getBlockState().getBlock();
        BlockPos pos = blockEntity.getBlockPos();
        DyeColor color = null;
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.GOAL_POLES.entrySet()) {
            if (entry.getValue().get() != block) continue;
            color = entry.getKey();
            break;
        }
        String texturePath = "textures/entity/goal_pole/";
        String string = colorName = color != null ? color.getName().toLowerCase() : "white";
        if (state.getValue(GoalPoleBlock.COLUMN) == ColumnBlockStates.NONE) {
            if (blockEntity.hasAmericanFlag()) {
                return this.AMERICAN_FLAG_SMALL_TEXTURE;
            }
            if (!blockEntity.hasWonderFlag() && block == BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                return this.CLASSIC_FLAG_SMALL_TEXTURE;
            }
            if (((Boolean)state.getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
                return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)(texturePath + colorName + "_flag_small.png"));
            }
            if (blockEntity.hasWonderFlag()) {
                return this.WONDER_FLAG_SMALL_TEXTURE;
            }
            return this.BOWSER_FLAG_SMALL_TEXTURE;
        }
        if (blockEntity.hasAmericanFlag()) {
            return this.AMERICAN_FLAG_TEXTURE;
        }
        if (!blockEntity.hasWonderFlag() && block == BlockRegistry.CLASSIC_GOAL_POLE.get()) {
            return this.CLASSIC_FLAG_TEXTURE;
        }
        if (((Boolean)state.getValue((Property)GoalPoleBlock.LOWERED)).booleanValue()) {
            if (blockEntity.hasWonderFlag() && state.getValue(GoalPoleBlock.COLUMN) == ColumnBlockStates.MIDDLE && block == BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                return this.WONDER_FLAG_TEXTURE;
            }
            if (state.getValue(GoalPoleBlock.COLUMN) == ColumnBlockStates.MIDDLE) {
                return this.BOWSER_FLAG_TEXTURE;
            }
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)(texturePath + colorName + "_flag.png"));
        }
        if (blockEntity.hasWonderFlag()) {
            return this.WONDER_FLAG_TEXTURE;
        }
        return this.BOWSER_FLAG_TEXTURE;
    }

    public ResourceLocation getAnimationResource(GoalPoleBlockEntity block) {
        return this.ANIMATION;
    }

    public void setCustomAnimations(GoalPoleBlockEntity animatable, long instanceId, AnimationState<GoalPoleBlockEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        int rotationState = (Integer)animatable.getBlockState().getValue((Property)GoalPoleBlock.ROTATION);
        float[] rotationDegreesArray = new float[]{90.0f, 67.5f, 45.0f, 22.5f, 0.0f, 337.5f, 315.0f, 292.5f, 270.0f, 247.5f, 225.0f, 202.5f, 180.0f, 157.5f, 135.0f, 112.5f};
        float rotationDegrees = rotationDegreesArray[rotationState];
        Optional poleBone = this.getBone("pole");
        poleBone.ifPresent(geoBone -> geoBone.setRotY((float)Math.toRadians(rotationDegrees)));
    }
}

