/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.costumes;

import com.wenxin2.marioverse.items.CostumeItem;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Optional;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class CostumeRenderer
extends GeoArmorRenderer<CostumeItem> {
    protected GeoBone dress = null;
    protected GeoBone waist = null;
    private static final DefaultedItemGeoModel<CostumeItem> MARIO_MODEL = new DefaultedItemGeoModel(ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"costume/mario_costume"));
    private static final DefaultedItemGeoModel<CostumeItem> LUIGI_MODEL = new DefaultedItemGeoModel(ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"costume/luigi_costume"));
    private static final DefaultedItemGeoModel<CostumeItem> PEACH_MODEL = new DefaultedItemGeoModel(ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"costume/peach_costume"));

    public CostumeRenderer() {
        super((GeoModel)new DefaultedItemGeoModel(ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"costume/mario_costume")));
    }

    @Nullable
    public GeoBone getWaistBone(GeoModel<CostumeItem> model) {
        return model.getBone("armorWaist").orElse(null);
    }

    @Nullable
    public GeoBone getDressBone(GeoModel<CostumeItem> model) {
        return model.getBone("armorDress").orElse(null);
    }

    public ResourceLocation getTextureLocation(CostumeItem animatable) {
        ItemStack stack = this.currentStack;
        if (stack.is(TagRegistry.FIRE_COSTUMES)) {
            if (stack.is(TagRegistry.LUIGI_FIRE_COSTUMES)) {
                return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/luigi_fire_costume.png");
            }
            if (stack.is(TagRegistry.PEACH_FIRE_COSTUMES)) {
                return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/peach_fire_costume.png");
            }
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/mario_fire_costume.png");
        }
        if (stack.is(TagRegistry.ICE_COSTUMES)) {
            if (stack.is(TagRegistry.LUIGI_ICE_COSTUMES)) {
                return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/luigi_ice_costume.png");
            }
            if (stack.is(TagRegistry.PEACH_ICE_COSTUMES)) {
                return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/peach_ice_costume.png");
            }
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/mario_ice_costume.png");
        }
        if (stack.is(TagRegistry.MARIO_COSTUMES)) {
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/mario_costume.png");
        }
        if (stack.is(TagRegistry.LUIGI_COSTUMES)) {
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/luigi_costume.png");
        }
        if (stack.is(TagRegistry.PEACH_COSTUMES)) {
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/item/costume/peach_costume.png");
        }
        return super.getTextureLocation((GeoAnimatable)animatable);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        super.grabRelevantBones(bakedModel);
        if (this.lastModel != bakedModel) {
            GeoModel<CostumeItem> model = this.getGeoModel();
            this.lastModel = bakedModel;
            this.dress = this.getDressBone(model);
            this.waist = this.getWaistBone(model);
        }
    }

    public GeoModel<CostumeItem> getGeoModel() {
        ItemStack stack = this.currentStack;
        if (stack.is(TagRegistry.MARIO_COSTUMES)) {
            return MARIO_MODEL;
        }
        if (stack.is(TagRegistry.LUIGI_COSTUMES)) {
            return LUIGI_MODEL;
        }
        if (stack.is(TagRegistry.PEACH_COSTUMES)) {
            return PEACH_MODEL;
        }
        return super.getGeoModel();
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot slot) {
        this.setAllBonesVisible(false);
        CostumeRenderer model = this;
        Optional dressBone = this.getGeoModel().getBone("armorDress");
        Optional waistBone = this.getGeoModel().getBone("armorWaist");
        dressBone.ifPresent(geoBone -> this.setBoneVisible((GeoBone)geoBone, false));
        waistBone.ifPresent(geoBone -> this.setBoneVisible((GeoBone)geoBone, false));
        switch (this.currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.head, ((HumanoidModel)model).head.visible);
                break;
            }
            case CHEST: {
                this.setBoneVisible(this.body, ((HumanoidModel)model).body.visible);
                this.setBoneVisible(this.rightArm, ((HumanoidModel)model).rightArm.visible);
                this.setBoneVisible(this.leftArm, ((HumanoidModel)model).leftArm.visible);
                break;
            }
            case LEGS: {
                dressBone.ifPresent(arg_0 -> this.lambda$applyBoneVisibilityBySlot$2((HumanoidModel)model, arg_0));
                waistBone.ifPresent(arg_0 -> this.lambda$applyBoneVisibilityBySlot$3((HumanoidModel)model, arg_0));
                this.setBoneVisible(this.rightLeg, ((HumanoidModel)model).rightLeg.visible);
                this.setBoneVisible(this.leftLeg, ((HumanoidModel)model).leftLeg.visible);
                break;
            }
            case FEET: {
                this.setBoneVisible(this.rightBoot, ((HumanoidModel)model).rightLeg.visible);
                this.setBoneVisible(this.leftBoot, ((HumanoidModel)model).leftLeg.visible);
            }
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        ModelPart bodyPart;
        super.applyBaseTransformations(baseModel);
        Optional dressBone = this.getGeoModel().getBone("armorDress");
        Optional waistBone = this.getGeoModel().getBone("armorWaist");
        if (waistBone.isPresent()) {
            bodyPart = baseModel.body;
            RenderUtil.matchModelPartRot((ModelPart)bodyPart, (GeoBone)((GeoBone)waistBone.get()));
            ((GeoBone)waistBone.get()).updatePosition(bodyPart.x, -bodyPart.y, bodyPart.z);
            if (baseModel.crouching) {
                ((GeoBone)waistBone.get()).updatePosition(bodyPart.x, -bodyPart.y, bodyPart.z);
                ((GeoBone)waistBone.get()).setRotX(-bodyPart.xRot);
            }
        }
        if (dressBone.isPresent()) {
            bodyPart = baseModel.body;
            ((GeoBone)dressBone.get()).updatePosition(bodyPart.x, -bodyPart.y, bodyPart.z);
            if (baseModel.crouching) {
                ((GeoBone)dressBone.get()).updatePosition(bodyPart.x, -bodyPart.y + 4.0f, bodyPart.z + 5.5f);
            }
        }
    }

    private /* synthetic */ void lambda$applyBoneVisibilityBySlot$3(HumanoidModel model, GeoBone geoBone) {
        this.setBoneVisible(geoBone, model.body.visible);
    }

    private /* synthetic */ void lambda$applyBoneVisibilityBySlot$2(HumanoidModel model, GeoBone geoBone) {
        this.setBoneVisible(geoBone, model.body.visible);
    }
}

