/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.PiranhaPlantModel;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class PiranhaPlantRenderer
extends GeoEntityRenderer<PiranhaPlantEntity> {
    public PiranhaPlantRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new PiranhaPlantModel());
    }

    protected float getDeathMaxRotation(PiranhaPlantEntity animatable) {
        return 0.0f;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, PiranhaPlantEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        Optional root = model.getBone("root");
        Optional head = model.getBone("head");
        if (animatable.isBaby()) {
            if (root.isPresent()) {
                ((GeoBone)root.get()).setScaleX(0.5f);
                ((GeoBone)root.get()).setScaleY(0.5f);
                ((GeoBone)root.get()).setScaleZ(0.5f);
            }
            if (head.isPresent()) {
                ((GeoBone)head.get()).setScaleX(1.25f);
                ((GeoBone)head.get()).setScaleY(1.25f);
                ((GeoBone)head.get()).setScaleZ(1.25f);
            }
        }
    }

    public void render(PiranhaPlantEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        if (Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            PiranhaPlantRenderer.renderHitboxes(poseStack, vertexConsumer, entity);
        }
    }

    protected void applyRotations(PiranhaPlantEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (animatable.getAttachedSide() != null) {
            switch (animatable.getAttachedSide()) {
                case UP: {
                    break;
                }
                case DOWN: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.translate(0.0, -1.0, 0.0);
                    break;
                }
                case NORTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, -0.5, 0.5);
                    break;
                }
                case SOUTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.translate(0.0, -0.5, -0.5);
                    break;
                }
                case EAST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    poseStack.translate(-0.5, -0.5, 0.0);
                    break;
                }
                case WEST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    poseStack.translate(0.5, -0.5, 0.0);
                }
            }
        }
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
    }

    private static void renderHitboxes(PoseStack poseStack, VertexConsumer vertexConsumer, PiranhaPlantEntity entity) {
        AABB mainBoundingBox = entity.makeBoundingBox();
        AABB headBoundingBox = entity.head.makeBoundingBox();
        AABB relativeBox = mainBoundingBox.move(-entity.getX(), -entity.getY(), -entity.getZ());
        AABB relativeBoxInflate = mainBoundingBox.move(-entity.getX(), -entity.getY(), -entity.getZ()).inflate(0.01);
        if (entity.isMultipartEntity()) {
            AABB piranhaPart = headBoundingBox.move(-entity.head.getX(), -entity.head.getY(), -entity.head.getZ());
            poseStack.pushPose();
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)piranhaPart, (float)0.25f, (float)1.0f, (float)0.0f, (float)1.0f);
            poseStack.popPose();
        }
        poseStack.pushPose();
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)relativeBox, (float)0.3f, (float)0.4f, (float)0.5f, (float)1.0f);
        poseStack.popPose();
        poseStack.pushPose();
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)relativeBoxInflate, (float)0.5f, (float)0.8f, (float)1.0f, (float)0.5f);
        poseStack.popPose();
    }
}

