/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.mojang.authlib.GameProfile;
import com.wenxin2.marioverse.entities.DryBonesPartEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.NearestAttackableTagGoal;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DryBonesEntity
extends Monster
implements GeoEntity {
    public static final RawAnimation ATTACK_SWING_LEFT = RawAnimation.begin().thenPlay("attack.swing.left");
    public static final RawAnimation ATTACK_SWING_RIGHT = RawAnimation.begin().thenPlay("attack.swing.right");
    public static final RawAnimation HIDE = RawAnimation.begin().thenPlayAndHold("move.hide");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    public static final RawAnimation SIT = RawAnimation.begin().thenLoop("misc.sit");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DryBonesEntity(EntityType<? extends DryBonesEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.xpReward = 8;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.DRY_BONES_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.DRY_BONES_DEATH.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.DRY_BONES_AMBIENT.get();
    }

    public int getAmbientSoundInterval() {
        return 360;
    }

    @NotNull
    public Item getKoopaShoes() {
        return (Item)ItemRegistry.WHITE_KOOPA_SHOES.get();
    }

    @NotNull
    public SimpleParticleType getShatterParticle() {
        return ParticleTypes.POOF;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(2, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.DRY_BONES_CAN_ATTACK, 8.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTagGoal((Mob)this, TagRegistry.DRY_BONES_CAN_ATTACK, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walk", 5, this::walkAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "hide_controller", 5, state -> PlayState.STOP).triggerableAnim("hide", HIDE));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)(this.isLeftHanded() ? ATTACK_SWING_LEFT : ATTACK_SWING_RIGHT)).transitionLength(1));
    }

    protected <E extends GeoAnimatable> PlayState walkAnimation(AnimationState<E> event) {
        if (this.isPassenger() && !(this.getVehicle() instanceof LivingEntity)) {
            event.setAndContinue(SIT);
            return PlayState.CONTINUE;
        }
        if (event.isMoving() || this.getDeltaMovement().horizontalDistance() >= 0.01) {
            event.setAndContinue(WALK);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void die(DamageSource source) {
        LivingEntity entity;
        ItemStack weapon;
        ItemEnchantments enchantments;
        Level world = this.level();
        Entity attacker = source.getEntity();
        if (attacker instanceof LivingEntity && (enchantments = (ItemEnchantments)(weapon = (entity = (LivingEntity)attacker).getMainHandItem()).get(DataComponents.ENCHANTMENTS)) != null) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                int level;
                Holder holder = (Holder)entry.getKey();
                if (!holder.is(TagRegistry.BYPASSES_BOO_INVULNERABILITY_ENCHANTS) || (level = entry.getIntValue()) <= 0) continue;
                super.die(source);
                return;
            }
        }
        if (!(this.level().isClientSide || this.isNoAi() || source.is(TagRegistry.PREVENTS_DRY_BONES_RESURRECTION))) {
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_HEAD.get()), world), "head", true, true);
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_SHELL.get()), world), "shell", true, true);
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_LEFT_ARM.get()), world), "left_arm", true, true);
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_LEFT_LEG.get()), world), "left_leg", true, true);
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_RIGHT_ARM.get()), world), "right_arm", true, true);
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_RIGHT_LEG.get()), world), "right_leg", true, true);
            this.spawnDryBonesPart(new DryBonesPartEntity((EntityType<? extends DryBonesPartEntity>)((EntityType)EntityRegistry.DRY_BONES_TAIL.get()), world), "tail", true, true);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)this.getShatterParticle(), serverWorld, (Entity)this, 0.0, 15);
            }
            if (this.getDeathSound() != null) {
                this.playSound(this.getDeathSound());
            }
            this.discard();
        } else {
            super.die(source);
        }
    }

    public boolean shouldDropExperience() {
        DamageSource source = this.getLastDamageSource();
        return source != null && source.is(TagRegistry.PREVENTS_DRY_BONES_RESURRECTION);
    }

    protected void dropEquipment() {
        DamageSource source = this.getLastDamageSource();
        if (source != null && source.is(TagRegistry.PREVENTS_DRY_BONES_RESURRECTION)) {
            return;
        }
        super.dropEquipment();
    }

    protected void dropFromLootTable(DamageSource source, boolean hitByPlayer) {
        if (source.is(TagRegistry.PREVENTS_DRY_BONES_RESURRECTION)) {
            super.dropFromLootTable(source, hitByPlayer);
        }
    }

    public int getCurrentSwingDuration() {
        if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
            return 10 - (1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)this));
        }
        return this.hasEffect(MobEffects.DIG_SLOWDOWN) ? 10 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2 : 10;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float height) {
        if (entity instanceof KoopaTroopaEntity || entity instanceof DryBonesEntity) {
            return new Vec3(0.0, (double)this.getBbHeight() - 0.5, 0.0);
        }
        return super.getPassengerAttachmentPoint(entity, dimensions, height);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        if (random.nextFloat() < 0.005f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.TURTLE_HELMET));
        }
        if (random.nextFloat() < 0.15f && this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.DIAMOND_BOOTS));
        } else if (random.nextFloat() < 0.85f && this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)this.getKoopaShoes()));
        }
        DryBonesEntity dryBonesEntity = this;
        if (dryBonesEntity instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)((Object)dryBonesEntity);
            float f = random.nextFloat();
            float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
            if (f < f2) {
                int randomPowerUpInt = random.nextInt(6);
                int randomCharacterInt = random.nextInt(1);
                if (randomPowerUpInt == 0) {
                    if (randomCharacterInt == 0) {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.MARIO_FIRE_HAT.get()));
                    } else {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.LUIGI_FIRE_HAT.get()));
                    }
                    handler.mv$setFireFlower(true);
                } else if (randomPowerUpInt == 1) {
                    if (randomCharacterInt == 0) {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.MARIO_ICE_HAT.get()));
                    } else {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.LUIGI_ICE_HAT.get()));
                    }
                    handler.mv$setIceFlower(true);
                } else {
                    this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        RandomSource random = serverWorld.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(serverWorld, random, difficulty);
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localDate = LocalDate.now();
            int day = localDate.getDayOfMonth();
            int month = localDate.getMonth().getValue();
            List players = serverWorld.getLevel().players();
            boolean isHalloween = month == 10 && day >= 30 && (Boolean)ConfigRegistry.DISABLE_DRY_BONES_MASKS.get() == false;
            boolean forceMasks = (Boolean)ConfigRegistry.FORCE_DRY_BONES_MASKS.get();
            Optional<Item> randomMask = BuiltInRegistries.ITEM.getTag(TagRegistry.HALLOWEEN_MASKS).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value);
            if (isHalloween || forceMasks) {
                ArrayList skulls;
                boolean appliedMask = false;
                if (random.nextFloat() < 0.25f) {
                    randomMask.ifPresent(item -> this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)item)));
                    appliedMask = this.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.HALLOWEEN_MASKS);
                }
                if (random.nextFloat() < 0.15f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.ITEM).getTagOrEmpty(ItemTags.SKULLS).forEach(holder -> {
                        Item item = (Item)holder.value();
                        skulls.add(new ItemStack((ItemLike)item));
                    });
                    if (!skulls.isEmpty()) {
                        ItemStack randomSkull = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        if (randomSkull.getItem() instanceof PlayerHeadItem && !players.isEmpty()) {
                            ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                            GameProfile playerProfile = randomPlayer.getGameProfile();
                            ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                            playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                            this.setItemSlot(EquipmentSlot.HEAD, playerHead);
                        } else {
                            this.setItemSlot(EquipmentSlot.HEAD, randomSkull);
                        }
                        appliedMask = true;
                    }
                }
                if (random.nextFloat() < 0.1f && !players.isEmpty()) {
                    ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                    GameProfile playerProfile = randomPlayer.getGameProfile();
                    SkullBlockEntity.fetchGameProfile((UUID)randomPlayer.getUUID());
                    ItemStack playerHeadItem = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                    playerHeadItem.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                    this.setItemSlot(EquipmentSlot.HEAD, playerHeadItem);
                    appliedMask = true;
                }
                if (random.nextFloat() < 0.05f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.BLOCK).getTagOrEmpty(CompatRegistry.TF_TROPHIES).forEach(holder -> skulls.add(new ItemStack((ItemLike)holder.value())));
                    if (!skulls.isEmpty()) {
                        ItemStack randomTrophy = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        this.setItemSlot(EquipmentSlot.HEAD, randomTrophy);
                        appliedMask = true;
                    }
                }
                if (appliedMask) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
                }
            }
        }
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    public static boolean checkDryBonesSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return !serverWorld.getBlockState(pos.below()).is(Blocks.NETHER_WART_BLOCK) && serverWorld.getBlockState(pos.below()).isValidSpawn((BlockGetter)serverWorld, pos, entityType) || spawnType == MobSpawnType.SPAWNER;
    }

    public void spawnDryBonesPart(DryBonesPartEntity entity, String type, boolean saveArmor, boolean savePowerUp) {
        float randomRotation = this.random.nextFloat() * 360.0f;
        double upwardMotion = 0.1 + this.random.nextDouble() * 0.2;
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        float width = this.getDimensions(this.getPose()).width() / 2.0f;
        double xOffset = Math.cos(angle) * (double)width * 0.25;
        double zOffset = Math.sin(angle) * (double)width * 0.25;
        if (type.equals("head")) {
            xOffset *= 4.0;
            zOffset *= 4.0;
        } else if (type.equals("shell")) {
            xOffset = 0.0;
            zOffset = 0.0;
        }
        entity.setOwnerUUID(this.getUUID());
        entity.setPos(this.getX(), this.getY(), this.getZ());
        entity.setYRot(randomRotation);
        entity.yBodyRot = randomRotation;
        entity.setYHeadRot(randomRotation);
        entity.setNoAi(this.isNoAi());
        entity.setInvulnerable(this.isInvulnerable());
        entity.setCustomName(this.getCustomName());
        entity.setData(DataAttachmentRegistry.DEATH_DURATION.get(), (Integer)ConfigRegistry.DRY_BONES_DEATH_DURATION.get());
        entity.setPartType(type);
        entity.moveTo(this.getX(), this.getY() + 0.5, this.getZ(), randomRotation, 0.0f);
        entity.setDeltaMovement(xOffset, upwardMotion, zOffset);
        entity.move(MoverType.SELF, entity.getDeltaMovement());
        if (this.isPersistenceRequired()) {
            entity.setPersistenceRequired();
        }
        this.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)Attributes.SCALE);
        this.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)AttributesRegistry.HEIGHT_SCALE);
        this.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)AttributesRegistry.WIDTH_SCALE);
        if (saveArmor) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = this.getItemBySlot(slot);
                if (stack.isEmpty() || !this.matchesArmorPart(type, slot)) continue;
                entity.setItemSlot(slot, stack.copy());
            }
        }
        if (savePowerUp) {
            AccessoriesCapability capability;
            String[] stringArray = this;
            if (stringArray instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)stringArray;
                if (entity instanceof AbilitiesHandler) {
                    AbilitiesHandler entityHandler = (AbilitiesHandler)((Object)entity);
                    entityHandler.mv$setSuperMushroom(handler.mv$hasSuperMushroom());
                    entityHandler.mv$setMegaMushroom(handler.mv$hasMegaMushroom());
                    entityHandler.mv$setFireFlower(handler.mv$hasFireFlower());
                    entityHandler.mv$setIceFlower(handler.mv$hasIceFlower());
                    entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Boolean)this.getData(DataAttachmentRegistry.HAS_SUPER_STAR));
                    entity.setData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN, (Integer)this.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN));
                }
            }
            if ((capability = AccessoriesCapability.get((LivingEntity)this)) != null && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get()).booleanValue() && this.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
                String[] slotTypes;
                for (String slotType : slotTypes = new String[]{"costume_hat", "costume_shirt", "costume_pants", "costume_shoes"}) {
                    AccessoriesContainer container = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)this, (String)slotType));
                    AccessoriesContainer containerEntity = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)slotType));
                    if (container == null) continue;
                    ItemStack stack = container.getAccessories().getItem(0);
                    if (containerEntity == null) continue;
                    containerEntity.getAccessories().setItem(0, stack);
                }
            }
        }
        this.level().addFreshEntity((Entity)entity);
    }

    public void copyAttributeWithModifiers(LivingEntity entity, Holder<Attribute> attribute) {
        AttributeInstance fromAttr = this.getAttribute(attribute);
        AttributeInstance toAttr = entity.getAttribute(attribute);
        if (fromAttr != null && toAttr != null) {
            toAttr.setBaseValue(fromAttr.getBaseValue());
            for (AttributeModifier modifier : fromAttr.getModifiers()) {
                toAttr.addPermanentModifier(modifier);
            }
        }
    }

    private boolean matchesArmorPart(String type, EquipmentSlot slot) {
        return switch (type) {
            case "head" -> {
                if (slot == EquipmentSlot.HEAD) {
                    yield true;
                }
                yield false;
            }
            case "left_leg", "right_leg" -> {
                if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
                    yield true;
                }
                yield false;
            }
            case "left_arm", "right_arm" -> {
                if (slot == EquipmentSlot.OFFHAND || slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.BODY) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

