/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.GoombaEntity;
import com.wenxin2.marioverse.entities.ai.controls.AmphibiousMoveControl;
import com.wenxin2.marioverse.entities.ai.goals.GoombaRideGoal;
import com.wenxin2.marioverse.entities.ai.goals.GoombaSitGoal;
import com.wenxin2.marioverse.entities.ai.goals.GoombaSleepGoal;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.NearestAttackableTagGoal;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class MiniGoombaEntity
extends GoombaEntity
implements GeoEntity {
    public LivingEntity stuckTo;
    private double currentX;
    private double currentY;
    private double currentZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private final Random random = new Random();
    private static final ResourceLocation SLOWDOWN_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"mini_goomba_slowdown");
    private static final double SLOWDOWN_FACTOR = 0.65;
    private static final double MOVE_SPEED = 0.25;
    private static final double POSITION_THRESHOLD = 0.05;
    private int currentSide = -1;
    private int currentCooldown = 0;
    private int switchCooldown = 20;
    private double easingFactor = 0.1;
    private boolean hasReachedTarget = false;

    public MiniGoombaEntity(EntityType<? extends MiniGoombaEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.setPathfindingMalus(PathType.WATER, 2.0f);
        this.moveControl = new AmphibiousMoveControl((PathfinderMob)this, 85, 10, 0.6f, 1.0f, true);
        this.xpReward = 1;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.MINI_GOOMBA_HURT.get();
    }

    @Override
    @NotNull
    public SoundEvent getStompSound() {
        return (SoundEvent)SoundRegistry.MINI_GOOMBA_STOMP.get();
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        SoundType soundtype = state.getSoundType((LevelReader)this.level(), pos, (Entity)this);
        this.playSound((SoundEvent)SoundRegistry.MINI_GOOMBA_STEP.get(), 1.0f, 1.0f);
        this.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
    }

    @Override
    protected SoundEvent getBumpSound() {
        return (SoundEvent)SoundRegistry.MINI_GOOMBA_BUMP.get();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.MINI_GOOMBA_CAN_ATTACH, 8.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new GoombaSitGoal(this, 0.25f, 1200, 3000, 300));
        this.goalSelector.addGoal(5, (Goal)new GoombaSleepGoal(this, 0.1f, 2400, 6000));
        this.goalSelector.addGoal(6, (Goal)new GoombaRideGoal(this, 0.01f));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTagGoal((Mob)this, TagRegistry.MINI_GOOMBA_CAN_ATTACH, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    @Override
    public boolean isWalking() {
        return this.getDeltaMovement().horizontalDistance() >= 0.001 && this.getDeltaMovement().horizontalDistance() < 0.5 || this.goalSelector.getAvailableGoals().stream().anyMatch(goal -> goal.isRunning() && goal.getGoal() instanceof RandomStrollGoal || this.walkDist > 0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.attachToEntity();
        if (this.stuckTo != null && this.stuckTo.getDeltaMovement().y > 0.0) {
            this.removeSpeedModifier(this.stuckTo);
            this.hurt(DamageSourceRegistry.defeated((Entity)this, (Entity)this.stuckTo), 1.0f);
            this.stuckTo = null;
        } else if (this.stuckTo != null && (this.isDeadOrDying() || this.stuckTo.isSpectator())) {
            this.removeSpeedModifier(this.stuckTo);
            this.stuckTo = null;
        } else if (this.stuckTo != null && this.stuckTo.isAlive() && this.getY() >= this.stuckTo.getY() && this.isAlive() && !(this.stuckTo.getDeltaMovement().y > 0.0)) {
            double distanceToTarget = this.distanceToTarget();
            if (distanceToTarget < 0.05) {
                this.generateRandomOffsets((Entity)this.stuckTo);
            }
            this.moveTowardsTarget();
            this.resetFallDistance();
            this.setPos(this.stuckTo.getX() + this.currentX, this.stuckTo.getY() + this.currentY, this.stuckTo.getZ() + this.currentZ);
        }
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
        }
    }

    @Override
    public void die(DamageSource source) {
        if (this.stuckTo != null) {
            this.removeSpeedModifier(this.stuckTo);
            this.stuckTo = null;
        }
        super.die(source);
    }

    public boolean canCollideWith(Entity entity) {
        return (this.stuckTo == null || (Boolean)ConfigRegistry.MINI_GOOMBAS_PUSH.get() != false) && super.canCollideWith(entity);
    }

    public boolean canBeCollidedWith() {
        return (this.stuckTo == null || (Boolean)ConfigRegistry.MINI_GOOMBAS_PUSH.get() != false) && super.canBeCollidedWith();
    }

    public boolean isColliding(BlockPos pos, BlockState state) {
        return (this.stuckTo == null || (Boolean)ConfigRegistry.MINI_GOOMBAS_PUSH.get() != false) && super.isColliding(pos, state);
    }

    protected void pushEntities() {
        if (this.stuckTo == null || ((Boolean)ConfigRegistry.MINI_GOOMBAS_PUSH.get()).booleanValue()) {
            super.pushEntities();
        }
    }

    public void push(Entity entity) {
        if (this.stuckTo == null || ((Boolean)ConfigRegistry.MINI_GOOMBAS_PUSH.get()).booleanValue()) {
            super.push(entity);
        }
    }

    public boolean isInWall() {
        return this.stuckTo == null && super.isInWall();
    }

    public boolean doHurtTarget(Entity target) {
        return false;
    }

    public void attachToEntity() {
        block2: {
            Entity entity2;
            Iterator iterator;
            AABB boundingBox = this.getBoundingBox().inflate(0.1);
            List entities = this.level().getEntities((Entity)this, boundingBox, entity -> entity != this);
            if (entities.isEmpty() || !(iterator = entities.iterator()).hasNext() || !((entity2 = (Entity)iterator.next()) instanceof LivingEntity)) break block2;
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (!(this.isNoAi() || livingEntity.isSpectator() || this.isPassenger() || this.getVehicle() instanceof MiniGoombaEntity || !livingEntity.getType().is(TagRegistry.MINI_GOOMBA_CAN_ATTACH) && !((Boolean)ConfigRegistry.MINI_GOOMBAS_ATTACH_ALL_MOBS.get()).booleanValue())) {
                if (this.stuckTo == null && this.isAlive()) {
                    this.playSound((SoundEvent)SoundRegistry.MINI_GOOMBA_ATTACH.get());
                }
                this.stuckTo = livingEntity;
                this.generateRandomOffsets((Entity)this.stuckTo);
                this.addSpeedModifier(this.stuckTo);
            }
        }
    }

    private void addSpeedModifier(LivingEntity livingEntity) {
        AttributeInstance speedAttribute = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && !speedAttribute.hasModifier(SLOWDOWN_MODIFIER)) {
            AttributeModifier slowdownModifier = new AttributeModifier(SLOWDOWN_MODIFIER, -0.65, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            speedAttribute.addTransientModifier(slowdownModifier);
        }
    }

    private void removeSpeedModifier(LivingEntity livingEntity) {
        AttributeInstance speedAttribute = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.hasModifier(SLOWDOWN_MODIFIER)) {
            speedAttribute.removeModifier(SLOWDOWN_MODIFIER);
        }
    }

    private double randomOffset(double min, double max) {
        return Mth.lerp((double)this.random.nextDouble(), (double)min, (double)max);
    }

    private void generateRandomOffsets(Entity entity) {
        double width = (double)entity.getBbWidth() + 0.8;
        double height = (double)entity.getBbHeight() + 0.8;
        int newSide = this.random.nextInt(6);
        if (this.currentCooldown > 0) {
            return;
        }
        while (newSide == this.currentSide) {
            newSide = this.random.nextInt(6);
        }
        this.currentSide = newSide;
        switch (this.currentSide) {
            case 0: {
                this.targetX = this.randomOffset(-width / 2.0, width / 2.0);
                this.targetY = height;
                this.targetZ = this.randomOffset(-width / 2.0, width / 2.0);
                break;
            }
            case 1: {
                this.targetX = this.randomOffset(-width / 2.0, width / 2.0);
                this.targetY = 0.5;
                this.targetZ = this.randomOffset(-width / 2.0, width / 2.0);
                break;
            }
            case 2: {
                this.targetX = this.randomOffset(-width / 2.0, width / 2.0);
                this.targetY = this.randomOffset(0.0, height);
                this.targetZ = width / 2.0;
                break;
            }
            case 3: {
                this.targetX = this.randomOffset(-width / 2.0, width / 2.0);
                this.targetY = this.randomOffset(0.0, height);
                this.targetZ = -width / 2.0;
                break;
            }
            case 4: {
                this.targetX = width / 2.0;
                this.targetY = this.randomOffset(0.0, height);
                this.targetZ = this.randomOffset(-width / 2.0, width / 2.0);
                break;
            }
            case 5: {
                this.targetX = -width / 2.0;
                this.targetY = this.randomOffset(0.0, height);
                this.targetZ = this.randomOffset(-width / 2.0, width / 2.0);
            }
        }
        if (this.currentCooldown == 0) {
            this.currentCooldown = this.switchCooldown;
        }
        this.hasReachedTarget = false;
    }

    private double distanceToTarget() {
        return Math.sqrt((this.targetX - this.currentX) * (this.targetX - this.currentX) + (this.targetY - this.currentY) * (this.targetY - this.currentY) + (this.targetZ - this.currentZ) * (this.targetZ - this.currentZ));
    }

    private void moveTowardsTarget() {
        if (!this.hasReachedTarget) {
            this.currentX += (this.targetX - this.currentX) * this.easingFactor * 0.25;
            this.currentY += (this.targetY - this.currentY) * this.easingFactor * 0.25;
            this.currentZ += (this.targetZ - this.currentZ) * this.easingFactor * 0.25;
            if (this.distanceToTarget() < 0.1) {
                this.hasReachedTarget = true;
            }
            if (this.hasReachedTarget && this.currentCooldown <= 0) {
                this.generateRandomOffsets((Entity)this.stuckTo);
            }
        }
    }
}

