/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.InvisibleQuestionBlock;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.StarCoinBlock;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.power_ups.AbstractPowerUpEntity;
import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.SuperStarEntity;
import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.CostumeHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AbilitiesHandler
extends CostumeHandler {
    public void mv$clearAllPowerUps();

    public boolean mv$hasSuperMushroom();

    public void mv$setSuperMushroom(boolean var1);

    public boolean mv$hasSuperMushroomOverride();

    public void mv$setMushroomOverride(boolean var1);

    public boolean mv$hasDashMushroomBoost();

    public void mv$setDashMushroomBoost(boolean var1);

    public boolean mv$hasMegaMushroom();

    public void mv$setMegaMushroom(boolean var1);

    public boolean mv$hasFireFlower();

    public void mv$setFireFlower(boolean var1);

    public boolean mv$hasIceFlower();

    public void mv$setIceFlower(boolean var1);

    public int mv$getFireballCooldown();

    public void mv$setFireballCooldown(int var1);

    public int mv$getFireballCount();

    public void mv$setFireballCount(int var1);

    public int mv$getIceBallCooldown();

    public void mv$setIceBallCooldown(int var1);

    public int mv$getIceBallCount();

    public void mv$setIceBallCount(int var1);

    public int mv$getCheckpointFlagCooldown();

    public void mv$setCheckpointFlagCooldown(int var1);

    public int mv$getConsecutiveBounces();

    public void mv$setConsecutiveBounces(int var1);

    public int mv$getFreezeImmunityCooldown();

    public void mv$setFreezeImmunityCooldown(int var1);

    public int mv$getFrozenCooldown();

    public void mv$setFrozenCooldown(int var1);

    public int mv$getOneUpsRewarded();

    public void mv$setOneUpsRewarded(int var1);

    @NotNull
    private static Boolean getDamageShrinksConfig(LivingEntity entity) {
        if (entity instanceof Player) {
            return (Boolean)ConfigRegistry.DAMAGE_SHRINKS_PLAYERS.get() != false || entity.level().getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_PLAYERS);
        }
        return (Boolean)ConfigRegistry.DAMAGE_SHRINKS_ALL_MOBS.get() != false || entity.level().getGameRules().getBoolean(Marioverse.DAMAGE_SHRINKS_ALL_MOBS);
    }

    @NotNull
    private static Boolean equipCostumes(LivingEntity entity) {
        if (entity instanceof Player) {
            return (Boolean)ConfigRegistry.EQUIP_COSTUMES_PLAYERS.get();
        }
        return (Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get();
    }

    default public void applyMushroomPowerUp(Level world, LivingEntity entity, @Nullable MushroomEntity powerUp, float healthHealed) {
        if (!entity.isSpectator() && AbilitiesHandler.getDamageShrinksConfig(entity).booleanValue() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_SUPER_MUSHROOMS) || ((Boolean)ConfigRegistry.SUPER_MUSHROOM_POWERS_ALL_MOBS.get()).booleanValue())) {
            this.mv$setSuperMushroom(true);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)entity, 10);
            }
            if (!world.isClientSide) {
                if (entity.getHealth() < entity.getMaxHealth()) {
                    entity.heal(healthHealed);
                }
                if (!entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS)) {
                    world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT);
                }
            }
            if (powerUp != null) {
                powerUp.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    default public void applyOneUpMushroomPowerUp(Level world, ItemStack stack, LivingEntity entity, OneUpMushroomEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue())) {
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)entity);
            ItemStack offhandStack = entity.getOffhandItem();
            if (capability != null && !capability.isEquipped((Item)ItemRegistry.ONE_UP_MUSHROOM.get())) {
                capability.attemptToEquipAccessory(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
            } else if (offhandStack.isEmpty()) {
                entity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)stack.getItem()));
            } else if (offhandStack.getItem() instanceof OneUpMushroomItem) {
                if (offhandStack.getCount() >= offhandStack.getMaxStackSize() && entity instanceof Player) {
                    Player player = (Player)entity;
                    player.drop(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()), Boolean.FALSE.booleanValue());
                } else {
                    offhandStack.grow(1);
                }
            }
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), SoundSource.AMBIENT);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.POWERED_UP.get(), serverWorld, (Entity)entity, 10);
                ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)entity, 1.0);
            }
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void applySuperStarPowerUp(Level world, LivingEntity entity, SuperStarEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_SUPER_STARS) || ((Boolean)ConfigRegistry.SUPER_STAR_POWERS_ALL_MOBS.get()).booleanValue())) {
            entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Object)true);
            entity.setData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN, (Object)((Integer)ConfigRegistry.SUPER_STAR_DURATION.get()));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, ((Integer)ConfigRegistry.SUPER_STAR_SPEED_DURATION.get()).intValue(), 4, true, false));
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.RAINBOW_GLINT.get(), serverWorld, (Entity)entity, 10);
            }
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP_SUPER_STAR.get(), SoundSource.AMBIENT);
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void applyFireFlowerPowerUp(Level world, LivingEntity entity, AbstractPowerUpEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_FIRE_FLOWERS) || ((Boolean)ConfigRegistry.FIRE_FLOWER_POWERS_ALL_MOBS.get()).booleanValue())) {
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.FIRE_POWERED_UP.get(), serverWorld, (Entity)entity, 10);
            }
            if (entity.getHealth() < entity.getMaxHealth()) {
                entity.heal(((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
            }
            this.mv$clearAllPowerUps();
            this.mv$setSuperMushroom(true);
            this.mv$setFireFlower(true);
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT);
            this.applyCostumeChange(entity, powerUp);
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void applyIceFlowerPowerUp(Level world, LivingEntity entity, AbstractPowerUpEntity powerUp) {
        if (!entity.isSpectator() && !entity.getType().is(TagRegistry.CANNOT_CONSUME_POWER_UPS) && (entity.getType().is(TagRegistry.CAN_CONSUME_ICE_FLOWERS) || ((Boolean)ConfigRegistry.ICE_FLOWER_POWERS_ALL_MOBS.get()).booleanValue())) {
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnPoweredUpParticles((ParticleOptions)ParticleRegistry.ICE_POWERED_UP.get(), serverWorld, (Entity)entity, 10);
            }
            if (entity.getHealth() < entity.getMaxHealth()) {
                entity.heal(((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
            }
            this.mv$clearAllPowerUps();
            this.mv$setSuperMushroom(true);
            this.mv$setIceFlower(true);
            world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT);
            this.applyCostumeChange(entity, powerUp);
            powerUp.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public void mv$hitQuestionBlock(Level world, BlockPos pos, LivingEntity entity, QuestionBlockEntity questionBlockEntity) {
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof QuestionBlock) {
            BlockState currentState;
            QuestionBlock questionBlock = (QuestionBlock)block;
            ItemStack storedItem = questionBlockEntity.getTheItem();
            if (!((Boolean)world.getBlockState(pos).getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                this.mv$hitEntityAbove(pos, world, entity);
            }
            if (!storedItem.isEmpty() && !((Boolean)world.getBlockState(pos).getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                BlockState stateAbove = world.getBlockState(pos.above());
                ItemStack coinItem = new ItemStack((ItemLike)stateAbove.getBlock().asItem());
                Block block2 = stateAbove.getBlock();
                if (block2 instanceof StarCoinBlock) {
                    StarCoinBlock starCoin = (StarCoinBlock)block2;
                    StarCoinBlock.collectCoin(starCoin, world, stateAbove, pos.above(), (Entity)entity, coinItem);
                } else if (stateAbove.getBlock() instanceof CoinBlock) {
                    CoinBlock.collectCoin(world, stateAbove, pos.above(), (Entity)entity, coinItem);
                }
                if (!world.isClientSide) {
                    questionBlock.spawnFromQuestionBlock(world, pos, storedItem, (Entity)entity, Boolean.FALSE, Boolean.TRUE);
                }
                if (world.getBlockState(pos).is(BlockTags.GUARDED_BY_PIGLINS) && entity instanceof Player) {
                    Player player = (Player)entity;
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    ServerParticleUtils.spawnParticlesOnBlockFace((ParticleOptions)ParticleTypes.CRIT, serverWorld, pos, Direction.DOWN, (IntProvider)UniformInt.of((int)3, (int)4), () -> ServerParticleUtils.getRandomSpeedRanges(world.getRandom()), 0.65);
                }
                entity.setData(DataAttachmentRegistry.HAS_HIT_BLOCK.get(), (Object)true);
                QuestionBlock.playSounds(world, pos, storedItem);
                questionBlockEntity.splitTheItem(1);
                questionBlockEntity.setChanged();
            }
            if (storedItem.isEmpty() && !((Boolean)world.getBlockState(pos).getValue((Property)QuestionBlock.EMPTY)).booleanValue()) {
                currentState = world.getBlockState(pos);
                if (currentState.getBlock() instanceof QuestionBlock) {
                    world.setBlock(pos, (BlockState)currentState.setValue((Property)QuestionBlock.EMPTY, (Comparable)Boolean.TRUE), 3);
                }
                world.gameEvent((Entity)entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
            if (world.getBlockState(pos).getBlock() instanceof InvisibleQuestionBlock && ((Boolean)world.getBlockState(pos).getValue((Property)InvisibleQuestionBlock.INVISIBLE)).booleanValue()) {
                currentState = world.getBlockState(pos);
                world.setBlock(pos, (BlockState)currentState.setValue((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.FALSE), 3);
                world.gameEvent((Entity)entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
        }
    }

    default public void mv$smashBlock(Level world, BlockPos pos, BlockState state, LivingEntity entity) {
        BlockState stateAbove = world.getBlockState(pos.above());
        ItemStack coinItem = new ItemStack((ItemLike)stateAbove.getBlock().asItem());
        this.mv$hitEntityAbove(pos, world, entity);
        if (this.mv$hasSuperMushroom()) {
            if (state.getBlock() instanceof SlabBlock) {
                if (state.getValue((Property)SlabBlock.TYPE) == SlabType.DOUBLE) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP), 3);
                } else {
                    world.destroyBlock(pos, false);
                }
                world.levelEvent(2001, pos, Block.getId((BlockState)state));
            } else if (state.getBlock() instanceof DecoratedPotBlock) {
                world.setBlock(pos, (BlockState)state.setValue((Property)DecoratedPotBlock.CRACKED, (Comparable)Boolean.valueOf(true)), 4);
                world.destroyBlock(pos, true, (Entity)entity);
            } else {
                world.destroyBlock(pos, false);
            }
            entity.setData(DataAttachmentRegistry.HAS_HIT_BLOCK.get(), (Object)true);
            world.gameEvent((Entity)entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (state.is(BlockTags.CRYSTAL_SOUND_BLOCKS)) {
                world.playSound(null, pos, SoundType.AMETHYST.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (state.getBlock() instanceof DecoratedPotBlock) {
                world.playSound(null, pos, SoundType.DECORATED_POT.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.BLOCK_SMASH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            Block block = stateAbove.getBlock();
            if (block instanceof StarCoinBlock) {
                StarCoinBlock starCoin = (StarCoinBlock)block;
                StarCoinBlock.collectCoin(starCoin, world, stateAbove, pos.above(), (Entity)entity, coinItem);
            } else if (stateAbove.getBlock() instanceof CoinBlock) {
                CoinBlock.collectCoin(world, stateAbove, pos.above(), (Entity)entity, coinItem);
            }
        } else {
            world.playSound(null, pos, (SoundEvent)SoundRegistry.BLOCK_SMASH_FAIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!(state.getBlock() instanceof QuestionBlock)) {
                Block block = stateAbove.getBlock();
                if (block instanceof StarCoinBlock) {
                    StarCoinBlock starCoin = (StarCoinBlock)block;
                    StarCoinBlock.collectCoin(starCoin, world, stateAbove, pos.above(), (Entity)entity, coinItem);
                } else if (stateAbove.getBlock() instanceof CoinBlock) {
                    CoinBlock.collectCoin(world, stateAbove, pos.above(), (Entity)entity, coinItem);
                }
            }
        }
    }

    default public void mv$hitEntityAbove(BlockPos pos, Level world, LivingEntity attackingEntity) {
        AABB boundingBox = new AABB(pos.above()).inflate(0.01);
        List entitiesAbove = world.getEntities(null, boundingBox);
        if (!entitiesAbove.isEmpty()) {
            for (Entity entityAbove : entitiesAbove) {
                LivingEntity livingEntity;
                if (!(entityAbove instanceof LivingEntity) || !(livingEntity = (LivingEntity)entityAbove).onGround()) continue;
                entityAbove.setDeltaMovement(entityAbove.getDeltaMovement().add(0.0, 0.5, 0.0));
                if (world.getBlockState(pos).getBlock() instanceof QuestionBlock) {
                    if (livingEntity instanceof KoopaShellEntity) {
                        livingEntity.hurt(DamageSourceRegistry.bonked((Entity)livingEntity, (Entity)attackingEntity), 0.0f);
                        continue;
                    }
                    livingEntity.hurt(DamageSourceRegistry.bonked((Entity)livingEntity, (Entity)attackingEntity), 4.0f);
                    continue;
                }
                if (livingEntity instanceof KoopaShellEntity) {
                    livingEntity.hurt(DamageSourceRegistry.shrapnel((Entity)livingEntity, (Entity)attackingEntity), 0.0f);
                    continue;
                }
                livingEntity.hurt(DamageSourceRegistry.shrapnel((Entity)livingEntity, (Entity)attackingEntity), 4.0f);
            }
        }
    }
}

