/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.blocks.entities.GoalPoleBlockEntity;
import com.wenxin2.marioverse.blocks.states.ColumnBlockStates;
import com.wenxin2.marioverse.network.client_bound.data.AmericaNamePayload;
import com.wenxin2.marioverse.network.client_bound.data.WonderNamePayload;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoalPoleBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final MapCodec<GoalPoleBlock> CODEC = GoalPoleBlock.simpleCodec(GoalPoleBlock::new);
    public static final EnumProperty<ColumnBlockStates> COLUMN = EnumProperty.create((String)"column", ColumnBlockStates.class);
    public static final BooleanProperty FLAG = BooleanProperty.create((String)"flag");
    public static final BooleanProperty LOWERED = BooleanProperty.create((String)"lowered");
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int MAX = RotationSegment.getMaxSegmentIndex();
    private static final int ROTATIONS = MAX + 1;
    protected static final VoxelShape GOAL_POLE_MIDDLE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0).optimize();
    protected static final VoxelShape GOAL_POLE_TOP = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (VoxelShape)Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)).optimize();
    protected static final VoxelShape GOAL_POLE_TOP_COLLISION = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (VoxelShape)Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)15.95, (double)12.0)).optimize();
    protected static final VoxelShape GOAL_POLE_NONE = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).optimize();
    protected static final VoxelShape GOAL_POLE_NONE_COLLISION = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (VoxelShape)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)15.95, (double)11.0)).optimize();

    public GoalPoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLUMN, (Comparable)((Object)ColumnBlockStates.NONE))).setValue((Property)FLAG, (Comparable)Boolean.TRUE)).setValue((Property)LOWERED, (Comparable)Boolean.FALSE)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @NotNull
    public MapCodec<GoalPoleBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{COLUMN, FLAG, LOWERED, ROTATION, WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        if (state.getValue(COLUMN) == ColumnBlockStates.TOP) {
            return GOAL_POLE_TOP;
        }
        if (state.getValue(COLUMN) == ColumnBlockStates.NONE) {
            return GOAL_POLE_NONE;
        }
        return GOAL_POLE_MIDDLE;
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        if (state.getValue(COLUMN) == ColumnBlockStates.TOP) {
            return GOAL_POLE_TOP_COLLISION;
        }
        if (state.getValue(COLUMN) == ColumnBlockStates.NONE) {
            return GOAL_POLE_NONE_COLLISION;
        }
        return super.getCollisionShape(state, blockGetter, pos, context);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GoalPoleBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)placeContext.getRotation())));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        Block blockAbove = worldAccessor.getBlockState(pos.above()).getBlock();
        Block blockBelow = worldAccessor.getBlockState(pos.below()).getBlock();
        if (!worldAccessor.isClientSide()) {
            if (blockAbove instanceof GoalPoleBlock) {
                if (blockBelow instanceof GoalPoleBlock) {
                    return (BlockState)((BlockState)state.setValue(COLUMN, (Comparable)((Object)ColumnBlockStates.MIDDLE))).setValue((Property)FLAG, (Comparable)Boolean.FALSE);
                }
                return (BlockState)((BlockState)state.setValue(COLUMN, (Comparable)((Object)ColumnBlockStates.BOTTOM))).setValue((Property)FLAG, (Comparable)Boolean.FALSE);
            }
            if (blockBelow instanceof GoalPoleBlock) {
                return (BlockState)((BlockState)state.setValue(COLUMN, (Comparable)((Object)ColumnBlockStates.TOP))).setValue((Property)FLAG, (Comparable)Boolean.TRUE);
            }
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
            }
            return (BlockState)((BlockState)state.setValue(COLUMN, (Comparable)((Object)ColumnBlockStates.NONE))).setValue((Property)FLAG, (Comparable)Boolean.TRUE);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GoalPoleBlockEntity) {
            GoalPoleBlockEntity goalPoleBE = (GoalPoleBlockEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                goalPoleBE.setCustomName(stack.getHoverName());
                goalPoleBE.markUpdated();
                if (goalPoleBE.isWonderFlag()) {
                    goalPoleBE.setWonderFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WonderNamePayload(pos, goalPoleBE.hasWonderFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                } else if (goalPoleBE.isAmericanFlag()) {
                    goalPoleBE.setAmericanFlag(Boolean.TRUE);
                    if (!world.isClientSide()) {
                        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AmericaNamePayload(pos, goalPoleBE.hasAmericanFlag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        }
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = serverWorld.getBlockEntity(pos);
        if (blockEntity instanceof GoalPoleBlockEntity) {
            GoalPoleBlockEntity goalPoleBE = (GoalPoleBlockEntity)blockEntity;
            if (state.getValue(COLUMN) != ColumnBlockStates.MIDDLE) {
                if (goalPoleBE.isAmericanFlag() || state.getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                    goalPoleBE.stopTriggeredAnim("appear_controller", "appear");
                } else {
                    goalPoleBE.stopTriggeredAnim("switch_controller", "switch");
                }
            }
        }
        super.tick(state, serverWorld, pos, random);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.getType().is(TagRegistry.CAN_LOWER_FLAGS) && ((Boolean)state.getValue((Property)LOWERED)).booleanValue() && player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            BlockEntity blockEntity;
            BlockPos posTop = this.findTopOfGoalPole(world, pos);
            BlockState stateTop = world.getBlockState(posTop);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnParticleRingOnBlock((ParticleOptions)ParticleTypes.POOF, serverWorld, posTop.below(), 10);
                this.updateConnectedFlags(world, pos, false);
            }
            if (world.getBlockEntity(posTop) != null && (blockEntity = world.getBlockEntity(posTop)) instanceof GoalPoleBlockEntity) {
                GoalPoleBlockEntity goalPoleTopBE = (GoalPoleBlockEntity)blockEntity;
                goalPoleTopBE.markUpdated();
                if ((goalPoleTopBE.isAmericanFlag() || stateTop.getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get()) && stateTop.getValue(COLUMN) != ColumnBlockStates.MIDDLE) {
                    goalPoleTopBE.stopTriggeredAnim("disappear_controller", "disappear");
                    goalPoleTopBE.stopTriggeredAnim("appear_controller", "appear");
                    goalPoleTopBE.triggerAnim("appear_controller", "appear");
                    goalPoleTopBE.updateConnectedDisappearFlags(world, posTop, false);
                }
                world.scheduleTick(posTop, (Block)this, 20);
            }
            if (world.getBlockEntity(pos) != null && (blockEntity = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity) {
                GoalPoleBlockEntity goalPoleBE = (GoalPoleBlockEntity)blockEntity;
                goalPoleBE.markUpdated();
                if ((goalPoleBE.isAmericanFlag() || state.getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get()) && state.getValue(COLUMN) != ColumnBlockStates.MIDDLE) {
                    goalPoleBE.stopTriggeredAnim("disappear_controller", "disappear");
                    goalPoleBE.triggerAnim("appear_controller", "appear");
                    goalPoleBE.updateConnectedDisappearFlags(world, pos, false);
                } else if (!goalPoleBE.isAmericanFlag() && state.getBlock() != BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                    goalPoleBE.triggerAnim("switch_controller", "switch");
                }
            }
            world.scheduleTick(pos, (Block)this, 20);
            world.setBlock(pos, (BlockState)state.setValue((Property)LOWERED, (Comparable)Boolean.valueOf(false)), 3);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hitResult);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.getType().is(TagRegistry.CAN_LOWER_FLAGS)) {
            int flagPoleHeight = this.calculateFlagPoleHeight(world, pos);
            BlockPos posTop = this.findTopOfGoalPole(world, pos);
            BlockPos posBottom = this.findBottomOfGoalPole(world, pos);
            double relativeHeight = (entity.getY() + (double)entity.getEyeHeight() - (double)posBottom.getY()) / (double)flagPoleHeight;
            relativeHeight = Mth.clamp((double)relativeHeight, (double)0.0, (double)1.0);
            if (!((Boolean)state.getValue((Property)LOWERED)).booleanValue()) {
                BlockEntity blockEntity;
                world.addParticle(this.getParticleForHeight(relativeHeight), entity.getX(), entity.getY() + (double)entity.getBbHeight() + 1.0, entity.getZ(), 0.0, 0.0, 0.0);
                if (!world.isClientSide()) {
                    this.updateConnectedFlags(world, pos, true);
                }
                if (world.getBlockEntity(posTop) != null && (blockEntity = world.getBlockEntity(posTop)) instanceof GoalPoleBlockEntity) {
                    GoalPoleBlockEntity goalPoleTopBE = (GoalPoleBlockEntity)blockEntity;
                    goalPoleTopBE.markUpdated();
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        ServerParticleUtils.spawnParticleRingOnBlock((ParticleOptions)ParticleTypes.POOF, serverWorld, posTop.below(), 10);
                    }
                    if (goalPoleTopBE.isAmericanFlag() || state.getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                        goalPoleTopBE.triggerAnim("disappear_controller", "disappear");
                        goalPoleTopBE.updateConnectedDisappearFlags(world, posTop, false);
                    } else {
                        goalPoleTopBE.triggerAnim("switch_controller", "switch");
                    }
                }
                if (world.getBlockEntity(pos) != null && (blockEntity = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity) {
                    GoalPoleBlockEntity goalPoleBE = (GoalPoleBlockEntity)blockEntity;
                    goalPoleBE.markUpdated();
                    if (goalPoleBE.isAmericanFlag() || state.getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                        goalPoleBE.triggerAnim("disappear_controller", "disappear");
                        goalPoleBE.updateConnectedDisappearFlags(world, pos, false);
                    } else {
                        goalPoleBE.triggerAnim("switch_controller", "switch");
                    }
                }
                world.scheduleTick(pos, (Block)this, 20);
                world.setBlock(pos, (BlockState)state.setValue((Property)LOWERED, (Comparable)Boolean.valueOf(true)), 3);
                world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.GOAL_POLE_FINISH.get(), SoundSource.BLOCKS);
            }
            if (!entity.onGround() && !(entity.getDeltaMovement().y > 0.0)) {
                entity.setDeltaMovement(entity.getDeltaMovement().x, Math.max(entity.getDeltaMovement().y * 0.8, -0.1), entity.getDeltaMovement().z);
            }
            entity.resetFallDistance();
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)LOWERED)).booleanValue()) {
            return this.calculateFlagPoleLoweredHeight(world, pos);
        }
        return super.getAnalogOutputSignal(state, world, pos);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag options) {
        super.appendHoverText(stack, tooltipContext, list, options);
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
    }

    private BlockPos findTopOfGoalPole(Level world, BlockPos pos) {
        while (world.getBlockState(pos.above()).getBlock() instanceof GoalPoleBlock) {
            pos = pos.above();
        }
        return pos;
    }

    private BlockPos findBottomOfGoalPole(Level world, BlockPos pos) {
        while (world.getBlockState(pos.below()).getBlock() instanceof GoalPoleBlock) {
            pos = pos.below();
        }
        return pos;
    }

    private int calculateFlagPoleHeight(Level world, BlockPos pos) {
        int height = 0;
        BlockPos checkPos = pos;
        while (world.getBlockState(checkPos).getBlock() instanceof GoalPoleBlock) {
            ++height;
            checkPos = checkPos.above();
        }
        checkPos = pos.below();
        while (world.getBlockState(checkPos).getBlock() instanceof GoalPoleBlock) {
            ++height;
            checkPos = checkPos.below();
        }
        return height;
    }

    private int calculateFlagPoleLoweredHeight(Level world, BlockPos pos) {
        int height = 0;
        BlockPos checkPos = pos;
        while (world.getBlockState(checkPos).getBlock() instanceof GoalPoleBlock && ((Boolean)world.getBlockState(checkPos).getValue((Property)LOWERED)).booleanValue() && height <= 15) {
            ++height;
            checkPos = checkPos.above();
        }
        return height;
    }

    private ParticleOptions getParticleForHeight(double relativeHeight) {
        if (relativeHeight >= 1.0) {
            return (ParticleOptions)ParticleRegistry.WONDERFUL.get();
        }
        if (relativeHeight >= 0.875) {
            return (ParticleOptions)ParticleRegistry.INCREDIBLE.get();
        }
        if (relativeHeight >= 0.75) {
            return (ParticleOptions)ParticleRegistry.EXCELLENT.get();
        }
        if (relativeHeight >= 0.625) {
            return (ParticleOptions)ParticleRegistry.FANTASTIC.get();
        }
        if (relativeHeight >= 0.375) {
            return (ParticleOptions)ParticleRegistry.SUPER.get();
        }
        if (relativeHeight >= 0.25) {
            return (ParticleOptions)ParticleRegistry.GREAT.get();
        }
        return (ParticleOptions)ParticleRegistry.GOOD.get();
    }

    private void updateConnectedFlags(Level world, BlockPos pos, boolean isFlagLowered) {
        BlockPos posAbove = pos.above();
        while (world.getBlockState(posAbove).getBlock() instanceof GoalPoleBlock) {
            GoalPoleBlockEntity blockEntity;
            BlockEntity goalPoleAboveBE;
            BlockEntity blockEntity2;
            GoalPoleBlockEntity goalPoleBE;
            BlockEntity blockEntity3;
            BlockState stateAbove = world.getBlockState(posAbove);
            BlockState stateAbove2 = world.getBlockState(posAbove.above());
            world.setBlock(pos, (BlockState)stateAbove.setValue((Property)LOWERED, (Comparable)Boolean.valueOf(isFlagLowered)), 3);
            world.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)LOWERED, (Comparable)Boolean.valueOf(isFlagLowered)), 3);
            if (world.getBlockEntity(pos) != null && (blockEntity3 = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity) {
                goalPoleBE = (GoalPoleBlockEntity)blockEntity3;
                goalPoleBE.markUpdated();
            }
            if (!isFlagLowered) {
                if (world.getBlockEntity(pos) != null && (blockEntity3 = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity) {
                    goalPoleBE = (GoalPoleBlockEntity)blockEntity3;
                    if (world.getBlockState(pos).getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get() || goalPoleBE.isAmericanFlag()) {
                        if (stateAbove.getValue(COLUMN) == ColumnBlockStates.TOP) {
                            world.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)FLAG, (Comparable)Boolean.valueOf(true)), 3);
                        }
                        if ((goalPoleBE.isAmericanFlag() || stateAbove.getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get()) && stateAbove.getValue(COLUMN) != ColumnBlockStates.MIDDLE && (blockEntity2 = world.getBlockEntity(posAbove)) instanceof GoalPoleBlockEntity) {
                            goalPoleAboveBE = (GoalPoleBlockEntity)blockEntity2;
                            goalPoleAboveBE.stopTriggeredAnim("disappear_controller", "disappear");
                            goalPoleAboveBE.triggerAnim("appear_controller", "appear");
                            goalPoleAboveBE.updateConnectedDisappearFlags(world, posAbove, false);
                        }
                        world.scheduleTick(posAbove, (Block)this, 20);
                    }
                }
                if (world.getBlockEntity(posAbove.above()) != null && (goalPoleAboveBE = world.getBlockEntity(posAbove.above())) instanceof GoalPoleBlockEntity) {
                    GoalPoleBlockEntity goalPoleTopBE = (GoalPoleBlockEntity)goalPoleAboveBE;
                    goalPoleTopBE.markUpdated();
                    if (!goalPoleTopBE.isAmericanFlag() && stateAbove2.getBlock() != BlockRegistry.CLASSIC_GOAL_POLE.get()) {
                        goalPoleTopBE.triggerAnim("switch_controller", "switch");
                    }
                    world.scheduleTick(posAbove.above(), (Block)this, 15);
                }
            }
            if (isFlagLowered && (world.getBlockState(pos).getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get() || world.getBlockEntity(pos) != null && (goalPoleAboveBE = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity && (blockEntity = (GoalPoleBlockEntity)goalPoleAboveBE).isAmericanFlag())) {
                GoalPoleBlockEntity goalPoleBE2;
                if (world.getBlockState(pos).getValue(COLUMN) == ColumnBlockStates.BOTTOM && world.getBlockState(pos.above()).getValue(COLUMN) == ColumnBlockStates.MIDDLE && world.getBlockState(pos.above(2)).getValue(COLUMN) == ColumnBlockStates.MIDDLE && (blockEntity2 = world.getBlockEntity(pos.above())) instanceof GoalPoleBlockEntity) {
                    goalPoleBE2 = (GoalPoleBlockEntity)blockEntity2;
                    goalPoleBE2.stopTriggeredAnim("disappear_controller", "disappear");
                    goalPoleBE2.triggerAnim("appear_controller", "appear");
                    world.setBlock(pos.above(), (BlockState)world.getBlockState(pos.above()).setValue((Property)FLAG, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (world.getBlockState(pos).getValue(COLUMN) == ColumnBlockStates.MIDDLE && world.getBlockState(pos.above()).getValue(COLUMN) == ColumnBlockStates.MIDDLE && (blockEntity2 = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity) {
                    goalPoleBE2 = (GoalPoleBlockEntity)blockEntity2;
                    goalPoleBE2.stopTriggeredAnim("disappear_controller", "disappear");
                    goalPoleBE2.triggerAnim("appear_controller", "appear");
                    world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)FLAG, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            posAbove = posAbove.above();
        }
        BlockPos posBelow = pos.below();
        while (world.getBlockState(posBelow).getBlock() instanceof GoalPoleBlock) {
            GoalPoleBlockEntity blockEntity;
            BlockEntity blockEntity4;
            world.setBlock(posBelow, (BlockState)world.getBlockState(posBelow).setValue((Property)LOWERED, (Comparable)Boolean.valueOf(isFlagLowered)), 3);
            if (world.getBlockEntity(pos) != null && (blockEntity4 = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity) {
                blockEntity = (GoalPoleBlockEntity)blockEntity4;
                blockEntity.markUpdated();
            }
            if (isFlagLowered && (world.getBlockState(pos).getBlock() == BlockRegistry.CLASSIC_GOAL_POLE.get() || world.getBlockEntity(pos) != null && (blockEntity4 = world.getBlockEntity(pos)) instanceof GoalPoleBlockEntity && (blockEntity = (GoalPoleBlockEntity)blockEntity4).isAmericanFlag()) && (world.getBlockState(pos).getValue(COLUMN) == ColumnBlockStates.BOTTOM || world.getBlockState(posBelow).getValue(COLUMN) == ColumnBlockStates.BOTTOM) && world.getBlockState(posBelow.above()).getValue(COLUMN) == ColumnBlockStates.MIDDLE && world.getBlockState(posBelow.above(2)).getValue(COLUMN) == ColumnBlockStates.MIDDLE) {
                world.setBlock(posBelow.above(), (BlockState)world.getBlockState(posBelow.above()).setValue((Property)FLAG, (Comparable)Boolean.valueOf(true)), 3);
            }
            posBelow = posBelow.below();
        }
    }
}

