/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.mojang.serialization.MapCodec;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.entities.QuestionBlockEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class InvisibleQuestionBlock
extends QuestionBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<InvisibleQuestionBlock> CODEC = InvisibleQuestionBlock.simpleCodec(InvisibleQuestionBlock::new);
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public InvisibleQuestionBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EMPTY, (Comparable)Boolean.TRUE)).setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @NotNull
    protected MapCodec<? extends InvisibleQuestionBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{EMPTY, INVISIBLE, WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        BlockItem blockItem;
        Item item;
        Player player;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)context).getEntity()) instanceof Player && ((player = (Player)entity).hasPermissions(1) && player.isCreative() || (Boolean)state.getValue((Property)INVISIBLE) == false || !player.isCreative() && !player.isSpectator() && (Boolean)ConfigRegistry.SELECT_INVISIBLE_QUESTION.get() != false || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof BucketItem || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof DebugStickItem || (item = player.getItemInHand(player.getUsedItemHand()).getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof InvisibleQuestionBlock)) {
            return Shapes.block();
        }
        return Shapes.box((double)8.0, (double)8.0, (double)8.0, (double)8.00001, (double)8.00001, (double)8.00001);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext entityCollisionContext;
        if (!((Boolean)state.getValue((Property)INVISIBLE)).booleanValue()) {
            return Shapes.block();
        }
        if (((Boolean)state.getValue((Property)INVISIBLE)).booleanValue() && collisionContext instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)collisionContext).getEntity() != null && entityCollisionContext.getEntity().getType().is(TagRegistry.CAN_HIT_QUESTION_BLOCKS) && entityCollisionContext.getEntity().getY() + (double)entityCollisionContext.getEntity().getBbHeight() < (double)pos.getY()) {
            return Shapes.block();
        }
        return Shapes.empty();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EMPTY, (Comparable)Boolean.TRUE)).setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean notify) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBE = (QuestionBlockEntity)blockEntity;
            if (((Boolean)ConfigRegistry.REDSTONE_OPENS_QUESTION.get()).booleanValue()) {
                boolean isPowered = world.hasNeighborSignal(pos);
                if (isPowered && !((Boolean)state.getValue((Property)EMPTY)).booleanValue() && !questionBE.isLastPowered()) {
                    ItemStack storedItem = questionBE.getTheItem();
                    if (!storedItem.isEmpty()) {
                        if (!world.isClientSide) {
                            this.spawnFromQuestionBlock(world, pos, storedItem, null, Boolean.FALSE, Boolean.TRUE);
                        }
                        if (state.hasProperty((Property)INVISIBLE)) {
                            world.setBlock(pos, (BlockState)state.setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE), 3);
                        }
                        QuestionBlock.playSounds(world, pos, storedItem);
                        questionBE.splitTheItem(1);
                        questionBE.setChanged();
                    }
                    if (storedItem.isEmpty()) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)QuestionBlock.EMPTY, (Comparable)Boolean.TRUE), 3);
                    }
                    if (questionBE.getLootTable() != null) {
                        world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)QuestionBlock.EMPTY, (Comparable)Boolean.FALSE)).setValue((Property)INVISIBLE, (Comparable)Boolean.TRUE), 3);
                    }
                }
                questionBE.setLastPowered(isPowered);
            }
        }
    }

    @Override
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBE = (QuestionBlockEntity)blockEntity;
            if (!heldItem.is(TagRegistry.CANNOT_PLACE_IN_QUESTION_BLOCKS)) {
                ItemStack blockStack = questionBE.getTheItem();
                if (world.isClientSide) {
                    return ItemInteractionResult.CONSUME;
                }
                if (!heldItem.isEmpty() && (((Boolean)ConfigRegistry.QUESTION_ADD_ITEMS.get()).booleanValue() || player.isCreative()) && (blockStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)blockStack) && blockStack.getCount() < blockStack.getMaxStackSize())) {
                    float f;
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    ItemStack itemstack = stack.consumeAndReturn(1, (LivingEntity)player);
                    if (questionBE.isEmpty()) {
                        questionBE.setTheItem(itemstack);
                        f = (float)itemstack.getCount() / (float)itemstack.getMaxStackSize();
                    } else {
                        blockStack.grow(1);
                        f = (float)blockStack.getCount() / (float)blockStack.getMaxStackSize();
                    }
                    world.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * f);
                    world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)QuestionBlock.EMPTY, (Comparable)Boolean.FALSE)).setValue((Property)INVISIBLE, (Comparable)Boolean.TRUE), 3);
                    questionBE.setChanged();
                    world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(player.getUsedItemHand());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof QuestionBlockEntity) {
            QuestionBlockEntity questionBE = (QuestionBlockEntity)blockEntity;
            ItemStack blockStack = questionBE.getTheItem();
            if (!(!heldItem.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)blockStack) || !((Boolean)ConfigRegistry.QUESTION_REMOVE_ITEMS.get()).booleanValue() && !player.isCreative() || ((Boolean)state.getValue((Property)EMPTY)).booleanValue())) {
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                ItemStack storedItem = questionBE.getTheItem();
                if (!storedItem.isEmpty()) {
                    if (!world.isClientSide) {
                        this.spawnFromQuestionBlock(world, pos, storedItem, null, Boolean.FALSE, Boolean.TRUE);
                    }
                    if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
                        PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
                    }
                    if (state.hasProperty((Property)INVISIBLE)) {
                        world.setBlock(pos, (BlockState)state.setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE), 3);
                    }
                    QuestionBlock.playSounds(world, pos, storedItem);
                    questionBE.splitTheItem(1);
                    questionBE.setChanged();
                }
                if (storedItem.isEmpty()) {
                    world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)QuestionBlock.EMPTY, (Comparable)Boolean.TRUE)).setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE), 3);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        Player nearestPlayer = world.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 16.0, false);
        if (nearestPlayer != null && ((Boolean)state.getValue((Property)INVISIBLE)).booleanValue() && (nearestPlayer.isCreative() && nearestPlayer.hasPermissions(1) || nearestPlayer.isSpectator() && nearestPlayer.hasPermissions(1))) {
            world.addParticle((ParticleOptions)new ItemParticleOption((ParticleType)ParticleRegistry.NO_MOVEMENT_ITEM.get(), this.asItem().getDefaultInstance()), x + 0.5, y + 0.5, z + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return state.getFluidState().isEmpty() && (Boolean)state.getValue((Property)INVISIBLE) != false;
    }

    protected boolean skipRendering(BlockState state, BlockState neighborState, Direction direction) {
        return neighborState.getBlock() instanceof InvisibleQuestionBlock && (Boolean)state.getValue((Property)INVISIBLE) != false && (Boolean)neighborState.getValue((Property)INVISIBLE) != false || super.skipRendering(state, neighborState, direction);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        if (((Boolean)state.getValue((Property)INVISIBLE)).booleanValue()) {
            return 1.0f;
        }
        return state.isCollisionShapeFullBlock(blockGetter, pos) ? 0.2f : 1.0f;
    }
}

