/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.GoombaEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class GoombaSitGoal
extends Goal {
    private final GoombaEntity goomba;
    private final float chanceToSit;
    private final int ticksBeforeSittingAgain;
    private final int ticksBeforeSleeping;
    private int ticksSitting;
    private int cooldown;
    private int sittingTime;

    public GoombaSitGoal(GoombaEntity goomba, float chanceToSit, int ticksSitting, int ticksBeforeSittingAgain, int ticksBeforeSleeping) {
        this.goomba = goomba;
        this.chanceToSit = chanceToSit;
        this.ticksSitting = ticksSitting;
        this.ticksBeforeSittingAgain = ticksBeforeSittingAgain;
        this.ticksBeforeSleeping = ticksBeforeSleeping;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.cooldown > 0 && !this.goomba.isSitting()) {
            --this.cooldown;
        }
        if (this.cooldown == 0 && !this.goomba.isInWater() && !this.goomba.isSitting()) {
            if ((float)this.goomba.getRandom().nextInt() < this.chanceToSit) {
                this.cooldown = this.ticksBeforeSittingAgain;
                return true;
            }
            this.cooldown = this.ticksBeforeSittingAgain / 2;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.goomba.isSitting() && this.sittingTime < this.ticksSitting;
    }

    public void start() {
        this.goomba.tryToSit();
        this.sittingTime = 0;
    }

    public void stop() {
        this.cooldown = this.ticksBeforeSittingAgain;
        this.goomba.sit(false);
    }

    public void tick() {
        if (this.cooldown > 0) {
            this.goomba.getNavigation().stop();
            this.goomba.setXxa(0.0f);
            this.goomba.setSpeed(0.0f);
        }
        if (this.sittingTime >= this.ticksSitting) {
            this.stop();
        } else {
            ++this.sittingTime;
            if (this.sittingTime >= this.ticksBeforeSleeping && !this.goomba.isSleeping()) {
                this.goomba.tryToSleep();
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

