/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import com.wenxin2.marioverse.entities.power_ups.AbstractPowerUpEntity;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceFlowerEntity
extends AbstractPowerUpEntity
implements GeoEntity {
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.ice_flower.idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public IceFlowerEntity(EntityType<? extends IceFlowerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle", 0, this::idleAnimController));
    }

    protected <E extends GeoAnimatable> PlayState idleAnimController(AnimationState<E> event) {
        event.setAndContinue(IDLE_ANIM);
        return PlayState.CONTINUE;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void collideWithEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                handler.applyIceFlowerPowerUp(this.level(), livingEntity, this);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public TagKey<Item> getPowerUpCostumeTag() {
        return TagRegistry.ICE_COSTUMES;
    }

    @Override
    public List<ItemStack> getHatItems() {
        return List.of(ItemRegistry.MARIO_HAT.toStack(), ItemRegistry.LUIGI_HAT.toStack(), ItemRegistry.PEACH_CROWN.toStack(), ItemRegistry.MARIO_ICE_HAT.toStack(), ItemRegistry.LUIGI_ICE_HAT.toStack());
    }

    @Override
    public List<ItemStack> getShirtItems() {
        return List.of(ItemRegistry.MARIO_SHIRT.toStack(), ItemRegistry.LUIGI_SHIRT.toStack(), ItemRegistry.PEACH_BODICE.toStack(), ItemRegistry.MARIO_ICE_SHIRT.toStack(), ItemRegistry.LUIGI_ICE_SHIRT.toStack(), ItemRegistry.PEACH_ICE_BODICE.toStack());
    }

    @Override
    public List<ItemStack> getPantsItems() {
        return List.of(ItemRegistry.MARIO_PANTS.toStack(), ItemRegistry.LUIGI_PANTS.toStack(), ItemRegistry.PEACH_DRESS.toStack(), ItemRegistry.MARIO_ICE_PANTS.toStack(), ItemRegistry.LUIGI_ICE_PANTS.toStack(), ItemRegistry.PEACH_ICE_DRESS.toStack());
    }

    @Override
    public List<ItemStack> getShoesItems() {
        return List.of(ItemRegistry.MARIO_SHOES.toStack(), ItemRegistry.LUIGI_SHOES.toStack(), ItemRegistry.PEACH_SHOES.toStack(), ItemRegistry.MARIO_ICE_SHOES.toStack(), ItemRegistry.LUIGI_ICE_SHOES.toStack(), ItemRegistry.PEACH_ICE_SHOES.toStack());
    }
}

