/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredItem;
import software.bernie.geckolib.animatable.GeoEntity;

public class OneUpMushroomEntity
extends MushroomEntity
implements GeoEntity {
    private long lastCollisionTime = 0L;

    public OneUpMushroomEntity(EntityType<? extends OneUpMushroomEntity> entityType, Level world) {
        super((EntityType<? extends MushroomEntity>)entityType, world);
    }

    @Override
    public void tick() {
        super.tick();
        this.checkForCollisions();
    }

    @Override
    public void collideWithEntity(Entity entity) {
        if (!this.level().isClientSide) {
            DeferredItem<Item> item = ItemRegistry.ONE_UP_MUSHROOM;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastCollisionTime < 500L) {
                return;
            }
            this.lastCollisionTime = currentTime;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof AbilitiesHandler) {
                    AbilitiesHandler handler = (AbilitiesHandler)entity;
                    handler.applyOneUpMushroomPowerUp(this.level(), new ItemStack(item), livingEntity);
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }
}

