/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.projectiles;

import com.wenxin2.marioverse.entities.IceCubeEntity;
import com.wenxin2.marioverse.entities.MiniGoombaEntity;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.entities.part_entities.PiranhaPlantPart;
import com.wenxin2.marioverse.entities.power_ups.BaseMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.BasePowerUpEntity;
import com.wenxin2.marioverse.entities.projectiles.BouncingFireballProjectile;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BouncingIceBallProjectile
extends ThrowableProjectile
implements GeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.bouncing_ice_ball.idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int bounceCount;

    public BouncingIceBallProjectile(EntityType<? extends BouncingIceBallProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 0, state -> state.setAndContinue(IDLE)));
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("BounceCount", this.getBounceCount());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBounceCount(tag.getInt("BounceCount"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        Vec3 motion = this.getDeltaMovement();
        this.collideWithEntity();
        this.onHitFluid(world, this.blockPosition());
        if (!this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(motion.x, -0.04, motion.y));
        }
        if (motion.length() > 0.0) {
            this.setYRot((float)Math.toDegrees(Math.atan2(motion.z, motion.x)) + 270.0f);
            this.setXRot((float)Math.toDegrees(Math.atan2(-motion.y, Math.sqrt(motion.x * motion.x + motion.z * motion.z))));
        }
        if (this.onGround() || this.tickCount > 400) {
            this.discardEffects(world);
        }
        for (int i = 0; i < 1; ++i) {
            double x = this.getX();
            double y = this.getY() + (double)(this.getBbHeight() / 2.0f);
            double z = this.getZ();
            world.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, y, z, 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleRegistry.ICE_STAR.get(), x, y, z, 0.2, 0.0, 0.2);
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private int getBounceCount() {
        return this.bounceCount;
    }

    private void setBounceCount(int bounceCount) {
        this.bounceCount = bounceCount;
    }

    public void bounceEffects(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerParticleUtils.spawnParticleRingBelowEntity((ParticleOptions)ParticleTypes.SNOWFLAKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
        }
        world.playSound(null, pos, (SoundEvent)SoundRegistry.ICE_BALL_BOUNCED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        world.gameEvent(this.getOwner(), (Holder)GameEvent.PROJECTILE_LAND, pos);
    }

    public void discardEffects(Level world) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SNOWFLAKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
        }
        world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_SHATTERED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        world.gameEvent(this.getOwner(), (Holder)GameEvent.PROJECTILE_LAND, this.position());
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void discardEffectsOnSideHit(Level world, BlockPos hitPos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SNOWFLAKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
        }
        world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_SHATTERED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        world.gameEvent(this.getOwner(), (Holder)GameEvent.PROJECTILE_LAND, hitPos);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected void onHitFluid(Level world, BlockPos pos) {
        FluidState fluidState = world.getFluidState(pos);
        FluidState fluidStateBelow = world.getFluidState(pos.below());
        BlockState state = world.getBlockState(pos);
        if (fluidStateBelow.getType().is(TagRegistry.FREEZES_INTO_FROSTED_ICE)) {
            if (fluidStateBelow.getType() == Fluids.WATER && fluidState.getType() != Fluids.WATER && state.canBeReplaced()) {
                world.setBlock(pos.below(), Blocks.FROSTED_ICE.defaultBlockState(), 3);
            }
        } else if (fluidStateBelow.getType().is(TagRegistry.FREEZES_INTO_OBSIDIAN)) {
            world.setBlock(pos.below(), Blocks.OBSIDIAN.defaultBlockState(), 3);
            this.discardEffects(world);
        } else if (fluidStateBelow.getType().is(TagRegistry.FREEZES_INTO_COBBLESTONE)) {
            world.setBlock(pos.below(), Blocks.COBBLESTONE.defaultBlockState(), 3);
            this.discardEffects(world);
        }
    }

    public void onHitBlock(BlockHitResult hit) {
        Level world = this.level();
        BlockPos hitPos = hit.getBlockPos();
        BlockState state = world.getBlockState(hitPos);
        if (hit.getDirection().getAxis() == Direction.Axis.X || hit.getDirection().getAxis() == Direction.Axis.Z) {
            this.discardEffectsOnSideHit(world, hitPos);
        } else if (this.getBounceCount() < (Integer)ConfigRegistry.MAX_ICE_BALL_BOUNCES.get()) {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x, 0.5, motion.z);
            this.bounceEffects(world, hitPos);
            this.setBounceCount(this.getBounceCount() + 1);
        } else {
            this.discardEffectsOnSideHit(world, hitPos);
        }
        if (state.getBlock() == Blocks.FROSTED_ICE) {
            world.setBlock(hitPos, Blocks.FROSTED_ICE.defaultBlockState(), 3);
        } else if (state.is(TagRegistry.FREEZES_INTO_PACKED_ICE)) {
            world.setBlock(hitPos, Blocks.PACKED_ICE.defaultBlockState(), 3);
        } else if (state.is(TagRegistry.MELTS_INTO_PACKED_ICE)) {
            world.setBlock(hitPos, Blocks.PACKED_ICE.defaultBlockState(), 3);
        } else if (state.getBlock() instanceof CampfireBlock && state.hasProperty((Property)BlockStateProperties.LIT)) {
            world.levelEvent(null, 1009, hitPos, 0);
            world.setBlock(hitPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.FALSE), 3);
            world.playSound(null, hitPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.discardEffects(world);
        } else if (state.getBlock() instanceof CandleBlock && state.hasProperty((Property)BlockStateProperties.LIT)) {
            world.levelEvent(null, 1009, hitPos, 0);
            world.setBlock(hitPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.FALSE), 3);
            world.playSound(null, hitPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.discardEffects(world);
        } else if (state.getBlock() instanceof CandleCakeBlock && state.hasProperty((Property)BlockStateProperties.LIT)) {
            world.levelEvent(null, 1009, hitPos, 0);
            world.setBlock(hitPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.FALSE), 3);
            world.playSound(null, hitPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.discardEffects(world);
        } else if (state.is(CompatRegistry.CANDLE_HOLDERS_BLOCK_TAG) && state.hasProperty((Property)BlockStateProperties.LIT)) {
            world.levelEvent(null, 1009, hitPos, 0);
            world.setBlock(hitPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.FALSE), 3);
            world.playSound(null, hitPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.discardEffects(world);
        }
        super.onHitBlock(hit);
    }

    /*
     * Unable to fully structure code
     */
    protected void onHitEntity(EntityHitResult hit) {
        world = this.level();
        entity = hit.getEntity();
        if (!(entity instanceof Player) || !((player = (Player)entity) instanceof AbilitiesHandler)) ** GOTO lbl-1000
        handler = (AbilitiesHandler)player;
        if (!player.isSpectator() && player != this.getOwner() && !player.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
            shield = player.getUseItem();
            width = player.getBbWidth() * 2.55f;
            height = player.getBbHeight() * 1.55f;
            if (this.getOwner() != null && player.getTeam() != null && this.getOwner().getTeam() != null && player.getTeam() == this.getOwner().getTeam()) {
                return;
            }
            if (this.getOwner() != null && player.isDamageSourceBlocked(DamageTypeRegistry.iceBall(entity, this.getOwner()))) {
                if (shield.getItem() instanceof ShieldItem || handler.mv$hasIceFlower()) {
                    this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
                    this.setDeltaMovement(this.getDeltaMovement().reverse());
                    shield.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    world.playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                if (this.getOwner() != null) {
                    if (player.getType().is(TagRegistry.ICE_BALL_CAN_INSTAKILL)) {
                        player.hurt(DamageTypeRegistry.iceBall(entity, this.getOwner()), player.getHealth() * 1.25f);
                    } else {
                        player.hurt(DamageTypeRegistry.iceBall(entity, this.getOwner()), ((Double)ConfigRegistry.ICE_BALL_DAMAGE.get()).floatValue());
                    }
                }
                player.extinguishFire();
                if (player.isAlive() && handler.mv$getFrozenCooldown() == 0 && handler.mv$getFreezeImmunityCooldown() == 0) {
                    iceCube = new IceCubeEntity((EntityType<? extends IceCubeEntity>)((EntityType)EntityRegistry.ICE_CUBE.get()), player.level());
                    iceCube.moveTo(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
                    if (player.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES) || player.getType().is(TagRegistry.ICE_CUBE_SHATTERS_INSTANTLY)) {
                        iceCube.setFrozenCooldown(2);
                        handler.mv$setFrozenCooldown(2);
                    } else {
                        iceCube.setFrozenCooldown((Integer)ConfigRegistry.ICE_CUBE_LIFESPAN.get());
                        handler.mv$setFrozenCooldown((Integer)ConfigRegistry.ICE_CUBE_LIFESPAN.get());
                    }
                    if (!player.onGround() && !player.isInWaterOrBubble()) {
                        iceCube.setTicksInAir(120);
                    }
                    iceCube.setSize(width, height);
                    iceCube.setOwner(this.getOwner());
                    player.level().addFreshEntity((Entity)iceCube);
                    player.startRiding((Entity)iceCube, false);
                }
            }
            world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_FROZE_ENEMY.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, entity.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != this.getOwner() && !livingEntity.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
            shield = livingEntity.getUseItem();
            if (livingEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)livingEntity).getOwner() == this.getOwner() || this.getOwner() != null && livingEntity.getTeam() != null && this.getOwner().getTeam() != null && livingEntity.getTeam() == this.getOwner().getTeam()) {
                return;
            }
            if (this.getOwner() != null && livingEntity.isDamageSourceBlocked(DamageTypeRegistry.iceBall(entity, this.getOwner()))) {
                if (shield.getItem() instanceof ShieldItem || entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$hasIceFlower()) {
                    this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
                    this.setDeltaMovement(this.getDeltaMovement().reverse());
                    shield.hurtAndBreak(1, livingEntity, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
                    world.playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getOwner() != null) {
                if (livingEntity.getType().is(TagRegistry.ICE_BALL_CAN_INSTAKILL)) {
                    livingEntity.hurt(DamageTypeRegistry.iceBall(entity, this.getOwner()), livingEntity.getHealth() * 1.25f);
                } else {
                    livingEntity.hurt(DamageTypeRegistry.iceBall(entity, this.getOwner()), ((Double)ConfigRegistry.ICE_BALL_DAMAGE.get()).floatValue());
                }
                livingEntity.extinguishFire();
                if (livingEntity.isAlive() || livingEntity instanceof MiniGoombaEntity || livingEntity instanceof BasePowerUpEntity || livingEntity instanceof BaseMushroomEntity) {
                    iceCube = new IceCubeEntity((EntityType<? extends IceCubeEntity>)((EntityType)EntityRegistry.ICE_CUBE.get()), livingEntity.level());
                    if (livingEntity.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES) || livingEntity.getType().is(TagRegistry.ICE_CUBE_SHATTERS_INSTANTLY)) {
                        iceCube.setFrozenEntity((Entity)livingEntity, 2);
                    } else {
                        iceCube.setFrozenEntity((Entity)livingEntity, (Integer)ConfigRegistry.ICE_CUBE_LIFESPAN.get());
                    }
                    if (!livingEntity.onGround() && !livingEntity.isInWaterOrBubble()) {
                        iceCube.setTicksInAir(120);
                    }
                    iceCube.moveTo(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), livingEntity.getYRot(), livingEntity.getXRot());
                    iceCube.setOwner(this.getOwner());
                    livingEntity.level().addFreshEntity((Entity)iceCube);
                }
            }
            world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_FROZE_ENEMY.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, entity.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (entity instanceof PiranhaPlantPart && (partEntity = (PiranhaPlantPart)entity) != this.getOwner() && !partEntity.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
            shield = ((PiranhaPlantEntity)partEntity.getParent()).getUseItem();
            if (this.getOwner() != null && ((PiranhaPlantEntity)partEntity.getParent()).isDamageSourceBlocked(DamageTypeRegistry.iceBall(entity, this.getOwner()))) {
                if (shield.getItem() instanceof ShieldItem || entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$hasIceFlower()) {
                    this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
                    this.setDeltaMovement(this.getDeltaMovement().reverse());
                    shield.hurtAndBreak(1, (LivingEntity)partEntity.getParent(), LivingEntity.getSlotForHand((InteractionHand)((PiranhaPlantEntity)partEntity.getParent()).getUsedItemHand()));
                    world.playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getOwner() != null) {
                if (partEntity.getType().is(TagRegistry.ICE_BALL_CAN_INSTAKILL)) {
                    partEntity.hurt(DamageTypeRegistry.iceBall(entity, this.getOwner()), ((PiranhaPlantEntity)partEntity.getParent()).getHealth() * 1.25f);
                } else {
                    partEntity.hurt(DamageTypeRegistry.iceBall(entity, this.getOwner()), ((Double)ConfigRegistry.ICE_BALL_DAMAGE.get()).floatValue());
                }
                partEntity.extinguishFire();
                if (partEntity.isAlive()) {
                    iceCube = new IceCubeEntity((EntityType<? extends IceCubeEntity>)((EntityType)EntityRegistry.ICE_CUBE.get()), partEntity.level());
                    if (partEntity.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES) || partEntity.getType().is(TagRegistry.ICE_CUBE_SHATTERS_INSTANTLY)) {
                        iceCube.setFrozenEntity((Entity)partEntity, 2);
                    } else {
                        iceCube.setFrozenEntity((Entity)partEntity, (Integer)ConfigRegistry.ICE_CUBE_LIFESPAN.get());
                    }
                    iceCube.moveTo(partEntity.getX(), partEntity.getY(), partEntity.getZ(), partEntity.getYRot(), partEntity.getXRot());
                    iceCube.setOwner(this.getOwner());
                    partEntity.level().addFreshEntity((Entity)iceCube);
                }
            }
            world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_FROZE_ENEMY.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, entity.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (entity instanceof BouncingFireballProjectile) {
            fireball = (BouncingFireballProjectile)entity;
            fireball.kill();
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, entity.position());
            world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_EXTINGUISHED_FIREBALL.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, entity.position());
            world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ICE_BALL_SHATTERED_ON_ENEMY.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (world instanceof ServerLevel) {
            serverWorld = (ServerLevel)world;
            if (entity instanceof Player && !(player = (Player)entity).isSpectator() && player.canFreeze() && player != this.getOwner() && !player.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
                ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SNOWFLAKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
            } else if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).canFreeze() && livingEntity != this.getOwner() && !livingEntity.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
                ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SNOWFLAKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
            }
        }
    }

    public boolean deflect(@NotNull ProjectileDeflection deflection, @Nullable Entity entity, @Nullable Entity owner, boolean shouldDeflect) {
        Level world = this.level();
        if (entity instanceof LivingEntity && !world.isClientSide) {
            deflection.deflect((Projectile)this, entity, this.random);
            this.setOwner(entity);
            this.onDeflection(entity, shouldDeflect);
            return true;
        }
        return false;
    }

    public void collideWithEntity() {
        AABB collisionBox = this.getBoundingBox().inflate(0.01, 0.0, 0.01);
        List collidingEntities = this.level().getEntities((Entity)this, collisionBox);
        for (Entity entity : collidingEntities) {
            if (!(entity instanceof Breeze)) continue;
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
            this.level().playSound(null, entity.blockPosition(), SoundEvents.BREEZE_DEFLECT, entity.getSoundSource(), 1.0f, 1.0f);
            return;
        }
    }
}

