/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.registries;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class DamageTypeRegistry {
    public static final ResourceKey<DamageType> BONKED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"bonked"));
    public static final ResourceKey<DamageType> PLAYER_BONKED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_bonked"));
    public static final ResourceKey<DamageType> FIREBALL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"fireball"));
    public static final ResourceKey<DamageType> PLAYER_FIREBALL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_fireball"));
    public static final ResourceKey<DamageType> ICE_BALL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"ice_ball"));
    public static final ResourceKey<DamageType> PLAYER_ICE_BALL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_ice_ball"));
    public static final ResourceKey<DamageType> ICE_CUBE_CRUSHED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"ice_cube_crushed"));
    public static final ResourceKey<DamageType> PLAYER_ICE_CUBE_CRUSHED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_ice_cube_crushed"));
    public static final ResourceKey<DamageType> MINI_GOOMBA_DEFEATED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"mini_goomba_defeated"));
    public static final ResourceKey<DamageType> PLAYER_MINI_GOOMBA_DEFEATED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_mini_goomba_defeated"));
    public static final ResourceKey<DamageType> PIRANHA_CHOMP = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"piranha_chomp"));
    public static final ResourceKey<DamageType> PLAYER_PIRANHA_CHOMP = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_piranha_chomp"));
    public static final ResourceKey<DamageType> SHRAPNEL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"shrapnel"));
    public static final ResourceKey<DamageType> PLAYER_SHRAPNEL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_shrapnel"));
    public static final ResourceKey<DamageType> SPINNING_SHELL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"spinning_shell"));
    public static final ResourceKey<DamageType> PLAYER_SPINNING_SHELL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_spinning_shell"));
    public static final ResourceKey<DamageType> STOMP = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"stomp"));
    public static final ResourceKey<DamageType> PLAYER_STOMP = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_stomp"));
    public static final ResourceKey<DamageType> SUPER_STAR = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"super_star"));
    public static final ResourceKey<DamageType> PLAYER_SUPER_STAR = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"player_super_star"));

    public static DamageSource bonked(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (damagedEntity != null && attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_BONKED), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(BONKED), null, attackingEntity);
        }
        return null;
    }

    public static DamageSource defeated(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (damagedEntity != null && attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_MINI_GOOMBA_DEFEATED), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(MINI_GOOMBA_DEFEATED), null, attackingEntity);
        }
        return null;
    }

    public static DamageSource fireball(@Nullable Entity projectile, @Nullable Entity shooter) {
        if (shooter != null && projectile != null) {
            return new DamageSource((Holder)shooter.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_FIREBALL), projectile, shooter);
        }
        if (shooter != null) {
            return new DamageSource((Holder)shooter.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(FIREBALL), null, shooter);
        }
        return null;
    }

    public static DamageSource iceBall(@Nullable Entity projectile, @Nullable Entity shooter) {
        if (shooter != null && projectile != null) {
            return new DamageSource((Holder)shooter.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_ICE_BALL), projectile, shooter);
        }
        if (shooter != null) {
            return new DamageSource((Holder)shooter.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ICE_BALL), null, shooter);
        }
        return null;
    }

    public static DamageSource iceCubeCrushed(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (attackingEntity != null && damagedEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_ICE_CUBE_CRUSHED), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ICE_CUBE_CRUSHED), null, attackingEntity);
        }
        return null;
    }

    public static DamageSource shrapnel(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (damagedEntity != null && attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_SHRAPNEL), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SHRAPNEL), null, attackingEntity);
        }
        return null;
    }

    public static DamageSource spinningShell(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (damagedEntity != null && attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_SPINNING_SHELL), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SPINNING_SHELL), null, attackingEntity);
        }
        return null;
    }

    public static DamageSource stomp(@Nullable Entity entity, @Nullable Entity stomper) {
        if (stomper != null && entity != null) {
            return new DamageSource((Holder)stomper.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_STOMP), entity, stomper);
        }
        if (stomper != null) {
            return new DamageSource((Holder)stomper.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(STOMP), null, stomper);
        }
        return null;
    }

    public static DamageSource superStar(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (attackingEntity != null && damagedEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_SUPER_STAR), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SUPER_STAR), null, attackingEntity);
        }
        return null;
    }

    public static DamageSource piranhaChomp(@Nullable Entity damagedEntity, @Nullable Entity attackingEntity) {
        if (attackingEntity != null && damagedEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PLAYER_PIRANHA_CHOMP), damagedEntity, attackingEntity);
        }
        if (attackingEntity != null) {
            return new DamageSource((Holder)attackingEntity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(PIRANHA_CHOMP), null, attackingEntity);
        }
        return null;
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(BONKED, (Object)new DamageType("marioverse.bonked", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.HURT));
        context.register(PLAYER_BONKED, (Object)new DamageType("marioverse.bonked.player", DamageScaling.ALWAYS, 0.1f, DamageEffects.HURT));
        context.register(MINI_GOOMBA_DEFEATED, (Object)new DamageType("marioverse.mini_goomba_defeated", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.HURT));
        context.register(PLAYER_MINI_GOOMBA_DEFEATED, (Object)new DamageType("marioverse.mini_goomba_defeated.player", DamageScaling.ALWAYS, 0.1f, DamageEffects.HURT));
        context.register(FIREBALL, (Object)new DamageType("marioverse.fireball", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.BURNING));
        context.register(PLAYER_FIREBALL, (Object)new DamageType("marioverse.fireball.player", DamageScaling.ALWAYS, 0.1f, DamageEffects.BURNING));
        context.register(ICE_BALL, (Object)new DamageType("marioverse.ice_ball", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.FREEZING));
        context.register(PLAYER_ICE_BALL, (Object)new DamageType("marioverse.ice_ball.player", DamageScaling.ALWAYS, 0.1f, DamageEffects.FREEZING));
        context.register(ICE_CUBE_CRUSHED, (Object)new DamageType("marioverse.ice_cube_crushed", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.FREEZING));
        context.register(PLAYER_ICE_CUBE_CRUSHED, (Object)new DamageType("marioverse.ice_cube_crushed.player", DamageScaling.ALWAYS, 0.1f, DamageEffects.FREEZING));
        context.register(PIRANHA_CHOMP, (Object)new DamageType("marioverse.piranha_chomp", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.5f, DamageEffects.THORNS));
        context.register(PLAYER_PIRANHA_CHOMP, (Object)new DamageType("marioverse.piranha_chomp.player", DamageScaling.ALWAYS, 0.5f, DamageEffects.THORNS));
        context.register(SHRAPNEL, (Object)new DamageType("marioverse.shrapnel", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.THORNS));
        context.register(PLAYER_SHRAPNEL, (Object)new DamageType("marioverse.shrapnel.player", DamageScaling.ALWAYS, 0.1f, DamageEffects.THORNS));
        context.register(STOMP, (Object)new DamageType("marioverse.stomp", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.5f, DamageEffects.HURT));
        context.register(PLAYER_STOMP, (Object)new DamageType("marioverse.stomp.player", DamageScaling.ALWAYS, 0.5f, DamageEffects.HURT));
        context.register(SUPER_STAR, (Object)new DamageType("marioverse.super_star", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.75f, DamageEffects.HURT));
        context.register(PLAYER_SUPER_STAR, (Object)new DamageType("marioverse.super_star.player", DamageScaling.ALWAYS, 0.75f, DamageEffects.HURT));
    }
}

