/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.sounds;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class FadeInAndOutSoundInstance
extends AbstractTickableSoundInstance {
    private final Entity entity;
    private final float fadeInDuration;
    private final float fadeOutDuration;
    private boolean fadingOut = false;
    private float ticksSinceFade = 0.0f;

    public FadeInAndOutSoundInstance(Entity entity, SoundEvent soundEvent, SoundSource soundSource, float fadeInDuration, float fadeOutDuration) {
        super(soundEvent, soundSource, entity.getRandom());
        this.entity = entity;
        this.fadeInDuration = fadeInDuration;
        this.fadeOutDuration = fadeOutDuration;
        this.looping = true;
        this.delay = 0;
        this.volume = 1.0f;
    }

    public void tick() {
        if (this.fadingOut) {
            this.ticksSinceFade += 1.0f;
            this.volume = Math.max(0.0f, 1.0f - this.ticksSinceFade / this.fadeOutDuration);
        } else {
            this.ticksSinceFade += 1.0f;
            this.volume = Math.min(1.0f, this.ticksSinceFade / this.fadeInDuration);
        }
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
    }

    public void startFadeIn() {
        if (this.fadingOut) {
            this.fadingOut = false;
            this.ticksSinceFade = 0.0f;
        }
    }

    public void startFadeOut() {
        if (!this.fadingOut) {
            this.fadingOut = true;
            this.ticksSinceFade = 0.0f;
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }
}

