/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SplunkinCarvedPumpkinBlock
extends CarvedPumpkinBlock {
    public static final BooleanProperty CRACKED = BooleanProperty.create((String)"cracked");

    public SplunkinCarvedPumpkinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{CRACKED});
        super.createBlockStateDefinition(stateBuilder);
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Boolean)world.getBlockState(pos).getValue((Property)CRACKED) != false ? 15 : 10;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(Items.PUMPKIN_PIE) && ((Boolean)state.getValue((Property)CRACKED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false)), 3);
            player.getItemInHand(hand).consume(1, (LivingEntity)player);
            world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        if (player.isCreative() && !((Boolean)state.getValue((Property)CRACKED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 3);
            world.levelEvent(player, 2001, pos, SplunkinCarvedPumpkinBlock.getId((BlockState)state));
            world.playSound(null, pos, (SoundEvent)SoundRegistry.SPLUNKIN_CRACKS.get(), SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hitResult);
    }

    protected void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (!((Boolean)state.getValue((Property)CRACKED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 3);
            world.levelEvent(player, 2001, pos, SplunkinCarvedPumpkinBlock.getId((BlockState)state));
            world.playSound(null, pos, (SoundEvent)SoundRegistry.SPLUNKIN_CRACKS.get(), SoundSource.BLOCKS);
        }
        super.attack(state, world, pos, player);
    }
}

