/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.models.blocks;

import com.wenxin2.marioverse.blocks.CheckpointFlagBlock;
import com.wenxin2.marioverse.blocks.GoalPoleBlock;
import com.wenxin2.marioverse.blocks.entities.CheckpointFlagBlockEntity;
import com.wenxin2.marioverse.registries.BlockRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class CheckpointFlagBlockModel
extends GeoModel<CheckpointFlagBlockEntity> {
    private final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"geo/block/checkpoint_flag.geo.json");
    private final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"animations/block/checkpoint_flag.animation.json");
    private final ResourceLocation AMERICAN_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/checkpoint_flag/american_checkpoint_flag.png");
    private final ResourceLocation BOWSER_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/checkpoint_flag/bowser_checkpoint_flag.png");
    private final ResourceLocation CLASSIC_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/checkpoint_flag/classic_checkpoint_flag.png");
    private final ResourceLocation WONDER_FLAG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/entity/checkpoint_flag/wonder_checkpoint_flag.png");

    public ResourceLocation getModelResource(CheckpointFlagBlockEntity blockEntity) {
        return this.MODEL;
    }

    public ResourceLocation getTextureResource(CheckpointFlagBlockEntity blockEntity) {
        String colorName;
        BlockState state = blockEntity.getBlockState();
        Block block = blockEntity.getBlockState().getBlock();
        DyeColor color = null;
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHECKPOINT_FLAGS.entrySet()) {
            if (entry.getValue().get() != block) continue;
            color = entry.getKey();
            break;
        }
        String texturePath = "textures/entity/checkpoint_flag/";
        String string = colorName = color != null ? color.getName().toLowerCase() : "white";
        if (blockEntity.hasAmericanFlag()) {
            return this.AMERICAN_FLAG_TEXTURE;
        }
        if (!blockEntity.hasWonderFlag() && block == BlockRegistry.CLASSIC_CHECKPOINT_FLAG.get()) {
            return this.CLASSIC_FLAG_TEXTURE;
        }
        if (((Boolean)state.getValue((Property)CheckpointFlagBlock.CLAIMED)).booleanValue()) {
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)(texturePath + colorName + "_checkpoint_flag.png"));
        }
        if (blockEntity.hasWonderFlag()) {
            return this.WONDER_FLAG_TEXTURE;
        }
        return this.BOWSER_FLAG_TEXTURE;
    }

    public ResourceLocation getAnimationResource(CheckpointFlagBlockEntity block) {
        return this.ANIMATION;
    }

    public void setCustomAnimations(CheckpointFlagBlockEntity animatable, long instanceId, AnimationState<CheckpointFlagBlockEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        int rotationState = (Integer)animatable.getBlockState().getValue((Property)GoalPoleBlock.ROTATION);
        float[] rotationDegreesArray = new float[]{90.0f, 67.5f, 45.0f, 22.5f, 0.0f, 337.5f, 315.0f, 292.5f, 270.0f, 247.5f, 225.0f, 202.5f, 180.0f, 157.5f, 135.0f, 112.5f};
        float rotationDegrees = rotationDegreesArray[rotationState];
        Optional poleBone = this.getBone("flag_rotator");
        poleBone.ifPresent(geoBone -> geoBone.setRotY((float)Math.toRadians(rotationDegrees)));
    }
}

