/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.IceCubeModel;
import com.wenxin2.marioverse.entities.IceCubeEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class IceCubeRenderer
extends GeoEntityRenderer<IceCubeEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public IceCubeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new IceCubeModel());
        this.entityRenderer = renderManager.getEntityRenderDispatcher();
    }

    public void render(IceCubeEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity frozenEntity = entity.getOrCreateDisplayEntity(entity.level());
        Entity frozenPlayer = entity.getPlayer(entity.level());
        if (frozenEntity != null) {
            float scale = 1.0f;
            float heightScale = 1.0f;
            float widthScale = 1.0f;
            if (frozenEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)frozenEntity;
                if (livingEntity.getPersistentData().contains("Scale")) {
                    scale = livingEntity.getPersistentData().getFloat("Scale");
                }
                if (livingEntity.getPersistentData().contains("HeightScale")) {
                    heightScale = livingEntity.getPersistentData().getFloat("HeightScale");
                }
                if (livingEntity.getPersistentData().contains("WidthScale")) {
                    widthScale = livingEntity.getPersistentData().getFloat("WidthScale");
                }
            }
            float height = frozenEntity.getBbHeight() * scale * heightScale * 1.55f;
            float width = frozenEntity.getBbWidth() * scale * widthScale * 1.55f;
            if (frozenEntity.getBbHeight() >= frozenEntity.getBbWidth() * 3.0f) {
                width *= 2.0f;
            }
            poseStack.pushPose();
            this.withScale(width, height);
            entity.setSize(width, height);
            poseStack.translate(0.0f, (height - height / 1.55f) / 2.0f, 0.0f);
            poseStack.scale(scale * widthScale, scale * heightScale, scale * widthScale);
            IceCubeRenderer.renderEntityInIceCube(frozenEntity.getYRot(), poseStack, buffer, packedLight, frozenEntity, this.entityRenderer);
            poseStack.popPose();
        }
        if (frozenPlayer != null) {
            float width = frozenPlayer.getDimensions(Pose.STANDING).width() * 2.55f;
            float height = frozenPlayer.getDimensions(Pose.STANDING).height() * 1.55f;
            poseStack.pushPose();
            this.withScale(width, height);
            entity.setSize(width, height);
            poseStack.popPose();
        }
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public static void renderEntityInIceCube(float entityYaw, PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, EntityRenderDispatcher renderDispatcher) {
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(entityYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.popPose();
        renderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, entityYaw, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

