/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.mojang.authlib.GameProfile;
import com.wenxin2.marioverse.entities.CrackableEntity;
import com.wenxin2.marioverse.entities.DryBonesEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.NearestAttackableTagGoal;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KoopaTroopaEntity
extends Monster
implements CrackableEntity,
GeoEntity {
    private static final EntityDataAccessor<Byte> DATA_ID_HIDE_FLAGS = SynchedEntityData.defineId(KoopaTroopaEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_BOUNCE_COUNT = SynchedEntityData.defineId(KoopaTroopaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final RawAnimation ATTACK_SWING_LEFT = RawAnimation.begin().thenPlay("attack.swing.left");
    public static final RawAnimation ATTACK_SWING_RIGHT = RawAnimation.begin().thenPlay("attack.swing.right");
    public static final RawAnimation HIDE = RawAnimation.begin().thenPlayAndHold("move.hide");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    public static final RawAnimation SIT = RawAnimation.begin().thenLoop("misc.sit");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isHiding;
    public int hideTicks = -1;
    public int hideAnimationTicks = 0;

    public KoopaTroopaEntity(EntityType<? extends KoopaTroopaEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.xpReward = 5;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.KOOPA_TROOPA_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.KOOPA_TROOPA_DEATH.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.KOOPA_TROOPA_AMBIENT.get();
    }

    public int getAmbientSoundInterval() {
        return 360;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_BOUNCE_COUNT, (Object)0);
        builder.define(DATA_ID_HIDE_FLAGS, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(2, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.GREEN_KOOPA_TROOPA_CAN_ATTACK, 8.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTagGoal((Mob)this, TagRegistry.GREEN_KOOPA_TROOPA_CAN_ATTACK, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walk", 5, this::walkAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "hide_controller", 5, state -> PlayState.STOP).triggerableAnim("hide", HIDE));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)(this.isLeftHanded() ? ATTACK_SWING_LEFT : ATTACK_SWING_RIGHT)).transitionLength(1));
    }

    protected <E extends GeoAnimatable> PlayState walkAnimation(AnimationState<E> event) {
        if (this.isPassenger() && !(this.getVehicle() instanceof LivingEntity)) {
            event.setAndContinue(SIT);
            return PlayState.CONTINUE;
        }
        if (!this.isHiding()) {
            if (event.isMoving() || this.getDeltaMovement().horizontalDistance() >= 0.01) {
                event.setAndContinue(WALK);
                return PlayState.CONTINUE;
            }
            event.setAndContinue(IDLE);
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("HideFlags", ((Byte)this.entityData.get(DATA_ID_HIDE_FLAGS)).byteValue());
        tag.putInt("BounceCount", ((Integer)this.entityData.get(DATA_BOUNCE_COUNT)).intValue());
        tag.putInt("HideTicks", this.hideTicks);
        tag.putBoolean("IsHiding", this.isHiding());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_BOUNCE_COUNT, (Object)tag.getInt("BounceCount"));
        this.entityData.set(DATA_ID_HIDE_FLAGS, (Object)tag.getByte("HideFlags"));
        this.hideTicks = tag.getInt("HideTicks");
        this.hide(tag.getBoolean("IsHiding"));
    }

    public void tick() {
        super.tick();
        if (this.hideTicks > 0 && this.getDeltaMovement().horizontalDistance() == 0.0) {
            --this.hideTicks;
        }
        if (!this.level().isClientSide && this.hideAnimationTicks > 0) {
            --this.hideAnimationTicks;
            this.spawnKoopaShell(this.getHealth(), this.getHideDuration(), 0, true, true);
        }
    }

    public void aiStep() {
        if (!this.isHiding()) {
            super.aiStep();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(TagRegistry.HIDES_KOOPA_TROOPA)) {
            this.hide(true);
            this.getNavigation().stop();
            this.setXxa(0.0f);
            this.setSpeed(0.0f);
            this.ejectPassengers();
            this.hideTicks = this.getHideDuration();
            this.hideAnimationTicks = 15;
            this.triggerAnim("hide_controller", "hide");
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.KOOPA_TROOPA_STOMP.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        return super.hurt(source, amount);
    }

    protected void triggerOnDeathMobEffects(Entity.RemovalReason reason) {
        if (this.level() instanceof ServerLevel && this.getRandom().nextFloat() < 0.25f && reason == Entity.RemovalReason.KILLED) {
            this.spawnKoopaShell(this.getMaxHealth(), -1, -1, false, false);
        }
        super.triggerOnDeathMobEffects(reason);
    }

    public int getCurrentSwingDuration() {
        if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
            return 10 - (1 + MobEffectUtil.getDigSpeedAmplification((LivingEntity)this));
        }
        return this.hasEffect(MobEffects.DIG_SLOWDOWN) ? 10 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2 : 10;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float height) {
        if (entity instanceof KoopaTroopaEntity || entity instanceof DryBonesEntity) {
            return new Vec3(0.0, (double)this.getBbHeight() - 0.5, 0.0);
        }
        return super.getPassengerAttachmentPoint(entity, dimensions, height);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        KoopaTroopaEntity koopaTroopaEntity;
        super.populateDefaultEquipmentSlots(random, difficulty);
        float f = random.nextFloat();
        float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = random.nextInt(3);
            if (i == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_SWORD));
            }
        }
        if ((koopaTroopaEntity = this) instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)((Object)koopaTroopaEntity);
            float f3 = random.nextFloat();
            float f4 = this.level().getDifficulty() == Difficulty.HARD ? 0.05f : 0.01f;
            if (f3 < f4) {
                int i = random.nextInt(6);
                int randomInt = random.nextInt(1);
                if (i == 0) {
                    if (randomInt == 0) {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.MARIO_FIRE_HAT.get()));
                    } else {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.LUIGI_FIRE_HAT.get()));
                    }
                    handler.mv$setFireFlower(true);
                } else if (i == 1) {
                    if (randomInt == 0) {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.MARIO_ICE_HAT.get()));
                    } else {
                        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.LUIGI_ICE_HAT.get()));
                    }
                    handler.mv$setIceFlower(true);
                } else {
                    this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
                }
            }
        }
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(equipmentslot).isEmpty();
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.canTakeItem(player.getItemInHand(hand))) {
            this.equipItemIfPossible(player.getItemInHand(hand));
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        RandomSource random = serverWorld.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(serverWorld, random, difficulty);
        if (groupData instanceof KoopaGroupData) {
            KoopaGroupData koopaGroupData = (KoopaGroupData)groupData;
            if (koopaGroupData.canSpawnJockey) {
                EntityType entityType;
                Mob mob;
                Optional randomEntityHolder;
                if (random.nextDouble() < 0.05) {
                    List nearbyEntities = serverWorld.getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), entity -> entity.getType().is(TagRegistry.KOOPA_CAN_RIDE) && !entity.isVehicle());
                    if (!nearbyEntities.isEmpty()) {
                        Mob mob2 = (Mob)nearbyEntities.getFirst();
                        this.startRiding((Entity)mob2);
                    }
                } else if (random.nextDouble() < 0.05 && (randomEntityHolder = serverWorld.registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getTag(TagRegistry.KOOPA_CAN_RIDE).flatMap(tag -> tag.getRandomElement(random))).isPresent() && (mob = (Mob)(entityType = (EntityType)((Holder)randomEntityHolder.get()).value()).create(this.level())) != null) {
                    mob.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    mob.finalizeSpawn(serverWorld, difficulty, MobSpawnType.JOCKEY, null);
                    this.startRiding((Entity)mob);
                    serverWorld.addFreshEntity((Entity)mob);
                }
            }
        }
        if (random.nextFloat() < 0.01f && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.TURTLE_HELMET));
        }
        if (random.nextFloat() < 0.25f && this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.DIAMOND_BOOTS));
        } else if (random.nextFloat() < 0.85f && this.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)this.getKoopaShoes()));
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localDate = LocalDate.now();
            int day = localDate.getDayOfMonth();
            int month = localDate.getMonth().getValue();
            List players = serverWorld.getLevel().players();
            boolean isHalloween = month == 10 && day >= 30 && (Boolean)ConfigRegistry.DISABLE_KOOPA_MASKS.get() == false;
            boolean forceMasks = (Boolean)ConfigRegistry.FORCE_KOOPA_MASKS.get();
            Optional<Item> randomMask = BuiltInRegistries.ITEM.getTag(TagRegistry.HALLOWEEN_MASKS).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value);
            if (isHalloween || forceMasks) {
                ArrayList skulls;
                boolean appliedMask = false;
                if (random.nextFloat() < 0.25f) {
                    randomMask.ifPresent(item -> this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)item)));
                    appliedMask = this.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.HALLOWEEN_MASKS);
                }
                if (random.nextFloat() < 0.15f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.ITEM).getTagOrEmpty(ItemTags.SKULLS).forEach(holder -> {
                        Item item = (Item)holder.value();
                        skulls.add(new ItemStack((ItemLike)item));
                    });
                    if (!skulls.isEmpty()) {
                        ItemStack randomSkull = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        if (randomSkull.getItem() instanceof PlayerHeadItem && !players.isEmpty()) {
                            ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                            GameProfile playerProfile = randomPlayer.getGameProfile();
                            ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                            playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                            this.setItemSlot(EquipmentSlot.HEAD, playerHead);
                        } else {
                            this.setItemSlot(EquipmentSlot.HEAD, randomSkull);
                        }
                        appliedMask = true;
                    }
                }
                if (random.nextFloat() < 0.1f && !players.isEmpty()) {
                    ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                    GameProfile playerProfile = randomPlayer.getGameProfile();
                    SkullBlockEntity.fetchGameProfile((UUID)randomPlayer.getUUID());
                    ItemStack playerHeadItem = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                    playerHeadItem.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                    this.setItemSlot(EquipmentSlot.HEAD, playerHeadItem);
                    appliedMask = true;
                }
                if (random.nextFloat() < 0.05f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.BLOCK).getTagOrEmpty(CompatRegistry.TF_TROPHIES).forEach(holder -> skulls.add(new ItemStack((ItemLike)holder.value())));
                    if (!skulls.isEmpty()) {
                        ItemStack randomTrophy = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        this.setItemSlot(EquipmentSlot.HEAD, randomTrophy);
                        appliedMask = true;
                    }
                }
                if (appliedMask) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
                }
            }
        }
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    public static boolean checkKoopaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return serverWorld.getBlockState(pos.below()).isValidSpawn((BlockGetter)serverWorld, pos, entityType) || spawnType == MobSpawnType.SPAWNER;
    }

    public boolean canBeLeashed() {
        return true;
    }

    @Override
    public Crackiness.Level getCrackiness() {
        return Crackiness.WOLF_ARMOR.byFraction(1.0f - (float)this.getBounceCount() / (float)ConfigRegistry.MAX_KOOPA_SHELL_DAMAGE_POINTS.getAsInt());
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (!KoopaTroopaEntity.this.isHiding()) {
                    super.clientTick();
                }
            }
        };
    }

    public boolean isHiding() {
        return this.isHiding;
    }

    public void hide(boolean isHiding) {
        this.setHideFlag(8, isHiding);
        this.isHiding = isHiding;
    }

    private boolean getHideFlag(int i) {
        return ((Byte)this.entityData.get(DATA_ID_HIDE_FLAGS) & i) != 0;
    }

    private void setHideFlag(int i, boolean b) {
        byte b0 = (Byte)this.entityData.get(DATA_ID_HIDE_FLAGS);
        if (b) {
            this.entityData.set(DATA_ID_HIDE_FLAGS, (Object)((byte)(b0 | i)));
        } else {
            this.entityData.set(DATA_ID_HIDE_FLAGS, (Object)((byte)(b0 & ~i)));
        }
    }

    @NotNull
    public KoopaShellEntity getKoopaShellEntity() {
        return new KoopaShellEntity((EntityType<? extends KoopaShellEntity>)((EntityType)EntityRegistry.GREEN_KOOPA_SHELL.get()), this.level());
    }

    @NotNull
    public Item getKoopaShoes() {
        return (Item)ItemRegistry.GREEN_KOOPA_SHOES.get();
    }

    @NotNull
    public Integer getHideDuration() {
        return (Integer)ConfigRegistry.GREEN_KOOPA_TROOPA_HIDE_DURATION.get();
    }

    public void setBounceCount(int bounceCount) {
        this.entityData.set(DATA_BOUNCE_COUNT, (Object)bounceCount);
    }

    public int getBounceCount() {
        return (Integer)this.entityData.get(DATA_BOUNCE_COUNT);
    }

    public void spawnKoopaShell(float shellHealth, int hideTicks, int emergeAnimationTicks, boolean saveArmor, boolean savePowerUp) {
        if (this.hideAnimationTicks == 0) {
            KoopaShellEntity shell = this.getKoopaShellEntity();
            shell.setBounceCount(this.getBounceCount());
            shell.setHideTicks(hideTicks);
            shell.setPos(this.getX(), this.getY(), this.getZ());
            shell.setYRot(this.getYRot());
            shell.setXRot(this.getXRot());
            shell.yBodyRot = this.yBodyRot;
            shell.setYHeadRot(this.getYHeadRot());
            shell.setHealth(shellHealth);
            shell.emergeAnimationTicks = emergeAnimationTicks;
            shell.setNoAi(this.isNoAi());
            this.copyAttributeWithModifiers((LivingEntity)shell, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE);
            this.copyAttributeWithModifiers((LivingEntity)shell, (Holder<Attribute>)Attributes.SCALE);
            this.copyAttributeWithModifiers((LivingEntity)shell, (Holder<Attribute>)AttributesRegistry.EYE_HEIGHT_SCALE);
            this.copyAttributeWithModifiers((LivingEntity)shell, (Holder<Attribute>)AttributesRegistry.HEIGHT_SCALE);
            this.copyAttributeWithModifiers((LivingEntity)shell, (Holder<Attribute>)AttributesRegistry.WIDTH_SCALE);
            if (saveArmor) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    shell.setItemSlot(slot, this.getItemBySlot(slot).copy());
                }
            }
            if (savePowerUp) {
                AccessoriesCapability capability;
                String[] stringArray = this;
                if (stringArray instanceof AbilitiesHandler) {
                    AbilitiesHandler handler = (AbilitiesHandler)stringArray;
                    if (shell instanceof AbilitiesHandler) {
                        AbilitiesHandler entityHandler = (AbilitiesHandler)((Object)shell);
                        entityHandler.mv$setSuperMushroom(handler.mv$hasSuperMushroom());
                        entityHandler.mv$setMegaMushroom(handler.mv$hasMegaMushroom());
                        entityHandler.mv$setFireFlower(handler.mv$hasFireFlower());
                        entityHandler.mv$setIceFlower(handler.mv$hasIceFlower());
                        shell.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Boolean)this.getData(DataAttachmentRegistry.HAS_SUPER_STAR));
                        shell.setData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN, (Integer)this.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN));
                    }
                }
                if ((capability = AccessoriesCapability.get((LivingEntity)this)) != null && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get()).booleanValue() && this.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
                    String[] slotTypes;
                    for (String slotType : slotTypes = new String[]{"costume_hat", "costume_shirt", "costume_pants", "costume_shoes"}) {
                        AccessoriesContainer container = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)this, (String)slotType));
                        AccessoriesContainer containerEntity = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)shell, (String)slotType));
                        if (container == null) continue;
                        ItemStack stack = container.getAccessories().getItem(0);
                        if (containerEntity == null) continue;
                        containerEntity.getAccessories().setItem(0, stack);
                    }
                }
            }
            this.level().addFreshEntity((Entity)shell);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void copyAttributeWithModifiers(LivingEntity entity, Holder<Attribute> attribute) {
        AttributeInstance fromAttr = this.getAttribute(attribute);
        AttributeInstance toAttr = entity.getAttribute(attribute);
        if (fromAttr != null && toAttr != null) {
            toAttr.setBaseValue(fromAttr.getBaseValue());
            for (AttributeModifier modifier : fromAttr.getModifiers()) {
                toAttr.addPermanentModifier(modifier);
            }
        }
    }

    public static class KoopaGroupData
    implements SpawnGroupData {
        public final boolean canSpawnJockey;

        public KoopaGroupData(boolean canSpawnJockey) {
            this.canSpawnJockey = canSpawnJockey;
        }
    }
}

