/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.GoombaEntity;
import com.wenxin2.marioverse.entities.ai.controls.AmphibiousMoveControl;
import com.wenxin2.marioverse.entities.ai.goals.GoombaRideGoal;
import com.wenxin2.marioverse.entities.ai.goals.GoombaSitGoal;
import com.wenxin2.marioverse.entities.ai.goals.GoombaSleepGoal;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.entities.ai.goals.NearestAttackableTagGoal;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class MegaGoombaEntity
extends GoombaEntity
implements GeoEntity {
    public MegaGoombaEntity(EntityType<? extends MegaGoombaEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.setPathfindingMalus(PathType.WATER, 2.0f);
        this.moveControl = new AmphibiousMoveControl((PathfinderMob)this, 85, 10, 0.6f, 1.0f, true);
        this.xpReward = 8;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.MEGA_GOOMBA_HURT.get();
    }

    @Override
    @NotNull
    public SoundEvent getStompSound() {
        return (SoundEvent)SoundRegistry.MEGA_GOOMBA_STOMP.get();
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        SoundType soundtype = state.getSoundType((LevelReader)this.level(), pos, (Entity)this);
        this.playSound((SoundEvent)SoundRegistry.MEGA_GOOMBA_STEP.get(), 1.0f, 1.0f);
        this.playSound(soundtype.getStepSound(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
    }

    @Override
    protected SoundEvent getBumpSound() {
        return (SoundEvent)SoundRegistry.MEGA_GOOMBA_BUMP.get();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LookAtTagGoal((Mob)this, TagRegistry.MEGA_GOOMBA_CAN_ATTACK, 8.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new GoombaSitGoal(this, 0.25f, 1200, 3000, 300));
        this.goalSelector.addGoal(5, (Goal)new GoombaSleepGoal(this, 0.1f, 2400, 6000));
        this.goalSelector.addGoal(6, (Goal)new GoombaRideGoal(this, 0.01f));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTagGoal((Mob)this, TagRegistry.MEGA_GOOMBA_CAN_ATTACK, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.level().isClientSide && this.isDeadOrDying() && this.getLastDamageSource() != null && !this.getLastDamageSource().is(DamageTypeTags.IS_FIRE)) {
            Component component = this.getCustomName();
            boolean flag = this.isNoAi();
            float width = this.getDimensions(this.getPose()).width() / 4.0f;
            int amtSpawned = (Integer)ConfigRegistry.HEFTY_GOOMBA_SPLIT_COUNT.get() + this.random.nextInt(((Integer)ConfigRegistry.HEFTY_GOOMBA_SPLIT_RANDOM_COUNT.get()).intValue());
            ArrayList<GoombaEntity> spawnedGoombas = new ArrayList<GoombaEntity>();
            for (int i = 0; i <= amtSpawned; ++i) {
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double xOffset = Math.cos(angle) * (double)width;
                double zOffset = Math.sin(angle) * (double)width;
                double upwardMotion = 0.2 + this.random.nextDouble() * 0.2;
                GoombaEntity goomba = (GoombaEntity)((EntityType)EntityRegistry.HEFTY_GOOMBA.get()).create(this.level());
                if (goomba == null) continue;
                if (this.isPersistenceRequired()) {
                    goomba.setPersistenceRequired();
                }
                goomba.setCustomName(component);
                goomba.setNoAi(flag);
                goomba.setInvulnerable(this.isInvulnerable());
                goomba.moveTo(this.getX() + xOffset, this.getY() + 0.5, this.getZ() + zOffset, this.random.nextFloat() * 360.0f, 0.0f);
                goomba.setDeltaMovement(xOffset * 0.3, upwardMotion, zOffset * 0.3);
                goomba.move(MoverType.SELF, goomba.getDeltaMovement());
                spawnedGoombas.add(goomba);
            }
            if (!EventHooks.onMobSplit((Mob)this, spawnedGoombas).isCanceled()) {
                spawnedGoombas.forEach((Consumer<GoombaEntity>)((Consumer<Mob>)arg_0 -> ((Level)this.level()).addFreshEntity(arg_0)));
            }
        }
        super.remove(removalReason);
    }
}

