/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.power_ups.BaseMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.BasePowerUpEntity;
import com.wenxin2.marioverse.entities.power_ups.FireFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.IceFlowerEntity;
import com.wenxin2.marioverse.entities.power_ups.MushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.OneUpMushroomEntity;
import com.wenxin2.marioverse.entities.power_ups.SuperStarEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ChaseTargetGoal<T extends LivingEntity>
extends Goal {
    private final Class<T> targetClass;
    private final Mob mob;
    private T target;
    private int chaseTick;
    private final double speedModifier;

    public ChaseTargetGoal(Mob mob, double speedModifier, Class<T> targetClass) {
        this.mob = mob;
        this.targetClass = targetClass;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.findTarget();
        Mob mob = this.mob;
        if (mob instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)mob;
            if (this.target instanceof MushroomEntity && !handler.mv$hasSuperMushroom()) {
                return true;
            }
            if (this.target instanceof FireFlowerEntity && !handler.mv$hasFireFlower()) {
                return true;
            }
            if (this.target instanceof IceFlowerEntity && !handler.mv$hasIceFlower()) {
                return true;
            }
            if (this.target instanceof OneUpMushroomEntity && (this.mob.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue())) {
                return true;
            }
            if (this.target instanceof SuperStarEntity && (this.mob.getType().is(TagRegistry.CAN_CONSUME_SUPER_STARS) || ((Boolean)ConfigRegistry.SUPER_STAR_POWERS_ALL_MOBS.get()).booleanValue())) {
                return true;
            }
            if (!(this.target instanceof BasePowerUpEntity) && !(this.target instanceof BaseMushroomEntity)) {
                return this.target != null;
            }
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.distanceToSqr(this.target) > 1.0;
    }

    public void start() {
        if (this.target != null) {
            this.mob.getNavigation().moveTo(this.target, this.speedModifier);
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.target = null;
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block7: {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            world = this.mob.level();
                            if (this.mob.getDeltaMovement().horizontalDistance() == 0.0) {
                                ++this.chaseTick;
                            }
                            if (this.chaseTick == 50) {
                                this.mob.getNavigation().stop();
                            }
                            if (this.target == null) break block7;
                            this.mob.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
                            this.mob.getNavigation().moveTo(this.target, this.speedModifier);
                            if (!(this.mob.distanceToSqr(this.target) < (double)this.mob.getBbWidth() + 2.5) || !((var3_2 = this.mob) instanceof AbilitiesHandler)) break block7;
                            handler = (AbilitiesHandler)var3_2;
                            var8_4 = this.target;
                            if (!(var8_4 instanceof MushroomEntity)) break block8;
                            powerUp = (MushroomEntity)var8_4;
                            if (handler.mv$hasSuperMushroom()) break block8;
                            handler.applyMushroomPowerUp(world, (LivingEntity)this.mob, powerUp, ((Double)ConfigRegistry.SUPER_MUSHROOM_HEALTH_HEALED.get()).floatValue());
                            break block9;
                        }
                        if (!((var8_4 = this.target) instanceof FireFlowerEntity)) break block10;
                        powerUp = (FireFlowerEntity)var8_4;
                        if (handler.mv$hasFireFlower()) break block10;
                        handler.applyFireFlowerPowerUp(world, (LivingEntity)this.mob, powerUp);
                        break block9;
                    }
                    if (!((var8_4 = this.target) instanceof IceFlowerEntity)) break block11;
                    powerUp = (IceFlowerEntity)var8_4;
                    if (handler.mv$hasIceFlower()) break block11;
                    handler.applyIceFlowerPowerUp(world, (LivingEntity)this.mob, powerUp);
                    break block9;
                }
                if (!((var8_4 = this.target) instanceof OneUpMushroomEntity)) ** GOTO lbl-1000
                powerUp = (OneUpMushroomEntity)var8_4;
                if (this.mob.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS) || ((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue()) {
                    handler.applyOneUpMushroomPowerUp(world, new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()), (LivingEntity)this.mob, powerUp);
                } else if ((var8_4 = this.target) instanceof SuperStarEntity) {
                    powerUp = (SuperStarEntity)var8_4;
                    if (this.mob.getType().is(TagRegistry.CAN_CONSUME_SUPER_STARS) || ((Boolean)ConfigRegistry.SUPER_STAR_POWERS_ALL_MOBS.get()).booleanValue()) {
                        handler.applySuperStarPowerUp(world, (LivingEntity)this.mob, powerUp);
                    }
                }
            }
            if (this.target instanceof BasePowerUpEntity || this.target instanceof BaseMushroomEntity) {
                this.target.discard();
                this.mob.swing(this.mob.getUsedItemHand());
            }
        }
    }

    private T findTarget() {
        AABB searchBox;
        Level world = this.mob.level();
        List entities = world.getEntitiesOfClass(this.targetClass, searchBox = this.mob.getBoundingBox().inflate(8.0), entity -> entity != this.mob && entity.isAlive());
        return (T)(entities.isEmpty() ? null : (LivingEntity)entities.getFirst());
    }
}

