/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.BooEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class RandomMoveGoal
extends Goal {
    private final Mob mob;

    public RandomMoveGoal(Mob mob) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
    }

    public boolean canUse() {
        return !this.mob.getMoveControl().hasWanted() && this.mob.getRandom().nextInt(RandomMoveGoal.reducedTickDelay((int)7)) == 0;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void tick() {
        BlockPos blockpos = null;
        Mob mob = this.mob;
        if (mob instanceof BooEntity) {
            BooEntity boo = (BooEntity)mob;
            blockpos = boo.getBoundOrigin();
        }
        if (blockpos == null) {
            blockpos = this.mob.blockPosition();
        }
        for (int i = 0; i < 3; ++i) {
            BlockPos blockpos1 = blockpos.offset(this.mob.getRandom().nextInt(15) - 7, this.mob.getRandom().nextInt(11) - 5, this.mob.getRandom().nextInt(15) - 7);
            if (!this.mob.level().isEmptyBlock(blockpos1)) continue;
            this.mob.getMoveControl().setWantedPosition((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 0.25);
            if (this.mob.getTarget() != null) break;
            this.mob.getLookControl().setLookAt((double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.5, (double)blockpos1.getZ() + 0.5, 180.0f, 20.0f);
            break;
        }
    }
}

