/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.items;

import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpTrapDoorBlockEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class WarpDisruptorItem
extends Item {
    public WarpDisruptorItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        MutableComponent rCText = Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click.selected"));
        MutableComponent shiftRCText = Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.prevents"));
        MutableComponent shiftRCx2Text = Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click_2.breaks"));
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.literal((String)""));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click")));
            rCText = rCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click.mob")));
            if (!((Boolean)ConfigRegistry.DISABLE_PLAYER_WARP_DISRUPTING.get()).booleanValue()) {
                rCText = rCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click.player")));
            }
            rCText = rCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.right_click.warping")));
            list.add((Component)rCText);
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click")));
            shiftRCText = shiftRCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.pipe")));
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue()) {
                shiftRCText = shiftRCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.door")));
            }
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue()) {
                shiftRCText = shiftRCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.trapdoor")));
            }
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue()) {
                shiftRCText = shiftRCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.painting")));
            }
            shiftRCText = shiftRCText.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click.warping")));
            list.add((Component)shiftRCText);
            if (!(((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue() && ((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue() && ((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue())) {
                list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click_2")));
                if (!((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue()) {
                    shiftRCx2Text = shiftRCx2Text.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click_2.door")));
                }
                if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue()) {
                    shiftRCx2Text = shiftRCx2Text.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click_2.trapdoor")));
                }
                if (!((Boolean)ConfigRegistry.DISABLE_WARP_PAINTINGS.get()).booleanValue()) {
                    shiftRCx2Text = shiftRCx2Text.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click_2.painting")));
                }
                shiftRCx2Text = shiftRCx2Text.append((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.shift_right_click_2.warping")));
                list.add((Component)shiftRCx2Text);
            }
        } else {
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        }
        super.appendHoverText(stack, tooltipContext, list, tooltip);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        Player player = useOnContext.getPlayer();
        Level world = useOnContext.getLevel();
        BlockPos pos = useOnContext.getClickedPos();
        BlockState state = world.getBlockState(pos);
        ItemStack stack = useOnContext.getItemInHand();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!((Boolean)ConfigRegistry.DISABLE_WARP_DOORS.get()).booleanValue() && state.getBlock() instanceof DoorBlock && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            BlockEntity blockEntityBelow = world.getBlockEntity(pos.below());
            if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER && blockEntity instanceof WarpDoorBlockEntity) {
                WarpDoorBlockEntity doorBE = (WarpDoorBlockEntity)blockEntity;
                if (!doorBE.preventWarp || !doorBE.breakDoor) {
                    if (doorBE.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.GOLD), true);
                        }
                        return InteractionResult.sidedSuccess((boolean)Boolean.TRUE);
                    }
                    if (doorBE.preventWarp) {
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.WARPED_SPORE, serverWorld, null, pos, 16);
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.break_door"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.DARK_AQUA), true);
                        }
                        doorBE.setBreakDoor(Boolean.TRUE);
                    } else {
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, serverWorld, null, pos, 16);
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_door_warp"), (Object[])new Object[]{50}), true);
                        }
                        doorBE.setPreventWarp(Boolean.TRUE);
                    }
                    if (player != null && !player.isCreative()) {
                        stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    }
                    doorBE.markUpdated();
                    world.sendBlockUpdated(pos, state, state, 3);
                    return InteractionResult.SUCCESS;
                }
            }
            if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER && blockEntityBelow instanceof WarpDoorBlockEntity) {
                WarpDoorBlockEntity doorBE = (WarpDoorBlockEntity)blockEntityBelow;
                if (!doorBE.preventWarp || !doorBE.breakDoor) {
                    if (doorBE.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.GOLD), true);
                        }
                        return InteractionResult.sidedSuccess((boolean)Boolean.TRUE);
                    }
                    if (doorBE.preventWarp) {
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.WARPED_SPORE, serverWorld, null, pos, 16);
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.break_door"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.DARK_AQUA), true);
                        }
                        doorBE.setBreakDoor(Boolean.TRUE);
                    } else {
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, serverWorld, null, pos, 16);
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_door_warp")), true);
                        }
                        doorBE.setPreventWarp(Boolean.TRUE);
                    }
                    if (player != null && !player.isCreative()) {
                        stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    }
                    doorBE.markUpdated();
                    world.sendBlockUpdated(pos, state, state, 3);
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            if (!((Boolean)ConfigRegistry.DISABLE_WARP_TRAPDOORS.get()).booleanValue() && blockEntity instanceof WarpTrapDoorBlockEntity) {
                WarpTrapDoorBlockEntity warpTrapdoorBE = (WarpTrapDoorBlockEntity)blockEntity;
                if (!(warpTrapdoorBE.preventWarp && warpTrapdoorBE.breakTrapdoor || !(world instanceof ServerLevel))) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    if (warpTrapdoorBE.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.GOLD), true);
                        }
                        return InteractionResult.sidedSuccess((boolean)Boolean.TRUE);
                    }
                    if (warpTrapdoorBE.preventWarp) {
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.WARPED_SPORE, serverWorld, null, pos, 16);
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.break_trapdoor"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.DARK_AQUA), true);
                        }
                        warpTrapdoorBE.setBreakTrapdoor(Boolean.TRUE);
                    } else {
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, serverWorld, null, pos, 16);
                        if (player != null) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_trapdoor_warp")), true);
                        }
                        warpTrapdoorBE.setPreventWarp(Boolean.TRUE);
                    }
                    if (player != null && !player.isCreative()) {
                        stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    }
                    warpTrapdoorBE.markUpdated();
                    world.sendBlockUpdated(pos, state, state, 3);
                    return InteractionResult.SUCCESS;
                }
            }
            if (blockEntity instanceof BaseWarpBlockEntity) {
                BaseWarpBlockEntity warpBE = (BaseWarpBlockEntity)blockEntity;
                if (!warpBE.preventWarp && world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    warpBE.setPreventWarp(Boolean.TRUE);
                    ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, serverWorld, null, pos, 16);
                    if (player != null) {
                        if (warpBE.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.GOLD), true);
                            return InteractionResult.sidedSuccess((boolean)Boolean.TRUE);
                        }
                        if (state.getBlock() instanceof WarpPipeBlock) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_pipe_warp")), true);
                        }
                        if (!player.isCreative()) {
                            stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                        }
                    }
                    warpBE.markUpdated();
                    world.sendBlockUpdated(pos, state, state, 3);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.useOn(useOnContext);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        BlockWarpEntityHandler handler;
        if (livingEntity instanceof BlockWarpEntityHandler && !(handler = (BlockWarpEntityHandler)livingEntity).mv$doPreventWarp()) {
            if (livingEntity instanceof Player && !((Boolean)ConfigRegistry.DISABLE_PLAYER_WARP_DISRUPTING.get()).booleanValue()) {
                handler.mv$setPreventWarp(true);
                handler.mv$setPreventWarpCooldown((Integer)ConfigRegistry.WARP_DISRUPTING_COOLDOWN.get());
                player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_player_warp"), (Object[])new Object[]{player.getDisplayName(), ConfigRegistry.WARP_DISRUPTING_COOLDOWN.get()}).withStyle(ChatFormatting.RED), true);
                this.spawnEntityParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (Entity)player, livingEntity.level(), 16);
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
                return InteractionResult.SUCCESS;
            }
            if (!(livingEntity instanceof Player)) {
                handler.mv$setPreventWarp(true);
                player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_entity_warp"), (Object[])new Object[]{livingEntity.getDisplayName()}).withStyle(ChatFormatting.RED), true);
                this.spawnEntityParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (Entity)livingEntity, livingEntity.level(), 16);
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        HitResult hitResult;
        double reachDistance;
        ItemStack stack = player.getItemInHand(hand);
        AttributeInstance reachAttribute = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        double d = reachDistance = player.isCreative() ? 5.0 : 4.5;
        if (reachAttribute != null) {
            reachDistance = reachAttribute.getValue();
        }
        if ((hitResult = player.pick(reachDistance, 0.0f, false)).getType() == HitResult.Type.MISS) {
            BlockWarpEntityHandler handler;
            if (!((Boolean)ConfigRegistry.DISABLE_PLAYER_WARP_DISRUPTING.get()).booleanValue() && player instanceof BlockWarpEntityHandler && !(handler = (BlockWarpEntityHandler)player).mv$doPreventWarp()) {
                handler.mv$setPreventWarp(true);
                handler.mv$setPreventWarpCooldown((Integer)ConfigRegistry.WARP_DISRUPTING_COOLDOWN.get());
                player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.prevent_player_warp"), (Object[])new Object[]{player.getDisplayName(), ConfigRegistry.WARP_DISRUPTING_COOLDOWN.get()}).withStyle(ChatFormatting.RED), true);
                this.spawnEntityParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (Entity)player, world, 16);
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
                return InteractionResultHolder.success((Object)stack);
            }
        } else {
            return InteractionResultHolder.pass((Object)stack);
        }
        return super.use(world, player, hand);
    }

    public void spawnEntityParticles(ParticleOptions particleType, Entity entity, Level world, int avgAmount) {
        float scaleFactor = entity.getBbWidth();
        int numParticles = (int)(scaleFactor * (float)avgAmount);
        double radius = entity.getBbWidth() / 2.0f;
        for (int i = 0; i < numParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numParticles;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = entity.getBbHeight();
            double offsetZ = Math.sin(angle) * radius;
            double x = entity.getX() + offsetX;
            double y = entity.getY();
            double z = entity.getZ() + offsetZ;
            world.addParticle(particleType, x, y + 0.2, z, 0.0, 1.0, 0.0);
            world.addParticle(particleType, x, y + offsetY / 2.0, z, 0.0, 1.0, 0.0);
            world.addParticle(particleType, x, y + offsetY - 0.2, z, 0.0, 1.0, 0.0);
        }
    }
}

