/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wenxin2.marioverse.blocks.ClearWarpPipeBlock;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.client.BubblesSlider;
import com.wenxin2.marioverse.client.WaterSpoutSlider;
import com.wenxin2.marioverse.inventory.WarpPipeMenu;
import com.wenxin2.marioverse.network.PacketHandler;
import com.wenxin2.marioverse.network.server_bound.data.ClosePipeButtonPayload;
import com.wenxin2.marioverse.network.server_bound.data.PipeBubblesButtonPayload;
import com.wenxin2.marioverse.network.server_bound.data.PipeBubblesSliderPayload;
import com.wenxin2.marioverse.network.server_bound.data.RenamePipePayload;
import com.wenxin2.marioverse.network.server_bound.data.WaterSpoutButtonPayload;
import com.wenxin2.marioverse.network.server_bound.data.WaterSpoutSliderPayload;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;

public class WarpPipeScreen
extends AbstractContainerScreen<WarpPipeMenu> {
    public static ResourceLocation WARP_PIPE_GUI = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"textures/gui/warp_pipe.png");
    Button bubblesButton;
    Button closeButton;
    Button renameButton;
    Button waterSpoutButton;
    EditBox renameBox;
    Inventory inventory;
    public static BlockPos lastClickedPos = null;
    public ExtendedSlider waterSpoutSlider;
    public ExtendedSlider bubblesSlider;
    private String pipeName = "";
    private Level world;

    public WarpPipeScreen(WarpPipeMenu container, Inventory inventory, Component name) {
        super((AbstractContainerMenu)container, inventory, name);
        this.inventory = inventory;
        this.world = inventory.player.level();
    }

    public void renderLabels(GuiGraphics graphics, int x, int y) {
        if (this.renameBox.visible) {
            graphics.drawString(this.font, "", this.titleLabelX, this.titleLabelY, 0x404040, false);
        } else if (!this.pipeName.isEmpty()) {
            graphics.drawString(this.font, this.pipeName, this.titleLabelX, this.titleLabelY, 0x404040, false);
        } else {
            graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        }
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        Player player = this.inventory.player;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WARP_PIPE_GUI);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(WARP_PIPE_GUI, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.getClickedPos() != null) {
            BlockEntity blockEntity = this.world.getBlockEntity(this.getClickedPos());
            BlockState state = this.world.getBlockState(this.getClickedPos());
            if (blockEntity instanceof WarpPipeBlockEntity) {
                WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
                if (this.renameButton.isHoveredOrFocused() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 18, 177, 170, 24, 24);
                } else if (this.renameButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 18, 177, 170, 24, 24);
                } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 18, 177, 194, 24, 24);
                } else {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 18, 177, 146, 24, 24);
                }
                if (this.renameBox.visible && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 4, 0, 167, 162, 12);
                } else if (this.renameBox.visible && !((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 4, 0, 167, 162, 12);
                }
                if (state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                    if (this.closeButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || this.closeButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && player.isCreative() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 202, 24, 24, 24);
                    } else if (this.closeButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && !((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || this.closeButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && player.isCreative() && !((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 202, 24, 24, 24);
                    } else if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 202, 48, 24, 24);
                    } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 202, 48, 24, 24);
                    } else {
                        graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 202, 0, 24, 24);
                    }
                } else if (this.closeButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || this.closeButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && player.isCreative() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 177, 24, 24, 24);
                } else if (this.closeButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && !((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || this.closeButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && player.isCreative() && !((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 177, 24, 24, 24);
                } else if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 177, 48, 24, 24);
                } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 177, 48, 24, 24);
                } else {
                    graphics.blit(WARP_PIPE_GUI, x + 7, y + 45, 177, 0, 24, 24);
                }
                if (state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue()) {
                    if (this.waterSpoutButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || this.waterSpoutButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && player.isCreative() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 202, 97, 24, 24);
                    } else if (this.waterSpoutButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && !((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || this.waterSpoutButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && player.isCreative() && !((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 202, 97, 24, 24);
                    } else if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 202, 121, 24, 24);
                    } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 202, 121, 24, 24);
                    } else {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 202, 73, 24, 24);
                    }
                } else if (this.waterSpoutButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || this.waterSpoutButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && player.isCreative() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 177, 97, 24, 24);
                } else if (this.waterSpoutButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && !((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || this.waterSpoutButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && player.isCreative() && !((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 177, 97, 24, 24);
                } else if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 177, 121, 24, 24);
                } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 177, 121, 24, 24);
                } else {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 18, 177, 73, 24, 24);
                }
                if (state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue()) {
                    if (this.bubblesButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || this.bubblesButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && player.isCreative() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 97, 24, 24);
                    } else if (this.bubblesButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && !((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || this.bubblesButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && player.isCreative() && !((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 97, 24, 24);
                    } else if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 121, 24, 24);
                    } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue()) {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 121, 24, 24);
                    } else {
                        graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 73, 24, 24);
                    }
                } else if (this.bubblesButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || this.bubblesButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && player.isCreative() && !pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 24, 24, 24);
                } else if (this.bubblesButton.isHoveredOrFocused() && !((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && !((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || this.bubblesButton.isHoveredOrFocused() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && player.isCreative() && !((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 24, 24, 24);
                } else if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 48, 24, 24);
                } else if (pipeBlockEntity.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue()) {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 48, 24, 24);
                } else {
                    graphics.blit(WARP_PIPE_GUI, x + 34, y + 45, 227, 0, 24, 24);
                }
            }
        }
    }

    public void init() {
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        super.init();
        lastClickedPos = this.getClickedPos();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renameBox = new EditBox(this.font, x + 8, y + 6, 160, 12, (Component)Component.translatable((String)"menu.marioverse.warp_pipe.rename_box.narrate"));
        this.renameBox.setTooltip(Tooltip.create((Component)Component.translatable((String)"menu.marioverse.warp_pipe.rename_box.tooltip")));
        this.renameBox.setValue(this.renameBox.getValue());
        this.renameBox.setBordered(false);
        this.renameBox.setVisible(false);
        this.renameBox.setMaxLength(27);
        this.addRenderableWidget((GuiEventListener)this.renameBox);
        MutableComponent rename = Component.translatable((String)"menu.marioverse.warp_pipe.rename_button");
        this.renameButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)rename, b -> this.renameButtonOnPress()).bounds(x + 7, y + 18, 24, 24).createNarration(supplier -> Component.translatable((String)"menu.marioverse.warp_pipe.rename_button.narrate")).build());
        this.renameButton.setAlpha(0.0f);
        MutableComponent close = Component.translatable((String)"menu.marioverse.warp_pipe.close_button");
        this.closeButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)close, b -> this.closeButtonOnPress()).bounds(x + 7, y + 45, 24, 24).createNarration(supplier -> Component.translatable((String)"menu.marioverse.warp_pipe.close_button.narrate")).build());
        this.closeButton.setAlpha(0.0f);
        MutableComponent waterSpout = Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_button");
        this.waterSpoutButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)waterSpout, b -> this.waterSpoutButtonOnPress()).bounds(x + 34, y + 18, 24, 24).createNarration(supplier -> Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_button.narrate")).build());
        this.waterSpoutButton.setAlpha(0.0f);
        BlockPos clickedPos = this.getClickedPos();
        int spoutHeight = 4;
        if (clickedPos != null && Minecraft.getInstance().level != null && (blockEntity2 = Minecraft.getInstance().level.getBlockEntity(clickedPos)) instanceof WarpPipeBlockEntity) {
            spoutHeight = ((WarpPipeBlockEntity)blockEntity2).getSpoutHeight();
        }
        MutableComponent height = Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_slider.height");
        this.waterSpoutSlider = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)new WaterSpoutSlider(x + 61, y + 18, 108, 24, (Component)height, (Component)Component.literal((String)""), 0.0, 16.0, spoutHeight, 1.0, 0, true));
        MutableComponent bubbles = Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_button");
        this.bubblesButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)bubbles, b -> this.bubblesButtonOnPress()).bounds(x + 34, y + 45, 24, 24).createNarration(supplier -> Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_button.narrate")).build());
        this.bubblesButton.setAlpha(0.0f);
        clickedPos = this.getClickedPos();
        int bubblesDistance = 3;
        if (clickedPos != null && Minecraft.getInstance().level != null && (blockEntity = Minecraft.getInstance().level.getBlockEntity(clickedPos)) instanceof WarpPipeBlockEntity) {
            bubblesDistance = ((WarpPipeBlockEntity)blockEntity).getBubblesDistance();
        }
        MutableComponent distance = Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_slider.distance");
        this.bubblesSlider = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)new BubblesSlider(x + 61, y + 45, 108, 24, (Component)distance, (Component)Component.literal((String)""), 0.0, 16.0, bubblesDistance, 1.0, 0, true));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        WarpPipeBlockEntity pipeBlockEntity;
        WarpPipeBlockEntity pipeBlockEntity2;
        BlockState state;
        WarpPipeBlockEntity pipeBlockEntity3;
        super.renderTooltip(graphics, mouseX, mouseY);
        MutableComponent tooltip = Component.literal((String)"");
        BlockEntity blockEntity = this.world.getBlockEntity(this.getClickedPos());
        Player player = this.inventory.player;
        tooltip = this.getClickedPos() != null && blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity3 = (WarpPipeBlockEntity)blockEntity).isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.rename_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.rename_button.tooltip");
        this.renameButton.setTooltip(Tooltip.create((Component)tooltip));
        if (this.getClickedPos() != null) {
            state = this.world.getBlockState(this.getClickedPos());
            tooltip = state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() ? (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() ? Component.translatable((String)"menu.marioverse.warp_pipe.open_button_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity2 = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() ? Component.translatable((String)"menu.marioverse.warp_pipe.open_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.open_button.tooltip"))) : (!player.isCreative() && (Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.close_button_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.close_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.close_button.tooltip")));
        }
        this.closeButton.setTooltip(Tooltip.create((Component)tooltip));
        if (this.getClickedPos() != null) {
            state = this.world.getBlockState(this.getClickedPos());
            tooltip = state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() ? (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() ? Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_off_button_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity2 = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() ? Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_off_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_off_button.tooltip"))) : (!player.isCreative() && (Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_on_button_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_on_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_on_button.tooltip")));
        }
        this.waterSpoutButton.setTooltip(Tooltip.create((Component)tooltip));
        if (this.getClickedPos() != null) {
            tooltip = !player.isCreative() && (Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_slider_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity3 = (WarpPipeBlockEntity)blockEntity).isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_slider_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.water_spout_slider.tooltip"));
        }
        this.waterSpoutSlider.setTooltip(Tooltip.create((Component)tooltip));
        if (this.getClickedPos() != null) {
            state = this.world.getBlockState(this.getClickedPos());
            tooltip = state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.BUBBLES)).booleanValue() ? (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() ? Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_off_button_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity2 = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() ? Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_off_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_off_button.tooltip"))) : (!player.isCreative() && (Boolean)ConfigRegistry.CREATIVE_BUBBLES.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_on_button_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_on_button_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_on_button.tooltip")));
        }
        this.bubblesButton.setTooltip(Tooltip.create((Component)tooltip));
        if (this.getClickedPos() != null) {
            tooltip = !player.isCreative() && (Boolean)ConfigRegistry.CREATIVE_BUBBLES.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_slider_creative.tooltip") : (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity3 = (WarpPipeBlockEntity)blockEntity).isWaxed() && (Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get() != false ? Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_slider_waxed.tooltip") : Component.translatable((String)"menu.marioverse.warp_pipe.bubbles_slider.tooltip"));
        }
        this.bubblesSlider.setTooltip(Tooltip.create((Component)tooltip));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.waterSpoutSlider.isFocused()) {
            this.waterSpoutSliderOnPress();
        }
        if (this.bubblesSlider.isFocused()) {
            this.bubblesSliderOnPress();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int b, int c) {
        if (this.waterSpoutSlider.isFocused() && (keyCode == 257 || keyCode == 335)) {
            this.waterSpoutSliderOnPress();
            return false;
        }
        if (this.bubblesSlider.isFocused() && (keyCode == 257 || keyCode == 335)) {
            this.bubblesSliderOnPress();
            return false;
        }
        if (this.renameBox.isFocused() && (keyCode == 256 || keyCode == 257 || keyCode == 335)) {
            if (keyCode == 257 || keyCode == 335) {
                String pipeRename = this.renameBox.getValue();
                if (!pipeRename.equals(this.pipeName) && this.renameBox.isVisible() && !this.renameBox.getValue().equals("") && this.getClickedPos() != null) {
                    PacketHandler.sendToServer(new RenamePipePayload(this.getClickedPos(), this.renameBox.getValue()));
                    this.pipeName = pipeRename;
                }
                if (this.renameBox.visible) {
                    this.renameBox.setVisible(false);
                }
            }
            this.renameBox.setFocused(false);
            return false;
        }
        if (this.renameBox.isFocused() && keyCode == 69) {
            this.renameBox.setFocused(true);
            return true;
        }
        return super.keyPressed(keyCode, b, c);
    }

    public BlockPos getClickedPos() {
        return lastClickedPos;
    }

    public void renameButtonOnPress() {
        WarpPipeBlockEntity pipeBlockEntity;
        Player player = this.inventory.player;
        String pipeRename = this.renameBox.getValue();
        BlockEntity blockEntity = this.world.getBlockEntity(this.getClickedPos());
        if (this.getClickedPos() != null) {
            if (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.rename_pipes.pipe_waxed").withStyle(ChatFormatting.RED), true);
            } else if (!pipeRename.equals(this.pipeName) && this.renameBox.visible && this.renameBox.isFocused()) {
                PacketHandler.sendToServer(new RenamePipePayload(this.getClickedPos(), this.renameBox.getValue()));
                this.pipeName = pipeRename;
            }
        }
        if (blockEntity instanceof WarpPipeBlockEntity && !(pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
            this.renameBox.setVisible(!this.renameBox.visible);
        } else if (!((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue()) {
            this.renameBox.setVisible(!this.renameBox.visible);
        }
    }

    public void closeButtonOnPress() {
        Player player = this.inventory.player;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && this.getClickedPos() != null) {
            WarpPipeBlockEntity pipeBlockEntity;
            BlockEntity blockEntity = world.getBlockEntity(this.getClickedPos());
            if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_CLOSE_PIPES.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.close_pipes.requires_creative").withStyle(ChatFormatting.RED), true);
            } else if (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.rename_pipes.pipe_waxed").withStyle(ChatFormatting.RED), true);
            } else {
                PacketHandler.sendToServer(new ClosePipeButtonPayload(this.getClickedPos(), Boolean.TRUE));
            }
        }
    }

    public void bubblesButtonOnPress() {
        Player player = this.inventory.player;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && this.getClickedPos() != null) {
            WarpPipeBlockEntity pipeBlockEntity;
            BlockEntity blockEntity = world.getBlockEntity(this.getClickedPos());
            if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.pipe_bubbles.requires_creative").withStyle(ChatFormatting.RED), true);
            } else if (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.rename_pipes.pipe_waxed").withStyle(ChatFormatting.RED), true);
            } else {
                PacketHandler.sendToServer(new PipeBubblesButtonPayload(this.getClickedPos(), Boolean.TRUE));
            }
        }
    }

    public void bubblesSliderOnPress() {
        Player player = this.inventory.player;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && this.getClickedPos() != null) {
            WarpPipeBlockEntity pipeBlockEntity;
            BlockEntity blockEntity = world.getBlockEntity(this.getClickedPos());
            if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_BUBBLES.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.pipe_bubbles.requires_creative").withStyle(ChatFormatting.RED), true);
            } else if (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.rename_pipes.pipe_waxed").withStyle(ChatFormatting.RED), true);
            } else if (this.bubblesSlider.isFocused()) {
                int bubblesDistance = this.bubblesSlider.getValueInt();
                BlockPos clickedPos = this.getClickedPos();
                PacketHandler.sendToServer(new PipeBubblesSliderPayload(clickedPos, bubblesDistance));
            }
        }
    }

    public void waterSpoutButtonOnPress() {
        Player player = this.inventory.player;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && this.getClickedPos() != null) {
            BlockState state;
            WarpPipeBlockEntity pipeBlockEntity;
            BlockEntity blockEntity = world.getBlockEntity(this.getClickedPos());
            if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.water_spouts.requires_creative").withStyle(ChatFormatting.RED), true);
            } else if (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.rename_pipes.pipe_waxed").withStyle(ChatFormatting.RED), true);
            } else {
                PacketHandler.sendToServer(new WaterSpoutButtonPayload(this.getClickedPos(), Boolean.TRUE));
            }
            if ((!((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() || ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && !player.isCreative()) && (state = world.getBlockState(this.getClickedPos())).getBlock() instanceof ClearWarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !((Boolean)state.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.water_spouts.requires_waterlogging").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    public void waterSpoutSliderOnPress() {
        Player player = this.inventory.player;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && this.getClickedPos() != null) {
            WarpPipeBlockEntity pipeBlockEntity;
            BlockEntity blockEntity = world.getBlockEntity(this.getClickedPos());
            if (!player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WATER_SPOUT.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.water_spouts.requires_creative").withStyle(ChatFormatting.RED), true);
            } else if (blockEntity instanceof WarpPipeBlockEntity && (pipeBlockEntity = (WarpPipeBlockEntity)blockEntity).isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() && world.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.rename_pipes.pipe_waxed").withStyle(ChatFormatting.RED), true);
            } else if (this.waterSpoutSlider.isFocused()) {
                int spoutHeight = this.waterSpoutSlider.getValueInt();
                BlockPos clickedPos = this.getClickedPos();
                PacketHandler.sendToServer(new WaterSpoutSliderPayload(clickedPos, spoutHeight));
            }
        }
    }
}

