/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wenxin2.marioverse.client.models.entities.HeftyGoombaModel;
import com.wenxin2.marioverse.entities.HeftyGoombaEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class HeftyGoombaRenderer
extends GeoEntityRenderer<HeftyGoombaEntity> {
    private static final String HELMET = "armorBipedHead";

    public HeftyGoombaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new HeftyGoombaModel());
        this.shadowRadius = 1.0f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<HeftyGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, HeftyGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case HeftyGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, HeftyGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case HeftyGoombaRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, HeftyGoombaEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case HeftyGoombaRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(2.01f, 2.0f, 1.975f);
                poseStack.translate(0.0f, -0.535f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<HeftyGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, HeftyGoombaEntity animatable) {
                BlockItem blockItem;
                Object object;
                if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (object = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)object).getBlock() instanceof SkullBlock)) {
                    return switch (bone.getName()) {
                        case HeftyGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                        default -> null;
                    };
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, HeftyGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case HeftyGoombaRenderer.HELMET -> ItemDisplayContext.HEAD;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, HeftyGoombaEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.scale(1.3f, 1.2f, 1.185f);
                poseStack.translate(0.0f, 0.5f, 0.0f);
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(HeftyGoombaEntity animatable) {
        return 0.0f;
    }
}

