/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.registries.TextureRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SuperStarLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public SuperStarLayer(EntityRenderer<? extends Player> parent) {
        super((RenderLayerParent)parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AbilitiesHandler handler;
        if (entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$hasSuperStar()) {
            float alpha = 1.0f;
            Minecraft.getInstance().getTextureManager().getTexture(TextureRegistry.SUPER_STAR_OVERLAY);
            VertexConsumer consumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TextureRegistry.SUPER_STAR_OVERLAY));
            poseStack.pushPose();
            this.getParentModel().renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f));
            poseStack.popPose();
        }
    }
}

