/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.wenxin2.marioverse.items.DashMushroomItem;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.sounds.FadingSoundInstance;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.VehicleEntity;

public class PowerUpCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"powerup").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((LiteralArgumentBuilder)Commands.literal((String)"fire_flower").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "fire_flower"))).then(Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PowerUpCommand.applyPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "fire_flower", BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"ice_flower").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "ice_flower"))).then(Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PowerUpCommand.applyPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "ice_flower", BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"super_mushroom").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "super_mushroom"))).then(((RequiredArgumentBuilder)Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"manualOverride", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PowerUpCommand.applyMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), BoolArgumentType.getBool((CommandContext)ctx, (String)"manualOverride"))))).executes(ctx -> PowerUpCommand.applyMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"dash_mushroom").then(Commands.argument((String)"boostStrength", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)50.0)).executes(ctx -> PowerUpCommand.applyDashMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"boostStrength"))))).executes(ctx -> PowerUpCommand.applyDashMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), 1.0)))).then(((LiteralArgumentBuilder)Commands.literal((String)"super_star").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "super_star"))).then(((RequiredArgumentBuilder)Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"cooldownTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> PowerUpCommand.applySuperStar((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cooldownTicks"))))).executes(ctx -> PowerUpCommand.applySuperStar((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), -1))))));
    }

    private static void applyPowerUpType(AbilitiesHandler handler, String powerUpName, boolean enablePowerUp) {
        switch (powerUpName) {
            case "fire_flower": {
                handler.mv$setFireFlower(enablePowerUp);
                break;
            }
            case "ice_flower": {
                handler.mv$setIceFlower(enablePowerUp);
            }
        }
    }

    private static int applyPowerUp(CommandSourceStack source, Collection<? extends Entity> targets, String powerUpName, boolean enablePowerUp) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity && entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                PowerUpCommand.applyPowerUpType(handler, powerUpName, enablePowerUp);
                ++count;
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                if (count != 1) continue;
                switch (powerUpName) {
                    case "fire_flower": {
                        source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$13((Component)powerUpBoolean, entity), true);
                        break;
                    }
                    case "ice_flower": {
                        source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$14((Component)powerUpBoolean, entity), true);
                    }
                }
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            switch (powerUpName) {
                case "fire_flower": {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$16((Component)powerUpBoolean, finalCount), true);
                    break;
                }
                case "ice_flower": {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$17((Component)powerUpBoolean, finalCount), true);
                }
            }
        }
        return count;
    }

    private static int applyMushroom(CommandSourceStack source, Collection<? extends Entity> targets, boolean enablePowerUp, boolean manualOverride) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity && entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                handler.mv$setSuperMushroom(enablePowerUp);
                handler.mv$setMushroomOverride(manualOverride);
                ++count;
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                } else {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                if (count != 1) continue;
                source.sendSuccess(() -> PowerUpCommand.lambda$applyMushroom$18((Component)powerUpBoolean, entity), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            source.sendSuccess(() -> PowerUpCommand.lambda$applyMushroom$20((Component)powerUpBoolean, finalCount), true);
        }
        return count;
    }

    private static int applyDashMushroom(CommandSourceStack source, Collection<? extends Entity> targets, double boostStrength) {
        int count = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof AbilitiesHandler) {
                    AbilitiesHandler handler = (AbilitiesHandler)entity;
                    handler.mv$setDashMushroomBoost(true);
                    DashMushroomItem.mushroomAbilities(null, livingEntity.level(), livingEntity, boostStrength, false, true);
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                    if (++count != 1) continue;
                    if (entity.getVehicle() != null) {
                        source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.dash_mushroom", (Object[])new Object[]{boostStrength, entity.getVehicle().getDisplayName()}), true);
                        continue;
                    }
                    source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.dash_mushroom", (Object[])new Object[]{boostStrength, entity.getDisplayName()}), true);
                    continue;
                }
            }
            if (entity instanceof VehicleEntity) {
                source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up_boost.fail", (Object[])new Object[]{entity.getDisplayName()}).withStyle(ChatFormatting.RED), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.dash_mushroom.count", (Object[])new Object[]{boostStrength, finalCount}), true);
        }
        return count;
    }

    private static int applySuperStar(CommandSourceStack source, Collection<? extends Entity> targets, boolean enablePowerUp, int cooldownTicks) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof AbilitiesHandler) {
                    AbilitiesHandler handler = (AbilitiesHandler)entity;
                    handler.mv$setSuperStar(enablePowerUp);
                    ++count;
                    if (enablePowerUp) {
                        entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP_SUPER_STAR.get(), SoundSource.AMBIENT);
                    }
                    if (cooldownTicks >= 0) {
                        handler.mv$setSuperStarCooldown(cooldownTicks);
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, cooldownTicks, 4, true, false));
                        if (!handler.mv$playedSuperStarTheme()) {
                            Minecraft.getInstance().getSoundManager().play((SoundInstance)new FadingSoundInstance(livingEntity, (SoundEvent)SoundRegistry.SUPER_STAR_THEME.get(), SoundSource.AMBIENT, entity.getRandom(), cooldownTicks, 100.0f));
                        }
                        handler.mv$setPlayedSuperStarTheme(true);
                    } else {
                        handler.mv$setSuperStarCooldown((Integer)ConfigRegistry.SUPER_STAR_DURATION.get());
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, ((Integer)ConfigRegistry.SUPER_STAR_SPEED_DURATION.get()).intValue(), 4, true, false));
                    }
                    if (count != 1) continue;
                    if (enablePowerUp) {
                        source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$26((Component)powerUpBoolean, entity, cooldownTicks), true);
                        continue;
                    }
                    source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$27((Component)powerUpBoolean, entity), true);
                    continue;
                }
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            if (enablePowerUp) {
                source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$29((Component)powerUpBoolean, finalCount, cooldownTicks), true);
            } else {
                source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$30((Component)powerUpBoolean, finalCount), true);
            }
        }
        return count;
    }

    private static int hasPowerUp(CommandSourceStack source, Collection<? extends Entity> targets, String powerUpName) {
        int count = 0;
        int falseCount = 0;
        ArrayList<MutableComponent> singleResults = new ArrayList<MutableComponent>();
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity) || !(entity instanceof AbilitiesHandler)) continue;
            AbilitiesHandler handler = (AbilitiesHandler)entity;
            boolean hasPowerUp = switch (powerUpName) {
                case "fire_flower" -> handler.mv$hasFireFlower();
                case "ice_flower" -> handler.mv$hasIceFlower();
                case "super_mushroom" -> handler.mv$hasSuperMushroom();
                case "super_star" -> handler.mv$hasSuperStar();
                default -> false;
            };
            MutableComponent powerUpBoolean = Component.translatable((String)(hasPowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
            if (hasPowerUp) {
                ++count;
            } else {
                ++falseCount;
            }
            if (targets.size() != 1) continue;
            singleResults.add(Component.translatable((String)("commands.marioverse.power_up." + powerUpName + ".value"), (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()}));
        }
        if (singleResults.size() == 1) {
            source.sendSuccess(singleResults::getFirst, true);
        }
        if (targets.size() > 1) {
            MutableComponent powerUpBoolean;
            if (count > 0) {
                powerUpBoolean = Component.translatable((String)"commands.marioverse.boolean.true");
                int n = count;
                source.sendSuccess(() -> PowerUpCommand.lambda$hasPowerUp$31(powerUpName, (Component)powerUpBoolean, n), true);
            }
            if (falseCount > 0) {
                powerUpBoolean = Component.translatable((String)"commands.marioverse.boolean.false");
                int n = falseCount;
                source.sendSuccess(() -> PowerUpCommand.lambda$hasPowerUp$32(powerUpName, (Component)powerUpBoolean, n), true);
            }
        }
        return count + falseCount;
    }

    private static /* synthetic */ Component lambda$hasPowerUp$32(String powerUpName, Component powerUpBoolean, int finalFalseCount) {
        return Component.translatable((String)("commands.marioverse.power_up." + powerUpName + ".value.count"), (Object[])new Object[]{powerUpBoolean, finalFalseCount});
    }

    private static /* synthetic */ Component lambda$hasPowerUp$31(String powerUpName, Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)("commands.marioverse.power_up." + powerUpName + ".value.count"), (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applySuperStar$30(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applySuperStar$29(Component powerUpBoolean, int finalCount, int cooldownTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star.ticks.count", (Object[])new Object[]{powerUpBoolean, finalCount, cooldownTicks});
    }

    private static /* synthetic */ Component lambda$applySuperStar$27(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applySuperStar$26(Component powerUpBoolean, Entity entity, int cooldownTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star.ticks", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName(), cooldownTicks});
    }

    private static /* synthetic */ Component lambda$applyMushroom$20(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.super_mushroom.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyMushroom$18(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.super_mushroom", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$17(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.ice_flower.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$16(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.fire_flower.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$14(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.ice_flower", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$13(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.fire_flower", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }
}

