/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.controls;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class AmphibiousMoveControl
extends MoveControl {
    private static final float FULL_SPEED_TURN_THRESHOLD = 10.0f;
    private static final float STOP_TURN_THRESHOLD = 60.0f;
    private final int maxTurnX;
    private final int maxTurnY;
    private final float inWaterSpeedModifier;
    private final float outsideWaterSpeedModifier;
    private final boolean applyGravity;
    private final PathfinderMob mob;

    public AmphibiousMoveControl(PathfinderMob mob, int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
        super((Mob)mob);
        this.mob = mob;
        this.maxTurnX = maxTurnX;
        this.maxTurnY = maxTurnY;
        this.inWaterSpeedModifier = inWaterSpeedModifier;
        this.outsideWaterSpeedModifier = outsideWaterSpeedModifier;
        this.applyGravity = applyGravity;
    }

    public void tick() {
        if (this.mob.isInWaterOrBubble()) {
            this.moveInWater(this.mob.isInWaterOrBubble());
        } else {
            this.moveOnLand();
        }
    }

    private void moveOnLand() {
        super.tick();
    }

    private void moveInWater(boolean inWater) {
        double d2;
        double d1;
        if (this.applyGravity && this.mob.isInWater()) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation != MoveControl.Operation.MOVE_TO || this.mob.getNavigation().isDone()) {
            this.resetMovement();
            return;
        }
        double d0 = this.wantedX - this.mob.getX();
        double d3 = d0 * d0 + (d1 = this.wantedY - this.mob.getY()) * d1 + (d2 = this.wantedZ - this.mob.getZ()) * d2;
        if (d3 < (double)2.5E-7f) {
            this.resetMovement();
        } else {
            float targetYaw = (float)(Mth.atan2((double)d2, (double)d0) * 180.0 / Math.PI) - 90.0f;
            this.updateRotation(targetYaw);
            float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
            if (inWater) {
                this.handleWaterMovement(d0, d1, d2, speed);
            } else {
                this.handleLandMovement(targetYaw, speed);
            }
        }
    }

    private void handleWaterMovement(double d0, double d1, double d2, float speed) {
        this.mob.setSpeed(speed * this.inWaterSpeedModifier);
        double horizontalDistance = Math.sqrt(d0 * d0 + d2 * d2);
        if (Math.abs(d1) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
            float pitch = -((float)(Mth.atan2((double)d1, (double)horizontalDistance) * 180.0 / Math.PI));
            pitch = Mth.clamp((float)Mth.wrapDegrees((float)pitch), (float)(-this.maxTurnX), (float)this.maxTurnX);
            this.mob.setXRot(this.rotlerp(this.mob.getXRot(), pitch, 5.0f));
        }
        float cosPitch = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
        float sinPitch = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
        this.mob.zza = cosPitch * speed;
        this.mob.yya = -sinPitch * speed;
    }

    private void handleLandMovement(float targetYaw, float speed) {
        float turnSpeed = Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - targetYaw)));
        float speedModifier = AmphibiousMoveControl.getTurningSpeedFactor(turnSpeed);
        this.mob.setSpeed(speed * this.outsideWaterSpeedModifier * speedModifier);
    }

    private void resetMovement() {
        this.mob.setSpeed(0.0f);
        this.mob.setXxa(0.0f);
        this.mob.setYya(0.0f);
        this.mob.setZza(0.0f);
    }

    private void updateRotation(float targetYaw) {
        float rotation = this.rotlerp(this.mob.getYRot(), targetYaw, this.maxTurnY);
        this.mob.setYRot(rotation);
        this.mob.yBodyRot = rotation;
        this.mob.yHeadRot = rotation;
    }

    private static float getTurningSpeedFactor(float turnSpeed) {
        return 1.0f - Mth.clamp((float)((turnSpeed - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }
}

