/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.projectiles;

import com.wenxin2.marioverse.entities.IceCubeEntity;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.entities.part_entities.PiranhaPlantPart;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BouncingFireballProjectile
extends ThrowableProjectile
implements GeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.bouncing_fireball.idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BouncingFireballProjectile(EntityType<? extends BouncingFireballProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 0, state -> state.setAndContinue(IDLE)));
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        this.collideWithEntity();
        if (!this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(motion.x, -0.04, motion.y));
        }
        if (motion.length() > 0.0) {
            this.setYRot((float)Math.toDegrees(Math.atan2(motion.z, motion.x)) + 270.0f);
            this.setXRot((float)Math.toDegrees(Math.atan2(-motion.y, Math.sqrt(motion.x * motion.x + motion.z * motion.z))));
        }
        if (this.onGround() || this.tickCount > 400) {
            this.discardEffects();
        }
        for (int i = 0; i < 1; ++i) {
            double x = this.getX();
            double y = this.getY() + (double)(this.getBbHeight() / 2.0f);
            double z = this.getZ();
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            if (!this.level().getFluidState(this.blockPosition()).is(FluidTags.WATER)) continue;
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void onHitBlock(BlockHitResult hit) {
        Level world = this.level();
        BlockPos hitPos = hit.getBlockPos();
        BlockState state = this.level().getBlockState(hitPos);
        BlockState stateAbove = this.level().getBlockState(hitPos.above());
        if (hit.getDirection().getAxis() == Direction.Axis.X || hit.getDirection().getAxis() == Direction.Axis.Z) {
            this.discardEffectsOnSideHit(world, hitPos);
        } else {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x, 0.4, motion.z);
            this.bounceEffects(world, hitPos);
        }
        if (state.is(Blocks.SNOW)) {
            ParticleUtils.spawnParticleOnFace((Level)world, (BlockPos)hitPos, (Direction)Direction.UP, (ParticleOptions)ParticleTypes.WHITE_SMOKE, (Vec3)Vec3.ZERO, (double)5.0);
            world.removeBlock(hitPos, Boolean.FALSE.booleanValue());
        } else if (state.is(TagRegistry.MELTS)) {
            world.removeBlock(hitPos, Boolean.FALSE.booleanValue());
        } else if (stateAbove.is(Blocks.SNOW) || stateAbove.is(Blocks.POWDER_SNOW)) {
            ParticleUtils.spawnParticleOnFace((Level)world, (BlockPos)hitPos.above(), (Direction)Direction.UP, (ParticleOptions)ParticleTypes.WHITE_SMOKE, (Vec3)Vec3.ZERO, (double)5.0);
            world.removeBlock(hitPos.above(), Boolean.FALSE.booleanValue());
        } else if (state.is(TagRegistry.MELTS_INTO_WATER)) {
            world.setBlock(hitPos, Blocks.WATER.defaultBlockState(), 3);
        } else if (state.is(TagRegistry.MELTS_INTO_ICE)) {
            world.setBlock(hitPos, Blocks.ICE.defaultBlockState(), 3);
        } else if (state.is(TagRegistry.MELTS_INTO_PACKED_ICE)) {
            world.setBlock(hitPos, Blocks.PACKED_ICE.defaultBlockState(), 3);
        } else if (state.is(TagRegistry.FIREBALL_SETS_ON_FIRE) && state.getBlock() instanceof TntBlock) {
            PrimedTnt primedtnt = new PrimedTnt(world, (double)hitPos.getX() + 0.5, (double)hitPos.getY(), (double)hitPos.getZ() + 0.5, null);
            world.removeBlock(hitPos, Boolean.FALSE.booleanValue());
            world.addFreshEntity((Entity)primedtnt);
        } else if (state.is(TagRegistry.FIREBALL_SETS_ON_FIRE) && state.hasProperty((Property)BlockStateProperties.LIT)) {
            world.setBlock(hitPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 3);
        } else if (state.is(BlockTags.SOUL_FIRE_BASE_BLOCKS) && world.getBlockState(hitPos.above()).isAir()) {
            world.setBlock(hitPos.above(), Blocks.SOUL_FIRE.defaultBlockState(), 3);
        } else if (state.is(TagRegistry.FIREBALL_SETS_ON_FIRE) && world.getBlockState(hitPos.above()).isAir()) {
            world.setBlock(hitPos.above(), Blocks.FIRE.defaultBlockState(), 3);
        } else if (state.is(Blocks.OBSIDIAN) && world.getBlockState(hitPos.above()).isAir()) {
            world.setBlock(hitPos.above(), Blocks.FIRE.defaultBlockState(), 3);
        } else if (state.is(Blocks.WET_SPONGE)) {
            world.setBlock(hitPos, Blocks.SPONGE.defaultBlockState(), 3);
        }
        super.onHitBlock(hit);
    }

    protected void onHitEntity(EntityHitResult hit) {
        Level level;
        PiranhaPlantPart partEntity;
        LivingEntity livingEntity;
        Player player;
        Entity entity = hit.getEntity();
        Level world = this.level();
        BlockPos pos = this.blockPosition();
        if (entity instanceof Player && !(player = (Player)entity).isSpectator() && !player.fireImmune() && player != this.getOwner() && !player.getType().is(TagRegistry.FIREBALL_IMMUNE)) {
            ItemStack shield = player.getUseItem();
            if (this.getOwner() != null && player.getTeam() != null && this.getOwner().getTeam() != null && player.getTeam() == this.getOwner().getTeam()) {
                return;
            }
            if (this.getOwner() != null && player.isDamageSourceBlocked(DamageTypeRegistry.fireball(entity, this.getOwner()))) {
                AbilitiesHandler handler;
                if (shield.getItem() instanceof ShieldItem || entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$hasFireFlower()) {
                    this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
                    this.setDeltaMovement(this.getDeltaMovement().reverse());
                    shield.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    world.playSound(null, pos, SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (this.getOwner() != null) {
                if (player.getType().is(TagRegistry.FIREBALL_CAN_INSTAKILL)) {
                    player.hurt(DamageTypeRegistry.fireball(entity, this.getOwner()), player.getHealth() * 1.25f);
                } else {
                    player.hurt(DamageTypeRegistry.fireball(entity, this.getOwner()), ((Double)ConfigRegistry.FIREBALL_DAMAGE.get()).floatValue());
                }
                player.igniteForSeconds(2.0f);
            }
            world.playSound(null, pos, (SoundEvent)SoundRegistry.FIREBALL_EXTINGUISHED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, this.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).fireImmune() && livingEntity != this.getOwner() && !livingEntity.getType().is(TagRegistry.FIREBALL_IMMUNE)) {
            TamableAnimal tamableAnimal;
            ItemStack shield = livingEntity.getUseItem();
            if (livingEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)livingEntity).getOwner() == this.getOwner() || this.getOwner() != null && livingEntity.getTeam() != null && this.getOwner().getTeam() != null && livingEntity.getTeam() == this.getOwner().getTeam()) {
                return;
            }
            if (this.getOwner() != null && livingEntity.isDamageSourceBlocked(DamageTypeRegistry.fireball(entity, this.getOwner()))) {
                AbilitiesHandler handler;
                if (shield.getItem() instanceof ShieldItem || entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$hasFireFlower()) {
                    this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
                    this.setDeltaMovement(this.getDeltaMovement().reverse());
                    shield.hurtAndBreak(1, livingEntity, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
                    world.playSound(null, pos, SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getOwner() != null) {
                if (livingEntity.getType().is(TagRegistry.FIREBALL_CAN_INSTAKILL)) {
                    livingEntity.hurt(DamageTypeRegistry.fireball(entity, this.getOwner()), livingEntity.getHealth() * 1.25f);
                } else {
                    livingEntity.hurt(DamageTypeRegistry.fireball(entity, this.getOwner()), ((Double)ConfigRegistry.FIREBALL_DAMAGE.get()).floatValue());
                }
                livingEntity.igniteForSeconds(2.0f);
            }
            world.playSound(null, pos, (SoundEvent)SoundRegistry.FIREBALL_EXTINGUISHED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, this.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (entity instanceof PiranhaPlantPart && !(partEntity = (PiranhaPlantPart)entity).fireImmune() && partEntity != this.getOwner() && !partEntity.getType().is(TagRegistry.FIREBALL_IMMUNE)) {
            ItemStack shield = ((PiranhaPlantEntity)partEntity.getParent()).getUseItem();
            if (this.getOwner() != null && ((PiranhaPlantEntity)partEntity.getParent()).isDamageSourceBlocked(DamageTypeRegistry.fireball(entity, this.getOwner()))) {
                AbilitiesHandler handler;
                if (shield.getItem() instanceof ShieldItem || entity instanceof AbilitiesHandler && (handler = (AbilitiesHandler)entity).mv$hasFireFlower()) {
                    this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
                    this.setDeltaMovement(this.getDeltaMovement().reverse());
                    shield.hurtAndBreak(1, (LivingEntity)partEntity.getParent(), LivingEntity.getSlotForHand((InteractionHand)((PiranhaPlantEntity)partEntity.getParent()).getUsedItemHand()));
                    world.playSound(null, pos, SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getOwner() != null) {
                if (partEntity.getType().is(TagRegistry.FIREBALL_CAN_INSTAKILL)) {
                    partEntity.hurt(DamageTypeRegistry.fireball(entity, this.getOwner()), ((PiranhaPlantEntity)partEntity.getParent()).getHealth() * 1.25f);
                } else {
                    partEntity.hurt(DamageTypeRegistry.fireball(entity, this.getOwner()), ((Double)ConfigRegistry.FIREBALL_DAMAGE.get()).floatValue());
                }
                partEntity.igniteForSeconds(2.0f);
            }
            world.playSound(null, pos, (SoundEvent)SoundRegistry.FIREBALL_EXTINGUISHED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, this.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (entity instanceof MinecartTNT) {
            MinecartTNT tnt = (MinecartTNT)entity;
            tnt.activateMinecart(0, 0, 0, Boolean.TRUE.booleanValue());
        } else if (entity instanceof IceCubeEntity) {
            IceCubeEntity iceCube = (IceCubeEntity)entity;
            iceCube.shatterIceCube(false, false, (Entity)this);
            world.playSound(null, pos, (SoundEvent)SoundRegistry.FIREBALL_EXTINGUISHED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            Level level2 = this.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level2;
                ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SMOKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
            }
            world.gameEvent(entity, (Holder)GameEvent.PROJECTILE_LAND, this.position());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (entity instanceof Player && !(player = (Player)entity).isSpectator() && !player.fireImmune() && player != this.getOwner() && !player.getType().is(TagRegistry.FIREBALL_IMMUNE)) {
            level = this.level();
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SMOKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
                ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.FLAME, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.1, 10);
            }
        } else if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).fireImmune() && livingEntity != this.getOwner() && !livingEntity.getType().is(TagRegistry.FIREBALL_IMMUNE) && (level = this.level()) instanceof ServerLevel) {
            serverWorld = (ServerLevel)level;
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SMOKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.FLAME, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.1, 10);
        }
    }

    public boolean deflect(@NotNull ProjectileDeflection deflection, @Nullable Entity entity, @Nullable Entity owner, boolean shouldDeflect) {
        if (entity instanceof LivingEntity && !this.level().isClientSide) {
            deflection.deflect((Projectile)this, entity, this.random);
            this.setOwner(entity);
            this.onDeflection(entity, shouldDeflect);
            return true;
        }
        return false;
    }

    public void bounceEffects(Level world, BlockPos pos) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ServerParticleUtils.spawnParticleRingBelowEntity((ParticleOptions)ParticleTypes.SMOKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
        }
        world.playSound(null, pos, (SoundEvent)SoundRegistry.FIREBALL_SIZZLES.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        world.gameEvent(this.getOwner(), (Holder)GameEvent.PROJECTILE_LAND, pos);
    }

    public void discardEffects() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SMOKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
        }
        this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.FIREBALL_EXTINGUISHED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        this.level().gameEvent(this.getOwner(), (Holder)GameEvent.PROJECTILE_LAND, this.position());
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void discardEffectsOnSideHit(Level world, BlockPos hitPos) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.SMOKE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.0, 10);
            ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.FLAME, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.1, 10);
            if (this.level().getFluidState(this.blockPosition()).is(FluidTags.WATER)) {
                ServerParticleUtils.spawnParticleRingOnEntity((ParticleOptions)ParticleTypes.BUBBLE, serverWorld, (Entity)this, this.getBbWidth() / 2.0f, 0.1, 10);
            }
        }
        world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.FIREBALL_EXTINGUISHED.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        world.gameEvent(this.getOwner(), (Holder)GameEvent.PROJECTILE_LAND, hitPos);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void collideWithEntity() {
        AABB collisionBox = this.getBoundingBox().inflate(0.01, 0.0, 0.01);
        List collidingEntities = this.level().getEntities((Entity)this, collisionBox);
        for (Entity entity : collidingEntities) {
            if (!(entity instanceof Breeze)) continue;
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), true);
            this.level().playSound(null, entity.blockPosition(), SoundEvents.BREEZE_DEFLECT, entity.getSoundSource(), 1.0f, 1.0f);
            return;
        }
    }
}

