/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.event_handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.wenxin2.marioverse.commands.PowerUpCommand;
import com.wenxin2.marioverse.datagen.AdvancementDataGen;
import com.wenxin2.marioverse.datagen.BannerPatternTagsGen;
import com.wenxin2.marioverse.datagen.BiomeTagsGen;
import com.wenxin2.marioverse.datagen.BlockLootTableGen;
import com.wenxin2.marioverse.datagen.BlockStateGen;
import com.wenxin2.marioverse.datagen.BlockTagsGen;
import com.wenxin2.marioverse.datagen.DamageTypeTagsGen;
import com.wenxin2.marioverse.datagen.DataMapGen;
import com.wenxin2.marioverse.datagen.EntityTypeTagsGen;
import com.wenxin2.marioverse.datagen.FluidTagsGen;
import com.wenxin2.marioverse.datagen.ItemModelGen;
import com.wenxin2.marioverse.datagen.ItemTagsGen;
import com.wenxin2.marioverse.datagen.RecipeGen;
import com.wenxin2.marioverse.registries.BannerPatternRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;

@EventBusSubscriber(modid="marioverse")
public class RegistryEventHandlers {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        PowerUpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTagsGen blockTags = new BlockTagsGen(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGen(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGen(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementDataGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().add(Registries.BANNER_PATTERN, BannerPatternRegistry::bootstrap).add(Registries.DAMAGE_TYPE, DamageTypeRegistry::bootstrap), Set.of("marioverse")));
        generator.addProvider(event.includeServer(), (DataProvider)new BannerPatternTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockLootTableGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTypeTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGen(output, lookupProvider, blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTagsGen(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagsGen(output, lookupProvider, existingFileHelper));
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() == VillagerProfession.CARTOGRAPHER) {
            for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.GOAL_POLES.entrySet()) {
                ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)entry.getValue(), 1), 15, 16, 0.05f));
            }
            for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHECKPOINT_FLAGS.entrySet()) {
                ((List)trades.get(3)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)entry.getValue(), 1), 15, 16, 0.05f));
            }
            ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack(BlockRegistry.CLASSIC_GOAL_POLE, 1), 10, 30, 0.05f));
            ((List)trades.get(5)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack(BlockRegistry.CLASSIC_CHECKPOINT_FLAG, 1), 10, 30, 0.05f));
        }
        if (event.getType() == VillagerProfession.CLERIC) {
            ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ItemRegistry.DASH_MUSHROOM.get(), 1), 5, 16, 0.05f));
            ((List)trades.get(2)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.SUPER_MUSHROOM.get(), 1), 5, 16, 0.05f));
            ((List)trades.get(4)).add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 25), new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get(), 1), 1, 30, 0.1f));
        }
    }

    @SubscribeEvent
    public static void addWandererTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.FIRE_FLOWER.get(), 1), 1, 16, 0.2f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.ICE_FLOWER.get(), 1), 1, 16, 0.2f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack(BlockRegistry.COIN, 9), 8, 10, 0.2f));
        genericTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack(BlockRegistry.STAR_COIN, 1), 8, 10, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack(BlockRegistry.CLASSIC_GOAL_POLE, 1), 8, 10, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack(BlockRegistry.CLASSIC_CHECKPOINT_FLAG, 1), 8, 10, 0.2f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 25), new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get(), 1), 1, 30, 0.1f));
        rareTrades.add((entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), new ItemStack((ItemLike)ItemRegistry.SUPER_STAR.get(), 1), 8, 10, 0.2f));
    }
}

